/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.cache.CacheManager;
import com.sap.cloud.sdk.cloudplatform.connectivity.ApacheHttpClient5Cache;
import com.sap.cloud.sdk.cloudplatform.connectivity.ApacheHttpClient5Factory;
import com.sap.cloud.sdk.cloudplatform.connectivity.ApacheHttpClient5Wrapper;
import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationUtility;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAccessor;
import com.sap.cloud.sdk.cloudplatform.security.principal.exception.PrincipalAccessException;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import io.vavr.control.Try;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.hc.client5.http.classic.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultApacheHttpClient5Cache
implements ApacheHttpClient5Cache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultApacheHttpClient5Cache.class);
    static final Duration DEFAULT_DURATION = Duration.ofHours(1L);
    static final Ticker DEFAULT_TICKER = Ticker.systemTicker();
    @Nonnull
    private final Cache<CacheKey, HttpClient> cache;

    DefaultApacheHttpClient5Cache(@Nonnull Duration cacheDuration) {
        this(cacheDuration, DEFAULT_TICKER);
    }

    DefaultApacheHttpClient5Cache(@Nonnull Duration cacheDuration, @Nonnull Ticker ticker) {
        this.cache = Caffeine.newBuilder().expireAfterAccess(cacheDuration).ticker(ticker).build();
        CacheManager.register(this.cache);
    }

    @Override
    @Nonnull
    public Try<HttpClient> tryGetHttpClient(@Nonnull HttpDestinationProperties destination, @Nonnull ApacheHttpClient5Factory httpClientFactory) {
        return this.tryGetOrCreateHttpClient(httpClientFactory, destination);
    }

    @Override
    @Nonnull
    public Try<HttpClient> tryGetHttpClient(@Nonnull ApacheHttpClient5Factory httpClientFactory) {
        return this.tryGetOrCreateHttpClient(httpClientFactory, null);
    }

    private Try<HttpClient> tryGetOrCreateHttpClient(@Nonnull ApacheHttpClient5Factory httpClientFactory, @Nullable HttpDestinationProperties destination) {
        HttpClient httpClient;
        CacheKey cacheKey;
        Supplier<HttpClient> createHttpClient = () -> {
            log.debug("HttpClient with given cache key is not yet in the cache.");
            return destination != null ? httpClientFactory.createHttpClient(destination) : httpClientFactory.createHttpClient();
        };
        try {
            cacheKey = this.getCacheKey(destination);
        }
        catch (PrincipalAccessException | TenantAccessException | IllegalStateException e) {
            String msg = "Failed to create cache key for HttpClient. Falling back to creating a new http client instance. This is unexpected and will be changed to fail instead in a future version of Cloud SDK. Please analyze the attached stack trace and resolve the issue.";
            log.error("Failed to create cache key for HttpClient. Falling back to creating a new http client instance. This is unexpected and will be changed to fail instead in a future version of Cloud SDK. Please analyze the attached stack trace and resolve the issue.", e);
            return Try.ofSupplier(createHttpClient);
        }
        try {
            httpClient = (HttpClient)this.cache.get((Object)cacheKey, anyKey -> (HttpClient)createHttpClient.get());
            Objects.requireNonNull(httpClient, "Failed to create HttpClient: The registered HttpClient5Factory unexpectedly returned null.");
        }
        catch (HttpClientInstantiationException e) {
            return Try.failure((Throwable)e);
        }
        catch (RuntimeException e) {
            return Try.failure((Throwable)new HttpClientInstantiationException((Throwable)e));
        }
        if (destination != null && httpClient instanceof ApacheHttpClient5Wrapper) {
            return Try.success((Object)((Object)((ApacheHttpClient5Wrapper)httpClient).withDestination(destination)));
        }
        return Try.success((Object)httpClient);
    }

    private CacheKey getCacheKey(@Nullable HttpDestinationProperties destination) {
        if (destination == null) {
            return CacheKey.ofTenantAndPrincipalOptionalIsolation();
        }
        if (!DefaultApacheHttpClient5Cache.requiresPrincipalIsolation(destination)) {
            return CacheKey.ofTenantOptionalIsolation().append(new Object[]{destination});
        }
        Try maybeTenant = TenantAccessor.tryGetCurrentTenant();
        Try principal = PrincipalAccessor.tryGetCurrentPrincipal();
        if (principal.isFailure()) {
            throw new IllegalStateException("The destination requires a principal, but none was found in the current context.", principal.getCause());
        }
        if (maybeTenant.isFailure()) {
            String msg = "Tenant and Principal accessors are returning inconsistent results: A principal is defined, but no tenant is defined in the current context. This is unexpected and will be changed to fail instead in a future version of Cloud SDK. Please analyze the attached stack trace and resolve the issue.";
            log.error("Tenant and Principal accessors are returning inconsistent results: A principal is defined, but no tenant is defined in the current context. This is unexpected and will be changed to fail instead in a future version of Cloud SDK. Please analyze the attached stack trace and resolve the issue.", maybeTenant.getCause());
        }
        return CacheKey.of((Tenant)((Tenant)maybeTenant.getOrNull()), (Principal)((Principal)principal.get())).append(new Object[]{destination});
    }

    private static boolean requiresPrincipalIsolation(@Nonnull HttpDestinationProperties destination) {
        return DestinationUtility.requiresUserTokenExchange((DestinationProperties)destination) || destination.getAuthenticationType() == AuthenticationType.PRINCIPAL_PROPAGATION;
    }
}

