/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.ApacheHttpClient5Factory;
import com.sap.cloud.sdk.cloudplatform.connectivity.ApacheHttpClient5Wrapper;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.cloudplatform.connectivity.SSLContextFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import io.vavr.control.Option;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultApacheHttpClient5Factory
implements ApacheHttpClient5Factory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultApacheHttpClient5Factory.class);
    static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(2L);
    static final int DEFAULT_MAX_CONNECTIONS_TOTAL = 200;
    static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 100;
    @Nonnull
    private final Timeout timeout;
    private final int maxConnectionsTotal;
    private final int maxConnectionsPerRoute;
    @Nullable
    private final HttpRequestInterceptor requestInterceptor;

    DefaultApacheHttpClient5Factory(@Nonnull Duration timeout, int maxConnectionsTotal, int maxConnectionsPerRoute) {
        this(timeout, maxConnectionsTotal, maxConnectionsPerRoute, null);
    }

    DefaultApacheHttpClient5Factory(@Nonnull Duration timeout, int maxConnectionsTotal, int maxConnectionsPerRoute, @Nullable HttpRequestInterceptor requestInterceptor) {
        this.timeout = DefaultApacheHttpClient5Factory.toTimeout(timeout);
        this.maxConnectionsTotal = maxConnectionsTotal;
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        this.requestInterceptor = requestInterceptor;
    }

    @Override
    @Nonnull
    public HttpClient createHttpClient(@Nullable HttpDestinationProperties destination) throws DestinationAccessException, HttpClientInstantiationException {
        CloseableHttpClient httpClient = this.buildHttpClient(destination);
        if (destination == null) {
            return httpClient;
        }
        return new ApacheHttpClient5Wrapper(httpClient, destination);
    }

    @Nonnull
    private CloseableHttpClient buildHttpClient(@Nullable HttpDestinationProperties destination) {
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager(this.getConnectionManager(destination)).setDefaultRequestConfig(this.getRequestConfig()).setProxy(this.getProxy(destination));
        if (this.requestInterceptor != null) {
            builder.addRequestInterceptorFirst(this.requestInterceptor);
        }
        return builder.build();
    }

    @Nonnull
    private HttpClientConnectionManager getConnectionManager(@Nullable HttpDestinationProperties destination) {
        try {
            return PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)this.getConnectionSocketFactory(destination)).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.timeout).build()).setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(this.timeout).setSocketTimeout(this.timeout).build()).setMaxConnTotal(this.maxConnectionsTotal).setMaxConnPerRoute(this.maxConnectionsPerRoute).build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new HttpClientInstantiationException("Failed to create HTTP client connection manager.", (Throwable)e);
        }
    }

    @Nonnull
    private static Timeout toTimeout(@Nonnull Duration duration) {
        return Timeout.ofMilliseconds((long)duration.toMillis());
    }

    @Nullable
    private SSLConnectionSocketFactory getConnectionSocketFactory(@Nullable HttpDestinationProperties destination) throws GeneralSecurityException, IOException {
        if (!this.supportsTls(destination)) {
            return null;
        }
        log.debug("The destination uses HTTPS for target \"{}\".", (Object)destination.getUri());
        SSLContext sslContext = new SSLContextFactory().createSSLContext(destination);
        HostnameVerifier hostnameVerifier = this.getHostnameVerifier(destination);
        return new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
    }

    private boolean supportsTls(@Nullable HttpDestinationProperties destination) {
        if (destination == null) {
            return false;
        }
        String scheme = destination.getUri().getScheme();
        return "https".equalsIgnoreCase(scheme) || StringUtils.isEmpty((CharSequence)scheme);
    }

    private HostnameVerifier getHostnameVerifier(HttpDestinationProperties destination) {
        return destination.isTrustingAllCertificates() ? new NoopHostnameVerifier() : new DefaultHostnameVerifier();
    }

    @Nonnull
    private RequestConfig getRequestConfig() {
        return RequestConfig.custom().setConnectionRequestTimeout(this.timeout).build();
    }

    @Nullable
    private HttpHost getProxy(@Nullable HttpDestinationProperties destination) {
        if (!this.isValidProxyConfigurationUriInDestination(destination)) {
            return null;
        }
        URI proxyUri = ((ProxyConfiguration)Objects.requireNonNull(destination).getProxyConfiguration().get()).getUri();
        HttpHost proxyHost = new HttpHost(proxyUri.getScheme(), proxyUri.getHost(), proxyUri.getPort());
        log.debug("Using the following proxy for destination {} pointing to URL {}: {}.", new Object[]{destination.get(DestinationProperty.NAME).getOrElse((Object)"without name"), destination.getUri(), proxyUri});
        return proxyHost;
    }

    private boolean isValidProxyConfigurationUriInDestination(@Nullable HttpDestinationProperties destination) {
        if (destination == null) {
            log.trace("No destination defined for HTTP client builder.");
            return false;
        }
        Option proxyConfiguration = destination.getProxyConfiguration();
        if (proxyConfiguration.isEmpty()) {
            log.trace("No proxy configuration found for destination {}.", (Object)destination);
            return false;
        }
        URI uri = ((ProxyConfiguration)proxyConfiguration.get()).getUri();
        String undefinedProxyMayBeExpectedMessage = "Failed to load proxy information for destination {}: Undefined {} in URI of proxy configuration. This behavior may be expected in tests and some local runtimes.";
        String host = uri.getHost();
        if (host == null) {
            log.error("Failed to load proxy information for destination {}: Undefined {} in URI of proxy configuration. This behavior may be expected in tests and some local runtimes.", (Object)destination, (Object)"host");
            return false;
        }
        int port = uri.getPort();
        if (port < 0) {
            log.error("Failed to load proxy information for destination {}: Undefined {} in URI of proxy configuration. This behavior may be expected in tests and some local runtimes.", (Object)destination, (Object)"port");
            return false;
        }
        return true;
    }
}

