/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.PlatformSslContextProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.CfPlatformSslContextProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.exception.CloudPlatformException;
import io.vavr.control.Option;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SSLContextFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SSLContextFactory.class);
    private static final KeyStoreMetadata JDK_TRUST_STORE_METADATA;
    private final PlatformSslContextProvider sslContextProvider = new CfPlatformSslContextProvider();
    private final SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();

    SSLContextFactory() {
    }

    @Nonnull
    SSLContext createSSLContext(@Nonnull HttpDestinationProperties destination) throws GeneralSecurityException, IOException {
        switch (destination.getSecurityConfigurationStrategy()) {
            case FROM_PLATFORM: {
                return this.getPlatformSslContext();
            }
        }
        return this.getSSLContextFromDestination(destination);
    }

    private SSLContext getPlatformSslContext() throws CloudPlatformException {
        return (SSLContext)this.sslContextProvider.tryGetContext().getOrElseThrow(e -> new CloudPlatformException("Failed to create default SSL context", e));
    }

    private SSLContext getSSLContextFromDestination(@Nonnull HttpDestinationProperties destination) throws GeneralSecurityException, IOException {
        this.setTlsVersion(destination, this.sslContextBuilder);
        this.configureTrustSettings(destination, this.sslContextBuilder);
        this.configureKeySettings(destination, this.sslContextBuilder);
        return this.sslContextBuilder.build();
    }

    private void setTlsVersion(@Nonnull HttpDestinationProperties destination, SSLContextBuilder sslContextBuilder) {
        destination.getTlsVersion().peek(tlsVersion -> {
            log.debug("Using TLS protocol version \"{}\".", tlsVersion);
            sslContextBuilder.setProtocol(tlsVersion);
        });
    }

    private void configureTrustSettings(@Nonnull HttpDestinationProperties destination, @Nonnull SSLContextBuilder sslContextBuilder) throws GeneralSecurityException, IOException {
        if (destination.isTrustingAllCertificates()) {
            log.debug("Trusting all certificates.");
            sslContextBuilder.loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE);
        } else {
            Option maybeTrustStore = destination.getTrustStore();
            if (maybeTrustStore.isDefined()) {
                log.debug("Using trust store of destination.");
                sslContextBuilder.loadTrustMaterial((KeyStore)maybeTrustStore.get(), null);
            } else {
                log.debug("Using JDK default trust store.");
                KeyStore jdkTrustStore = this.loadTrustStore(JDK_TRUST_STORE_METADATA);
                sslContextBuilder.loadTrustMaterial(jdkTrustStore, null);
            }
        }
    }

    @Nonnull
    private KeyStore loadTrustStore(@Nonnull KeyStoreMetadata keyStoreMetadata) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        File canonicalFile = keyStoreMetadata.getFilePath().getCanonicalFile();
        Option<String> maybePassword = keyStoreMetadata.getPassword();
        char[] keyStorePassword = (char[])maybePassword.map(String::toCharArray).getOrNull();
        try (InputStream is = Files.newInputStream(canonicalFile.toPath(), new OpenOption[0]);){
            keyStore.load(is, keyStorePassword);
        }
        return keyStore;
    }

    private void configureKeySettings(@Nonnull HttpDestinationProperties destination, @Nonnull SSLContextBuilder sslContextBuilder) throws GeneralSecurityException {
        Option maybeKeyStore = destination.getKeyStore();
        if (!maybeKeyStore.isDefined()) {
            return;
        }
        KeyStore keyStore = (KeyStore)maybeKeyStore.get();
        if (log.isDebugEnabled()) {
            log.debug("Using key store of destination with aliases: {}", Collections.list(keyStore.aliases()));
        }
        char[] keyStorePassword = (char[])destination.getKeyStorePassword().map(String::toCharArray).onEmpty(() -> log.debug("Using key store without password.")).getOrElse(() -> new char[0]);
        sslContextBuilder.loadKeyMaterial(keyStore, keyStorePassword);
    }

    static {
        File trustStoreFile = (File)Option.of((Object)System.getProperty("javax.net.ssl.trustStore")).map(File::new).getOrElse(() -> new File(System.getProperty("java.home"), "/lib/security/cacerts"));
        String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        JDK_TRUST_STORE_METADATA = new KeyStoreMetadata(trustStoreFile, trustStorePassword);
    }

    private static final class KeyStoreMetadata {
        private final File filePath;
        @Nullable
        private final String password;

        Option<String> getPassword() {
            return Option.of((Object)this.password);
        }

        @Generated
        public KeyStoreMetadata(File filePath, @Nullable String password) {
            this.filePath = filePath;
            this.password = password;
        }

        @Generated
        public File getFilePath() {
            return this.filePath;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyStoreMetadata)) {
                return false;
            }
            KeyStoreMetadata other = (KeyStoreMetadata)o;
            File this$filePath = this.getFilePath();
            File other$filePath = other.getFilePath();
            if (this$filePath == null ? other$filePath != null : !((Object)this$filePath).equals(other$filePath)) {
                return false;
            }
            Option<String> this$password = this.getPassword();
            Option<String> other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            File $filePath = this.getFilePath();
            result = result * 59 + ($filePath == null ? 43 : ((Object)$filePath).hashCode());
            Option<String> $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "SSLContextFactory.KeyStoreMetadata(filePath=" + this.getFilePath() + ", password=" + this.getPassword() + ")";
        }
    }
}

