/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationPropertyKey;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceV1Response;
import com.sap.cloud.sdk.cloudplatform.connectivity.KeyStoreReader;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DestinationKeyStoreExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DestinationKeyStoreExtractor.class);
    private static final Map<String, BiFunction<String, String, KeyStore>> SUPPORTED_KEY_STORES = ImmutableMap.builder().put((Object)"pfx", (ks, pw) -> DestinationKeyStoreExtractor.retrieveExistingKeyStore(ks, pw, "PKCS12")).put((Object)"p12", (ks, pw) -> DestinationKeyStoreExtractor.retrieveExistingKeyStore(ks, pw, "PKCS12")).put((Object)"jks", (ks, pw) -> DestinationKeyStoreExtractor.retrieveExistingKeyStore(ks, pw, "JKS")).put((Object)"pem", DestinationKeyStoreExtractor::createNewKeyStoreFromPem).build();
    static final Map<String, String> SUPPORTED_KEY_STORE_TYPES_AS_TRUST_STORE = ImmutableMap.of((Object)"jks", (Object)"JKS");
    static final List<String> SUPPORTED_CERT_FILE_EXTENSIONS_AS_TRUST_STORE = ImmutableList.of((Object)"crt", (Object)"cer", (Object)"der");
    @Nonnull
    private final PropertyKeyExtractor destination;

    DestinationKeyStoreExtractor(@Nonnull DestinationProperties destination) {
        this(arg_0 -> ((DestinationProperties)destination).get(arg_0));
    }

    @Nonnull
    Option<KeyStore> getTrustStore() throws DestinationAccessException {
        if (this.destination.get(DestinationProperty.TRUST_STORE_LOCATION).isEmpty()) {
            return Option.none();
        }
        if (log.isDebugEnabled()) {
            log.debug("Properties {} and {} found for destination {}", new Object[]{DestinationProperty.TRUST_STORE_LOCATION.getKeyName(), DestinationProperty.TRUST_STORE_PASSWORD.getKeyName(), this.destination.get(DestinationProperty.NAME).getOrElse((Object)"without name")});
        }
        DestinationServiceV1Response.DestinationCertificate cert = this.getDestinationCertificateFromProperty((DestinationPropertyKey<String>)DestinationProperty.TRUST_STORE_LOCATION);
        String keyStorePassword = (String)this.destination.get(DestinationProperty.TRUST_STORE_PASSWORD).getOrNull();
        String fileExtension = FilenameUtils.getExtension((String)cert.getName().toLowerCase());
        String keyStoreType = SUPPORTED_KEY_STORE_TYPES_AS_TRUST_STORE.get(fileExtension);
        if (keyStoreType != null) {
            log.debug("Creating a key store of type {} with file extension {}.", (Object)keyStoreType, (Object)fileExtension);
            KeyStore keyStore = DestinationKeyStoreExtractor.retrieveExistingKeyStore(cert.getContent(), keyStorePassword, keyStoreType);
            return Option.some((Object)keyStore);
        }
        if (SUPPORTED_CERT_FILE_EXTENSIONS_AS_TRUST_STORE.contains(fileExtension)) {
            KeyStore keyStore = DestinationKeyStoreExtractor.createKeyStoreFromCertificate(cert.getContent(), cert.getName());
            return Option.some((Object)keyStore);
        }
        String extensions = Joiner.on((String)", ").join(SUPPORTED_KEY_STORE_TYPES_AS_TRUST_STORE.keySet(), SUPPORTED_CERT_FILE_EXTENSIONS_AS_TRUST_STORE, new Object[0]);
        String message = "Could not create Trust Store from file \"%s\". Supported file extensions: %s";
        throw new DestinationAccessException(String.format("Could not create Trust Store from file \"%s\". Supported file extensions: %s", cert.getName(), extensions));
    }

    @Nonnull
    Option<KeyStore> getKeyStore() throws DestinationAccessException {
        if (this.destination.get(DestinationProperty.KEY_STORE_LOCATION).isEmpty() || !DestinationKeyStoreExtractor.authTypeRequiresLoadingKeyMaterial(this.destination)) {
            return Option.none();
        }
        if (log.isDebugEnabled()) {
            log.debug("Properties {} and {} found for destination {}", new Object[]{DestinationProperty.KEY_STORE_LOCATION.getKeyName(), DestinationProperty.KEY_STORE_PASSWORD.getKeyName(), this.destination.get(DestinationProperty.NAME).getOrElse((Object)"without name")});
        }
        DestinationServiceV1Response.DestinationCertificate certificate = this.getDestinationCertificateFromProperty((DestinationPropertyKey<String>)DestinationProperty.KEY_STORE_LOCATION);
        BiFunction<String, String, KeyStore> storeTransformer = DestinationKeyStoreExtractor.getKeyStoreTransformerByFileName(certificate.getName());
        String storePassword = (String)this.destination.get(DestinationProperty.KEY_STORE_PASSWORD).getOrNull();
        return Option.some((Object)storeTransformer.apply(certificate.getContent(), storePassword));
    }

    @Nonnull
    private DestinationServiceV1Response.DestinationCertificate getDestinationCertificateFromProperty(@Nonnull DestinationPropertyKey<String> locationKey) {
        String keyStoreLocation = (String)this.destination.get(locationKey).get();
        List certs = (List)this.destination.get(DestinationProperty.CERTIFICATES).getOrElse(Collections::emptyList);
        log.debug("Considering Key Store Location {}. Found {} key store certificates.", (Object)keyStoreLocation, (Object)certs.size());
        Optional<DestinationServiceV1Response.DestinationCertificate> certificate = certs.stream().filter(DestinationServiceV1Response.DestinationCertificate.class::isInstance).map(DestinationServiceV1Response.DestinationCertificate.class::cast).filter(cert -> DestinationKeyStoreExtractor.hasCertificateName(keyStoreLocation, cert.getName())).filter(cert -> DestinationKeyStoreExtractor.hasCertificateContent(cert.getContent())).findFirst();
        if (certificate.isEmpty()) {
            throw new DestinationAccessException(String.format("Failed to resolve key store '%s' in destination '%s' as no matching certificate was found.", keyStoreLocation, this.destination.get(DestinationProperty.NAME).getOrElse((Object)"without name")));
        }
        log.trace("Loaded destination certificate: {}", certificate);
        return certificate.get();
    }

    @Nonnull
    private static BiFunction<String, String, KeyStore> getKeyStoreTransformerByFileName(@Nonnull String name) {
        String fileExtension = FilenameUtils.getExtension((String)name.toLowerCase());
        BiFunction<String, String, KeyStore> typeOfFileExt = SUPPORTED_KEY_STORES.get(fileExtension);
        if (typeOfFileExt == null) {
            String message = "Could not create Key Store with file extension: %s. Supported extensions: " + SUPPORTED_KEY_STORES.keySet();
            throw new DestinationAccessException(String.format(message, fileExtension));
        }
        return typeOfFileExt;
    }

    @Nonnull
    private static KeyStore createKeyStoreFromCertificate(@Nonnull String fileContent, String fileLocation) {
        KeyStore keyStore;
        String keyStoreType = KeyStore.getDefaultType();
        log.debug("Creating a key store of type {}.", (Object)keyStoreType);
        KeyStore ks = (KeyStore)Try.of((CheckedFunction0 & Serializable)() -> KeyStore.getInstance(keyStoreType)).getOrElseThrow(e -> new DestinationAccessException("Failed to load key store.", e));
        byte[] bytes = Base64.getDecoder().decode(fileContent);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(is);
            ks.load(null, null);
            ks.setCertificateEntry(fileLocation, certificate);
            keyStore = ks;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e2) {
                throw new DestinationAccessException("Failed to load key store.", (Throwable)e2);
            }
        }
        is.close();
        return keyStore;
    }

    @Nonnull
    private static KeyStore retrieveExistingKeyStore(@Nonnull String fileContent, @Nullable String keyStorePassword, @Nonnull String keyStoreType) {
        KeyStore keyStore;
        log.debug("Creating a key store of type {}.", (Object)keyStoreType);
        KeyStore ks = (KeyStore)Try.of((CheckedFunction0 & Serializable)() -> KeyStore.getInstance(keyStoreType)).getOrElseThrow(e -> new DestinationAccessException("Failed to load key store.", e));
        byte[] bytes = Base64.getDecoder().decode(fileContent);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            char[] password = keyStorePassword == null ? new char[]{} : keyStorePassword.toCharArray();
            ks.load(is, password);
            keyStore = ks;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e2) {
                throw new DestinationAccessException("Failed to load key store.", (Throwable)e2);
            }
        }
        is.close();
        return keyStore;
    }

    @Nonnull
    static KeyStore createNewKeyStoreFromPem(@Nonnull String data, @Nullable String password) {
        try {
            String decoded = new String(Base64.getDecoder().decode(data), StandardCharsets.UTF_8).trim();
            Pattern pattern = Pattern.compile("-+BEGIN CERTIFICATE-+.*-+END CERTIFICATE-+", 32);
            Matcher match = pattern.matcher(decoded);
            if (!match.find()) {
                throw new IllegalArgumentException("PEM format cannot be parsed: No certificate entry found.");
            }
            String key = (decoded.substring(0, match.start()) + decoded.substring(match.end())).trim();
            if (key.isEmpty()) {
                throw new IllegalArgumentException("PEM format cannot be parsed: No private key entry found.");
            }
            String alias = "1";
            char[] pw = Strings.isNullOrEmpty((String)password) ? new char[]{} : password.toCharArray();
            return KeyStoreReader.createKeyStore((String)"1", (char[])pw, (Reader)new StringReader(match.group()), (Reader)new StringReader(key));
        }
        catch (Exception e) {
            throw new DestinationAccessException("Failed to instantiate new KeyStore.", (Throwable)e);
        }
    }

    private static boolean hasCertificateName(String keyStoreLocation, @Nullable String name) {
        return name != null && name.equals(keyStoreLocation);
    }

    private static boolean hasCertificateContent(@Nullable String content) {
        return content != null;
    }

    private static boolean authTypeRequiresLoadingKeyMaterial(@Nonnull PropertyKeyExtractor destination) {
        AuthenticationType authenticationType = (AuthenticationType)destination.get(DestinationProperty.AUTH_TYPE).getOrElse((Object)AuthenticationType.NO_AUTHENTICATION);
        return switch (authenticationType) {
            case AuthenticationType.OAUTH2_SAML_BEARER_ASSERTION, AuthenticationType.SAML_ASSERTION -> false;
            default -> true;
        };
    }

    @Generated
    public DestinationKeyStoreExtractor(@Nonnull PropertyKeyExtractor destination) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.destination = destination;
    }

    static interface PropertyKeyExtractor {
        @Nonnull
        public <T> Option<T> get(@Nonnull DestinationPropertyKey<T> var1);
    }
}

