/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationRetrieval;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationRetrievalStrategy;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceOptionsAugmenter;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceRetrievalStrategy;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceTokenExchangeStrategy;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceV1Response;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationUtility;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DestinationRetrievalStrategyResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DestinationRetrievalStrategyResolver.class);
    private final Supplier<String> providerTenantIdSupplier;
    private final Function<DestinationRetrievalStrategy, DestinationServiceV1Response> destinationRetriever;
    private final Function<OnBehalfOf, List<DestinationProperties>> allDestinationRetriever;
    static final String JWT_ATTR_EXT = "ext_attr";
    static final String JWT_ATTR_ENHANCER = "enhancer";
    static final String JWT_ATTR_XSUAA = "XSUAA";

    static DestinationRetrievalStrategyResolver forSingleDestination(Supplier<String> providerTenantIdSupplier, Function<DestinationRetrievalStrategy, DestinationServiceV1Response> destinationRetriever) {
        return new DestinationRetrievalStrategyResolver(providerTenantIdSupplier, destinationRetriever, any -> Collections.emptyList());
    }

    static DestinationRetrievalStrategyResolver forAllDestinations(Supplier<String> providerTenantIdSupplier, Function<OnBehalfOf, List<DestinationProperties>> allDestinationRetriever) {
        return new DestinationRetrievalStrategyResolver(providerTenantIdSupplier, any -> null, allDestinationRetriever);
    }

    DestinationRetrievalStrategy resolveSingleRequestStrategy(@Nonnull DestinationServiceRetrievalStrategy retrievalStrategy, @Nonnull DestinationServiceTokenExchangeStrategy tokenExchangeStrategy, @Nullable String refreshToken) {
        OnBehalfOf behalfTechnicalUser;
        switch (retrievalStrategy) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ALWAYS_PROVIDER: {
                OnBehalfOf onBehalfOf = OnBehalfOf.TECHNICAL_USER_PROVIDER;
                break;
            }
            case CURRENT_TENANT: 
            case ONLY_SUBSCRIBER: {
                OnBehalfOf onBehalfOf = behalfTechnicalUser = OnBehalfOf.TECHNICAL_USER_CURRENT_TENANT;
            }
        }
        if (refreshToken != null) {
            return DestinationRetrievalStrategy.withRefreshToken(behalfTechnicalUser, refreshToken);
        }
        Try maybeToken = AuthTokenAccessor.tryGetCurrentToken().map(AuthToken::getJwt).map(DecodedJWT::getToken);
        return switch (tokenExchangeStrategy) {
            default -> throw new IncompatibleClassChangeError();
            case DestinationServiceTokenExchangeStrategy.FORWARD_USER_TOKEN -> {
                if (maybeToken.isEmpty()) {
                    yield DestinationRetrievalStrategy.withoutToken(behalfTechnicalUser);
                }
                yield DestinationRetrievalStrategy.withUserToken(behalfTechnicalUser, (String)maybeToken.get());
            }
            case DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY -> DestinationRetrievalStrategy.withoutToken(behalfTechnicalUser);
            case DestinationServiceTokenExchangeStrategy.EXCHANGE_ONLY -> DestinationRetrievalStrategy.withoutToken(OnBehalfOf.NAMED_USER_CURRENT_TENANT);
            case DestinationServiceTokenExchangeStrategy.LOOKUP_THEN_EXCHANGE -> throw new IllegalStateException("Unexpected token exchange strategy " + tokenExchangeStrategy + " when building a request towards the destination service.");
        };
    }

    DestinationRetrieval prepareSupplier(@Nonnull DestinationOptions options) {
        DestinationServiceRetrievalStrategy retrievalStrategy = (DestinationServiceRetrievalStrategy)((Object)DestinationServiceOptionsAugmenter.getRetrievalStrategy(options).getOrElse((Object)DestinationServiceRetrievalStrategy.CURRENT_TENANT));
        DestinationServiceTokenExchangeStrategy tokenExchangeStrategy = (DestinationServiceTokenExchangeStrategy)((Object)DestinationServiceOptionsAugmenter.getTokenExchangeStrategy(options).getOrElse(this::getDefaultTokenExchangeStrategy));
        String refreshToken = (String)DestinationServiceOptionsAugmenter.getRefreshToken(options).peek(any -> log.debug("Refresh token given, applying refresh token flow.")).getOrNull();
        String fragmentName = (String)DestinationServiceOptionsAugmenter.getFragmentName(options).peek(it -> log.debug("Found fragment name '{}'.", it)).getOrNull();
        log.debug("Loading destination from reuse-destination-service with retrieval strategy {} and token exchange strategy {}.", (Object)retrievalStrategy, (Object)tokenExchangeStrategy);
        return this.prepareSupplier(retrievalStrategy, tokenExchangeStrategy, refreshToken, fragmentName);
    }

    @Nonnull
    private DestinationServiceTokenExchangeStrategy getDefaultTokenExchangeStrategy() {
        Map attributes = (Map)AuthTokenAccessor.tryGetCurrentToken().map(t -> t.getJwt().getClaim(JWT_ATTR_EXT).asMap()).getOrNull();
        if (attributes == null || !JWT_ATTR_XSUAA.equalsIgnoreCase("" + attributes.get(JWT_ATTR_ENHANCER))) {
            log.debug("Falling back to {}. Current user token may not originate from XSUAA.", (Object)DestinationServiceTokenExchangeStrategy.LOOKUP_THEN_EXCHANGE);
            return DestinationServiceTokenExchangeStrategy.LOOKUP_THEN_EXCHANGE;
        }
        return DestinationServiceTokenExchangeStrategy.FORWARD_USER_TOKEN;
    }

    DestinationRetrieval prepareSupplier(@Nonnull DestinationServiceRetrievalStrategy retrievalStrategy, @Nonnull DestinationServiceTokenExchangeStrategy tokenExchangeStrategy, @Nullable String refreshToken, @Nullable String fragmentName) throws DestinationAccessException {
        log.debug("Preparing request(s) towards the destination service based on the strategies {} and {}", (Object)retrievalStrategy, (Object)tokenExchangeStrategy);
        this.warnOrThrowOnUnsupportedCombinations(retrievalStrategy, tokenExchangeStrategy);
        if (tokenExchangeStrategy == DestinationServiceTokenExchangeStrategy.LOOKUP_THEN_EXCHANGE) {
            DestinationRetrievalStrategy strategy = this.resolveSingleRequestStrategy(retrievalStrategy, DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY, refreshToken);
            if (fragmentName != null) {
                strategy.withFragmentName(fragmentName);
            }
            return new DestinationRetrieval(() -> {
                DestinationServiceV1Response result = this.destinationRetriever.apply(strategy);
                if (!this.doesDestinationConfigurationRequireUserTokenExchange(result)) {
                    return result;
                }
                if (retrievalStrategy == DestinationServiceRetrievalStrategy.ALWAYS_PROVIDER && !this.currentTenantIsProvider()) {
                    throw new DestinationAccessException("Can't perform token exchange, the current token is not issued for the provider tenant.");
                }
                return this.destinationRetriever.apply(DestinationRetrievalStrategy.withoutToken(OnBehalfOf.NAMED_USER_CURRENT_TENANT));
            }, strategy.behalf());
        }
        DestinationRetrievalStrategy strategy = this.resolveSingleRequestStrategy(retrievalStrategy, tokenExchangeStrategy, refreshToken);
        if (fragmentName != null) {
            strategy.withFragmentName(fragmentName);
        }
        return new DestinationRetrieval(() -> this.destinationRetriever.apply(strategy), strategy.behalf());
    }

    private void warnOrThrowOnUnsupportedCombinations(@Nonnull DestinationServiceRetrievalStrategy retrievalStrategy, @Nullable DestinationServiceTokenExchangeStrategy tokenExchangeStrategy) {
        if (retrievalStrategy == DestinationServiceRetrievalStrategy.ONLY_SUBSCRIBER && this.currentTenantIsProvider()) {
            throw new DestinationAccessException("The current tenant is the provider tenant, which should not be the case with the option " + DestinationServiceRetrievalStrategy.ONLY_SUBSCRIBER + ". Cannot retrieve destination.");
        }
        if (retrievalStrategy == DestinationServiceRetrievalStrategy.ALWAYS_PROVIDER && !this.currentTenantIsProvider()) {
            if (tokenExchangeStrategy == DestinationServiceTokenExchangeStrategy.EXCHANGE_ONLY) {
                throw new DestinationAccessException("The current tenant is not the provider tenant, which should not be the case with the options " + DestinationServiceRetrievalStrategy.ALWAYS_PROVIDER + " and " + DestinationServiceTokenExchangeStrategy.EXCHANGE_ONLY + ". Cannot retrieve destination.");
            }
            if (tokenExchangeStrategy != DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY) {
                log.warn("The current tenant is not the provider tenant. Only destinations which don't require a user token will be supported. Use retrieval strategy {} to avoid this warning.", (Object)DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY);
            }
        }
    }

    Supplier<List<DestinationProperties>> prepareSupplierAllDestinations(@Nonnull DestinationOptions options) {
        DestinationServiceTokenExchangeStrategy tokenExchangeStrategy = (DestinationServiceTokenExchangeStrategy)((Object)DestinationServiceOptionsAugmenter.getTokenExchangeStrategy(options).getOrElse((Object)DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY));
        if (tokenExchangeStrategy != DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY) {
            log.warn("The provided token exchange strategy {} is not applicable while retrieving all destinations, hence switching to {} ", (Object)tokenExchangeStrategy, (Object)DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY);
        }
        DestinationServiceRetrievalStrategy retrievalStrategy = (DestinationServiceRetrievalStrategy)((Object)DestinationServiceOptionsAugmenter.getRetrievalStrategy(options).getOrElse((Object)DestinationServiceRetrievalStrategy.CURRENT_TENANT));
        return this.prepareSupplierAllDestinations(retrievalStrategy);
    }

    Supplier<List<DestinationProperties>> prepareSupplierAllDestinations(@Nonnull DestinationServiceRetrievalStrategy strategy) throws IllegalArgumentException {
        this.warnOrThrowOnUnsupportedCombinations(strategy, null);
        switch (strategy) {
            case ALWAYS_PROVIDER: {
                return () -> this.allDestinationRetriever.apply(OnBehalfOf.TECHNICAL_USER_PROVIDER);
            }
            case CURRENT_TENANT: 
            case ONLY_SUBSCRIBER: {
                return () -> this.allDestinationRetriever.apply(OnBehalfOf.TECHNICAL_USER_CURRENT_TENANT);
            }
        }
        throw new IllegalArgumentException("The provided destination retrieval strategy " + strategy + " is not valid.");
    }

    boolean doesDestinationConfigurationRequireUserTokenExchange(@Nonnull DestinationServiceV1Response response) {
        Map<String, String> destinationConfiguration = response.getDestinationConfiguration();
        Try<AuthenticationType> authenticationType = this.determineAuthenticationType(destinationConfiguration);
        if (authenticationType.isSuccess()) {
            AuthenticationType authType = (AuthenticationType)authenticationType.get();
            String systemUser = destinationConfiguration.get(DestinationProperty.SYSTEM_USER.getKeyName());
            return DestinationUtility.requiresUserTokenExchange((AuthenticationType)authType, (String)systemUser);
        }
        log.warn("No configuration value set for 'Authentication' in destination {}.", (Object)destinationConfiguration.get(DestinationProperty.NAME.getKeyName()));
        return false;
    }

    private boolean currentTenantIsProvider() {
        String currentTenantId = (String)TenantAccessor.tryGetCurrentTenant().map(Tenant::getTenantId).getOrNull();
        String providerTenantId = this.providerTenantIdSupplier.get();
        return Objects.equals(currentTenantId, providerTenantId);
    }

    private Try<AuthenticationType> determineAuthenticationType(Map<String, String> destinationConfiguration) {
        TreeMap<String, String> destinationData = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        destinationData.putAll(destinationConfiguration);
        String authenticationValue = (String)destinationData.get(DestinationProperty.AUTH_TYPE.getKeyName());
        return Try.of((CheckedFunction0 & Serializable)() -> AuthenticationType.ofIdentifier((String)authenticationValue));
    }

    @Generated
    public DestinationRetrievalStrategyResolver(Supplier<String> providerTenantIdSupplier, Function<DestinationRetrievalStrategy, DestinationServiceV1Response> destinationRetriever, Function<OnBehalfOf, List<DestinationProperties>> allDestinationRetriever) {
        this.providerTenantIdSupplier = providerTenantIdSupplier;
        this.destinationRetriever = destinationRetriever;
        this.allDestinationRetriever = allDestinationRetriever;
    }
}

