/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.github.benmanes.caffeine.cache.Cache;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperties;
import io.vavr.control.Try;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetOrComputeAllDestinationsCommand {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetOrComputeAllDestinationsCommand.class);
    @Nonnull
    private final CacheKey cacheKey;
    @Nonnull
    private final ReentrantLock isolationLock;
    @Nonnull
    private final Cache<CacheKey, List<DestinationProperties>> cache;
    @Nonnull
    private final Supplier<Try<List<DestinationProperties>>> destinationSupplier;

    static GetOrComputeAllDestinationsCommand prepareCommand(@Nonnull DestinationOptions destinationOptions, @Nonnull Cache<CacheKey, List<DestinationProperties>> destinationCache, @Nonnull Cache<CacheKey, ReentrantLock> isolationLocks, @Nonnull Function<DestinationOptions, Try<List<DestinationProperties>>> destinationRetriever) {
        Supplier<Try<List<DestinationProperties>>> destinationSupplier = () -> (Try)destinationRetriever.apply(destinationOptions);
        CacheKey cacheKey = CacheKey.ofTenantOptionalIsolation();
        cacheKey.append(new Object[]{destinationOptions});
        ReentrantLock isolationLock = Objects.requireNonNull((ReentrantLock)isolationLocks.get((Object)cacheKey, any -> new ReentrantLock()));
        return new GetOrComputeAllDestinationsCommand(cacheKey, isolationLock, destinationCache, destinationSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Try<List<DestinationProperties>> execute() {
        List destinations = (List)this.cache.getIfPresent((Object)this.cacheKey);
        if (destinations != null) {
            return Try.success((Object)destinations);
        }
        try {
            this.isolationLock.lock();
            destinations = (List)this.cache.getIfPresent((Object)this.cacheKey);
            if (destinations != null) {
                Try try_ = Try.success((Object)destinations);
                return try_;
            }
            Try<List<DestinationProperties>> result = this.destinationSupplier.get();
            if (result.isFailure()) {
                Try<List<DestinationProperties>> try_ = result;
                return try_;
            }
            this.cache.put((Object)this.cacheKey, (Object)((List)result.get()));
            Try<List<DestinationProperties>> try_ = result;
            return try_;
        }
        finally {
            this.isolationLock.unlock();
        }
    }

    @Generated
    private GetOrComputeAllDestinationsCommand(@Nonnull CacheKey cacheKey, @Nonnull ReentrantLock isolationLock, @Nonnull Cache<CacheKey, List<DestinationProperties>> cache, @Nonnull Supplier<Try<List<DestinationProperties>>> destinationSupplier) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        if (isolationLock == null) {
            throw new NullPointerException("isolationLock is marked non-null but is null");
        }
        if (cache == null) {
            throw new NullPointerException("cache is marked non-null but is null");
        }
        if (destinationSupplier == null) {
            throw new NullPointerException("destinationSupplier is marked non-null but is null");
        }
        this.cacheKey = cacheKey;
        this.isolationLock = isolationLock;
        this.cache = cache;
        this.destinationSupplier = destinationSupplier;
    }
}

