/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

final class DestinationRetrievalStrategy {
    @Nonnull
    private final OnBehalfOf behalf;
    @Nonnull
    private final TokenForwarding tokenForwarding;
    @Nullable
    private final String token;
    @Nullable
    private String fragment;

    static DestinationRetrievalStrategy withoutToken(@Nonnull OnBehalfOf behalf) {
        return new DestinationRetrievalStrategy(behalf, TokenForwarding.NONE, null);
    }

    static DestinationRetrievalStrategy withUserToken(@Nonnull OnBehalfOf behalf, @Nonnull String token) {
        if (token.isBlank()) {
            throw new IllegalArgumentException("User token must not be empty.");
        }
        return new DestinationRetrievalStrategy(behalf, TokenForwarding.USER_TOKEN, token);
    }

    static DestinationRetrievalStrategy withRefreshToken(@Nonnull OnBehalfOf behalf, @Nonnull String token) {
        if (token.isBlank()) {
            throw new IllegalArgumentException("Refresh token must not be empty.");
        }
        return new DestinationRetrievalStrategy(behalf, TokenForwarding.REFRESH_TOKEN, token);
    }

    DestinationRetrievalStrategy withFragmentName(@Nonnull String fragmentName) {
        if (fragmentName.isBlank()) {
            throw new IllegalArgumentException("Fragment name must not be empty");
        }
        if (this.fragment != null) {
            throw new IllegalStateException("Attempted to change an already set fragment name");
        }
        this.fragment = fragmentName;
        return this;
    }

    @Nonnull
    @Generated
    public OnBehalfOf behalf() {
        return this.behalf;
    }

    @Nonnull
    @Generated
    public TokenForwarding tokenForwarding() {
        return this.tokenForwarding;
    }

    @Nullable
    @Generated
    public String token() {
        return this.token;
    }

    @Nullable
    @Generated
    public String fragment() {
        return this.fragment;
    }

    @Generated
    private DestinationRetrievalStrategy(@Nonnull OnBehalfOf behalf, @Nonnull TokenForwarding tokenForwarding, @Nullable String token) {
        if (behalf == null) {
            throw new NullPointerException("behalf is marked non-null but is null");
        }
        if (tokenForwarding == null) {
            throw new NullPointerException("tokenForwarding is marked non-null but is null");
        }
        this.behalf = behalf;
        this.tokenForwarding = tokenForwarding;
        this.token = token;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DestinationRetrievalStrategy)) {
            return false;
        }
        DestinationRetrievalStrategy other = (DestinationRetrievalStrategy)o;
        OnBehalfOf this$behalf = this.behalf();
        OnBehalfOf other$behalf = other.behalf();
        if (this$behalf == null ? other$behalf != null : !this$behalf.equals(other$behalf)) {
            return false;
        }
        TokenForwarding this$tokenForwarding = this.tokenForwarding();
        TokenForwarding other$tokenForwarding = other.tokenForwarding();
        if (this$tokenForwarding == null ? other$tokenForwarding != null : !((Object)((Object)this$tokenForwarding)).equals((Object)other$tokenForwarding)) {
            return false;
        }
        String this$token = this.token();
        String other$token = other.token();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$fragment = this.fragment();
        String other$fragment = other.fragment();
        return !(this$fragment == null ? other$fragment != null : !this$fragment.equals(other$fragment));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OnBehalfOf $behalf = this.behalf();
        result = result * 59 + ($behalf == null ? 43 : $behalf.hashCode());
        TokenForwarding $tokenForwarding = this.tokenForwarding();
        result = result * 59 + ($tokenForwarding == null ? 43 : ((Object)((Object)$tokenForwarding)).hashCode());
        String $token = this.token();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $fragment = this.fragment();
        result = result * 59 + ($fragment == null ? 43 : $fragment.hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "DestinationRetrievalStrategy(behalf=" + String.valueOf(this.behalf()) + ", tokenForwarding=" + String.valueOf((Object)this.tokenForwarding()) + ", fragment=" + this.fragment() + ")";
    }

    static enum TokenForwarding {
        USER_TOKEN,
        REFRESH_TOKEN,
        NONE;

    }
}

