/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.base.Strings;
import com.sap.cloud.environment.servicebinding.api.DefaultServiceBindingAccessor;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceIdentifier;
import com.sap.cloud.environment.servicebinding.api.TypedMapView;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationRetrievalStrategy;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpEntityUtil;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.exception.MultipleServiceBindingsException;
import com.sap.cloud.sdk.cloudplatform.exception.NoServiceBindingException;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DestinationServiceAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DestinationServiceAdapter.class);
    private static final String SERVICE_PATH = "destination-configuration/v1";
    @Nonnull
    final Function<OnBehalfOf, HttpDestination> serviceDestinationLoader;
    @Nonnull
    private final Supplier<ServiceBinding> serviceBindingSupplier;
    @Nullable
    private final String providerTenantId;

    DestinationServiceAdapter() {
        this(null, null, null);
    }

    DestinationServiceAdapter(@Nullable Function<OnBehalfOf, HttpDestination> serviceDestinationLoader, @Nullable Supplier<ServiceBinding> serviceBindingSupplier, @Nullable String providerTenantId) {
        this.serviceDestinationLoader = serviceDestinationLoader != null ? serviceDestinationLoader : this.prepareServiceDestinationComputation();
        this.serviceBindingSupplier = serviceBindingSupplier != null ? serviceBindingSupplier : DestinationServiceAdapter::getDestinationServiceBinding;
        this.providerTenantId = providerTenantId;
    }

    @Nonnull
    String getProviderTenantId() throws DestinationAccessException {
        if (this.providerTenantId != null) {
            return this.providerTenantId;
        }
        TypedMapView credentials = (TypedMapView)Try.of((CheckedFunction0 & Serializable)() -> {
            ServiceBinding binding = this.serviceBindingSupplier.get();
            return TypedMapView.ofCredentials((ServiceBinding)binding);
        }).getOrElseThrow(e -> new DestinationAccessException("Could not resolve destination to Destination Service on behalf of provider.", e));
        if (credentials.containsKey("tenantid")) {
            return credentials.getString("tenantid");
        }
        throw new DestinationAccessException("The provider tenant id is not defined in the service binding. Please verify that the service binding contains the field 'tenantid' in the credentials list.");
    }

    private Function<OnBehalfOf, HttpDestination> prepareServiceDestinationComputation() {
        ConcurrentHashMap result = new ConcurrentHashMap();
        return behalf -> result.computeIfAbsent(behalf, b -> {
            try {
                ServiceBinding binding = this.serviceBindingSupplier.get();
                ServiceBindingDestinationOptions options = ServiceBindingDestinationOptions.forService((ServiceBinding)binding).onBehalfOf(b).build();
                return ServiceBindingDestinationLoader.defaultLoaderChain().getDestination(options);
            }
            catch (Exception e) {
                throw new DestinationAccessException("Could not resolve destination to Destination Service on behalf of " + String.valueOf(b) + ".", (Throwable)e);
            }
        });
    }

    @Nonnull
    String getConfigurationAsJson(@Nonnull String servicePath, @Nonnull DestinationRetrievalStrategy strategy) throws DestinationAccessException, DestinationNotFoundException {
        HttpResponse response;
        HttpDestination serviceDestination = Objects.requireNonNull(this.serviceDestinationLoader.apply(strategy.behalf()), () -> "Destination for Destination Service on behalf of " + String.valueOf(strategy.behalf()) + " not found.");
        HttpUriRequest request = this.prepareRequest(servicePath, strategy);
        try {
            response = HttpClientAccessor.getHttpClient((HttpDestinationProperties)serviceDestination).execute(request);
        }
        catch (IOException e) {
            throw new DestinationAccessException((Throwable)e);
        }
        return DestinationServiceAdapter.handleResponse(request, response);
    }

    @Nonnull
    private static String handleResponse(HttpUriRequest request, HttpResponse response) {
        DestinationAccessException ex;
        StatusLine status = response.getStatusLine();
        int statusCode = status.getStatusCode();
        String reasonPhrase = status.getReasonPhrase();
        log.debug("Destination service returned HTTP status {} ({})", (Object)statusCode, (Object)reasonPhrase);
        Try maybeBody = Try.of((CheckedFunction0 & Serializable)() -> HttpEntityUtil.getResponseBody((HttpResponse)response));
        if (maybeBody.isFailure()) {
            ex = new DestinationAccessException("Failed to read body from HTTP response", maybeBody.getCause());
            maybeBody = Try.failure((Throwable)ex);
        }
        if (statusCode == 200) {
            ex = new DestinationAccessException("Failed to get destinations: no body returned in response.");
            maybeBody = maybeBody.filter(it -> !Strings.isNullOrEmpty((String)it), () -> ex);
            return (String)maybeBody.get();
        }
        String requestUri = request.getURI().getPath();
        if (statusCode == 404) {
            throw new DestinationNotFoundException(null, "Destination could not be found for path " + requestUri + ".");
        }
        String message = "Failed to get destinations: destination service responded with HTTP status %s (%S) at '%s'.".formatted(statusCode, reasonPhrase, requestUri);
        String messageWithBody = message + " Body: %s".formatted(maybeBody.getOrElseGet(Throwable::getMessage));
        log.error(messageWithBody);
        throw new DestinationAccessException(message);
    }

    private HttpUriRequest prepareRequest(String servicePath, DestinationRetrievalStrategy strategy) {
        String headerName;
        URI requestUri;
        try {
            requestUri = new URI(SERVICE_PATH + servicePath);
        }
        catch (URISyntaxException e) {
            throw new DestinationAccessException((Throwable)e);
        }
        log.debug("Querying Destination Service via URI {}.", (Object)requestUri);
        HttpGet request = new HttpGet(requestUri);
        switch (strategy.tokenForwarding()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case USER_TOKEN: {
                String string = "x-user-token";
                break;
            }
            case REFRESH_TOKEN: {
                String string = "x-refresh-token";
                break;
            }
            case NONE: {
                String string = headerName = null;
            }
        }
        if (headerName != null) {
            request.addHeader(headerName, strategy.token());
        }
        if (strategy.fragment() != null) {
            request.addHeader("x-fragment-name", strategy.fragment());
        }
        return request;
    }

    @Nonnull
    static ServiceBinding getDestinationServiceBinding() {
        List<ServiceBinding> matchingBindings = DefaultServiceBindingAccessor.getInstance().getServiceBindings().stream().filter(binding -> ServiceIdentifier.DESTINATION.equals(binding.getServiceIdentifier().orElse(null))).toList();
        if (matchingBindings.isEmpty()) {
            throw new NoServiceBindingException("Please make sure you have the Destination Service bound to your application.");
        }
        if (matchingBindings.size() > 1) {
            throw new MultipleServiceBindingsException("Having multiple Destination Service bindings is not supported.");
        }
        return matchingBindings.get(0);
    }

    @Nonnull
    @Generated
    Function<OnBehalfOf, HttpDestination> getServiceDestinationLoader() {
        return this.serviceDestinationLoader;
    }
}

