/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.base.Strings;
import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationHeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationRequestContext;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceV1Response;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthTokenHeaderProvider
implements DestinationHeaderProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthTokenHeaderProvider.class);
    private static final String SECURITY_SESSION_HEADER = "x-sap-security-session";
    private static final String CREATE_SESSION_VALUE = "create";

    AuthTokenHeaderProvider() {
    }

    @Nonnull
    public List<Header> getHeaders(@Nonnull DestinationRequestContext requestContext) {
        HttpDestination destination = requestContext.getDestination();
        AuthenticationType authenticationType = destination.getAuthenticationType();
        ArrayList<Header> result = new ArrayList<Header>();
        if (authenticationType == AuthenticationType.SAML_ASSERTION) {
            result.add(new Header(SECURITY_SESSION_HEADER, CREATE_SESSION_VALUE));
        }
        List<DestinationServiceV1Response.DestinationAuthToken> tokens = ((List)destination.get(DestinationProperty.AUTH_TOKENS).getOrElse(Collections::emptyList)).stream().filter(DestinationServiceV1Response.DestinationAuthToken.class::isInstance).map(DestinationServiceV1Response.DestinationAuthToken.class::cast).collect(Collectors.toList());
        if (!tokens.isEmpty()) {
            result.addAll(AuthTokenHeaderProvider.getDestinationHeaders(tokens));
        } else if (AuthTokenHeaderProvider.isAuthTokenExpected(authenticationType)) {
            log.warn("The destination service did not include an auth token in the response.");
        }
        tokens.stream().map(DestinationServiceV1Response.DestinationAuthToken::getExpiryTimestamp).filter(Objects::nonNull).filter(expiry -> expiry.isBefore(LocalDateTime.now())).forEach(expiry -> log.warn("An authorization token of destination {} has expired. Please ensure that you don't reuse destination objects in your code for longer periods of time.", destination.get(DestinationProperty.NAME).getOrElse(destination::toString)));
        return result;
    }

    @Nonnull
    private static List<Header> getDestinationHeaders(@Nonnull List<DestinationServiceV1Response.DestinationAuthToken> authTokens) throws DestinationAccessException {
        ArrayList<Header> result = new ArrayList<Header>();
        for (DestinationServiceV1Response.DestinationAuthToken authToken : authTokens) {
            Header header = authToken.getHttpHeaderSuggestion();
            if (header != null) {
                result.add(header);
                continue;
            }
            if (!Strings.isNullOrEmpty((String)authToken.getType()) && !Strings.isNullOrEmpty((String)authToken.getValue())) {
                log.warn("Header suggestion is missing from destination service response. Falling back to constructing an authorization header from type and value. This is unexpected, please report this at https://github.com/SAP/cloud-sdk-java/issues.");
                result.add(new Header("Authorization", authToken.getType() + " " + authToken.getValue()));
                continue;
            }
            throw new DestinationAccessException("Failed to read authentication token. The destination service responded with an auth token that could not be interpreted.");
        }
        return result;
    }

    private static boolean isAuthTokenExpected(@Nonnull AuthenticationType authType) {
        switch (authType) {
            case NO_AUTHENTICATION: 
            case PRINCIPAL_PROPAGATION: 
            case CLIENT_CERTIFICATE_AUTHENTICATION: {
                return false;
            }
        }
        return true;
    }
}

