/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationOptionsAugmenter;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationService;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceRetrievalStrategy;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceTokenExchangeStrategy;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import io.vavr.control.Option;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationServiceOptionsAugmenter
implements DestinationOptionsAugmenter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DestinationServiceOptionsAugmenter.class);
    static final String DESTINATION_RETRIEVAL_STRATEGY_KEY = "scp.cf.destinationRetrievalStrategy";
    static final String DESTINATION_TOKEN_EXCHANGE_STRATEGY_KEY = "scp.cf.destinationTokenExchangeStrategy";
    static final String X_REFRESH_TOKEN_KEY = "x-refresh-token";
    static final String X_FRAGMENT_KEY = "X-fragment-name";
    static final String CROSS_LEVEL_SETTING_KEY = "crossLevelSetting";
    static final String CUSTOM_HEADER_KEY = "customHeader.";
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    @Nonnull
    public static DestinationServiceOptionsAugmenter augmenter() {
        return new DestinationServiceOptionsAugmenter();
    }

    @Nonnull
    public DestinationServiceOptionsAugmenter retrievalStrategy(@Nonnull DestinationServiceRetrievalStrategy strategy) {
        this.parameters.put(DESTINATION_RETRIEVAL_STRATEGY_KEY, (Object)strategy);
        return this;
    }

    @Nonnull
    public DestinationServiceOptionsAugmenter tokenExchangeStrategy(@Nonnull DestinationServiceTokenExchangeStrategy strategy) {
        this.parameters.put(DESTINATION_TOKEN_EXCHANGE_STRATEGY_KEY, (Object)strategy);
        return this;
    }

    @Nonnull
    public DestinationServiceOptionsAugmenter refreshToken(@Nonnull String refreshToken) {
        this.parameters.put(X_REFRESH_TOKEN_KEY, refreshToken);
        return this;
    }

    @Nonnull
    public DestinationServiceOptionsAugmenter fragmentName(@Nonnull String fragmentName) {
        this.parameters.put(X_FRAGMENT_KEY, fragmentName);
        if (DestinationService.Cache.isEnabled() && DestinationService.Cache.isChangeDetectionEnabled()) {
            log.warn("A fragment was requested while change detection caching is enabled.This is not recommended, as fragment-based destinations will effectively not be cached with this strategy.Consider disabling change detection, if you frequently use destination fragments.\n");
        }
        return this;
    }

    @Nonnull
    @Beta
    public DestinationServiceOptionsAugmenter crossLevelConsumption(@Nonnull CrossLevelScope scope) {
        this.parameters.put(CROSS_LEVEL_SETTING_KEY, (Object)scope);
        return this;
    }

    @Nonnull
    @Beta
    public DestinationServiceOptionsAugmenter customHeaders(Header ... headers) {
        for (Header header : headers) {
            this.parameters.put(CUSTOM_HEADER_KEY + header.getName(), header.getValue());
        }
        return this;
    }

    public void augmentBuilder(@Nonnull DestinationOptions.Builder builder) {
        for (Map.Entry<String, Object> param : this.parameters.entrySet()) {
            builder.parameter(param.getKey(), param.getValue());
        }
    }

    @Nonnull
    public static Option<DestinationServiceRetrievalStrategy> getRetrievalStrategy(@Nonnull DestinationOptions options) {
        Object object;
        Option strategy = options.get(DESTINATION_RETRIEVAL_STRATEGY_KEY);
        if (strategy.isDefined() && (object = strategy.get()) instanceof String) {
            String str = (String)object;
            return Option.of((Object)((Object)DestinationServiceRetrievalStrategy.ofIdentifier(str))).onEmpty(() -> log.warn("Unsupported destination retrieval strategy: {}", strategy.get()));
        }
        return strategy.map(DestinationServiceRetrievalStrategy.class::cast);
    }

    @Nonnull
    public static Option<DestinationServiceTokenExchangeStrategy> getTokenExchangeStrategy(@Nonnull DestinationOptions options) {
        Object object;
        Option strategy = options.get(DESTINATION_TOKEN_EXCHANGE_STRATEGY_KEY);
        if (strategy.isDefined() && (object = strategy.get()) instanceof String) {
            String str = (String)object;
            return Option.of((Object)((Object)DestinationServiceTokenExchangeStrategy.ofIdentifier(str))).onEmpty(() -> log.warn("Unsupported token exchange strategy: {}", strategy.get()));
        }
        return strategy.map(DestinationServiceTokenExchangeStrategy.class::cast);
    }

    @Nonnull
    static Option<String> getRefreshToken(@Nonnull DestinationOptions options) {
        return options.get(X_REFRESH_TOKEN_KEY).filter(String.class::isInstance).map(String.class::cast);
    }

    @Nonnull
    static Option<String> getFragmentName(@Nonnull DestinationOptions options) {
        return options.get(X_FRAGMENT_KEY).filter(String.class::isInstance).map(String.class::cast);
    }

    @Nonnull
    static Option<CrossLevelScope> getCrossLevelScope(@Nonnull DestinationOptions options) {
        return options.get(CROSS_LEVEL_SETTING_KEY).filter(CrossLevelScope.class::isInstance).map(CrossLevelScope.class::cast);
    }

    @Nonnull
    static List<Header> getAdditionalHeaders(@Nonnull DestinationOptions options) {
        return options.getOptionKeys().stream().filter(it -> it.startsWith(CUSTOM_HEADER_KEY)).map(it -> it.replaceFirst(CUSTOM_HEADER_KEY, "")).map(headerName -> {
            String headerValue = (String)options.get(CUSTOM_HEADER_KEY + headerName).filter(String.class::isInstance).map(String.class::cast).get();
            return new Header(headerName, headerValue);
        }).toList();
    }

    @Generated
    public DestinationServiceOptionsAugmenter() {
    }

    @Beta
    public static enum CrossLevelScope {
        SUBACCOUNT("subaccount"),
        PROVIDER_SUBACCOUNT("provider_subaccount"),
        INSTANCE("instance"),
        PROVIDER_INSTANCE("provider_instance");

        private final String identifier;

        @Nonnull
        public String getSuffix() {
            return "@" + this.identifier;
        }

        @Generated
        private CrossLevelScope(String identifier) {
            this.identifier = identifier;
        }
    }
}

