/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.collect.ImmutableList;
import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationHeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationPropertyKey;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceOptionsAugmenter;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import io.vavr.control.Option;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransparentProxyDestination
implements HttpDestination {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransparentProxyDestination.class);
    static final String DESTINATION_NAME_HEADER_KEY = "x-destination-name";
    static final String FRAGMENT_NAME_HEADER_KEY = "x-fragment-name";
    static final String TENANT_SUBDOMAIN_HEADER_KEY = "x-tenant-subdomain";
    static final String TENANT_ID_HEADER_KEY = "x-tenant-id";
    static final String FRAGMENT_OPTIONAL_HEADER_KEY = "x-fragment-optional";
    static final String DESTINATION_LEVEL_HEADER_KEY = "x-destination-level";
    static final String FRAGMENT_LEVEL_HEADER_KEY = "x-fragment-level";
    static final String TOKEN_SERVICE_TENANT_HEADER_KEY = "x-token-service-tenant";
    static final String CLIENT_ASSERTION_HEADER_KEY = "x-client-assertion";
    static final String CLIENT_ASSERTION_TYPE_HEADER_KEY = "x-client-assertion-type";
    static final String CLIENT_ASSERTION_DESTINATION_NAME_HEADER_KEY = "x-client-assertion-destination-name";
    static final String AUTHORIZATION_HEADER_KEY = "authorization";
    static final String SUBJECT_TOKEN_TYPE_HEADER_KEY = "x-subject-token-type";
    static final String ACTOR_TOKEN_HEADER_KEY = "x-actor-token";
    static final String ACTOR_TOKEN_TYPE_HEADER_KEY = "x-actor-token-type";
    static final String REDIRECT_URI_HEADER_KEY = "x-redirect-uri";
    static final String CODE_VERIFIER_HEADER_KEY = "x-code-verifier";
    static final String CHAIN_NAME_HEADER_KEY = "x-chain-name";
    static final String CHAIN_VAR_SUBJECT_TOKEN_HEADER_KEY = "x-chain-var-subjectToken";
    static final String CHAIN_VAR_SUBJECT_TOKEN_TYPE_HEADER_KEY = "x-chain-var-subjectTokenType";
    static final String CHAIN_VAR_SAML_PROVIDER_DESTINATION_NAME_HEADER_KEY = "x-chain-var-samlProviderDestinationName";
    static final String TENANT_ID_AND_TENANT_SUBDOMAIN_BOTH_PASSED_ERROR_MESSAGE = "Tenant id and tenant subdomain cannot be passed at the same time.";
    private final DestinationProperties baseProperties;
    @Nonnull
    final ImmutableList<Header> customHeaders;
    @Nonnull
    private final ImmutableList<DestinationHeaderProvider> customHeaderProviders;
    @Nonnull
    private final ImmutableList<DestinationHeaderProvider> headerProvidersFromClassLoading;

    private TransparentProxyDestination(@Nonnull DestinationProperties baseProperties, @Nullable List<Header> customHeaders, @Nullable List<DestinationHeaderProvider> customHeaderProviders) {
        this.baseProperties = baseProperties;
        this.customHeaders = customHeaders != null ? ImmutableList.builder().addAll(customHeaders).build() : ImmutableList.of();
        Collection headerProvidersFromClassLoading = FacadeLocator.getFacades(DestinationHeaderProvider.class);
        this.headerProvidersFromClassLoading = ImmutableList.builder().addAll((Iterable)headerProvidersFromClassLoading).build();
        this.customHeaderProviders = customHeaderProviders != null ? ImmutableList.builder().addAll(customHeaderProviders).build() : ImmutableList.of();
    }

    @Nonnull
    public URI getUri() {
        return URI.create((String)this.baseProperties.get(DestinationProperty.URI).get());
    }

    @Nonnull
    public Collection<Header> getHeaders(@Nonnull URI requestUri) {
        ArrayList<Header> allHeaders = new ArrayList<Header>();
        allHeaders.addAll((Collection<Header>)this.customHeaders);
        allHeaders.addAll(DefaultHttpDestination.getHeadersFromHeaderProviders((HttpDestination)this, (URI)requestUri, this.customHeaderProviders, this.headerProvidersFromClassLoading));
        TenantAccessor.tryGetCurrentTenant().onSuccess(tenant -> {
            if (!TransparentProxyDestination.containsHeader(allHeaders, TENANT_ID_HEADER_KEY) && !TransparentProxyDestination.containsHeader(allHeaders, TENANT_SUBDOMAIN_HEADER_KEY)) {
                allHeaders.add(new Header(TENANT_ID_HEADER_KEY, tenant.getTenantId()));
            }
        });
        AuthTokenAccessor.tryGetCurrentToken().onSuccess(token -> {
            if (!TransparentProxyDestination.containsHeader(allHeaders, AUTHORIZATION_HEADER_KEY)) {
                allHeaders.add(new Header(AUTHORIZATION_HEADER_KEY, token.getJwt().getToken()));
            }
        });
        return allHeaders;
    }

    static boolean containsHeader(Collection<Header> headers, String headerName) {
        return headers.stream().anyMatch(h -> h.getName().equalsIgnoreCase(headerName));
    }

    @Nonnull
    public Option<String> getTlsVersion() {
        return Option.none();
    }

    @Nonnull
    public Option<ProxyConfiguration> getProxyConfiguration() {
        return Option.none();
    }

    @Nonnull
    public Option<KeyStore> getKeyStore() {
        return Option.none();
    }

    @Nonnull
    public Option<String> getKeyStorePassword() {
        return Option.none();
    }

    public boolean isTrustingAllCertificates() {
        return false;
    }

    @Nonnull
    public Option<BasicCredentials> getBasicCredentials() {
        return Option.none();
    }

    @Nonnull
    public AuthenticationType getAuthenticationType() {
        return AuthenticationType.NO_AUTHENTICATION;
    }

    @Nonnull
    public Option<ProxyType> getProxyType() {
        return Option.none();
    }

    @Nonnull
    public Option<KeyStore> getTrustStore() {
        return Option.none();
    }

    @Nonnull
    public Option<String> getTrustStorePassword() {
        return Option.none();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransparentProxyDestination that = (TransparentProxyDestination)o;
        return new EqualsBuilder().append((Object)this.baseProperties, (Object)that.baseProperties).append(this.customHeaders, that.customHeaders).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.baseProperties).append(this.customHeaders).toHashCode();
    }

    @Nonnull
    public static Builder destination(@Nonnull String uri) {
        return new Builder(uri);
    }

    @Nonnull
    public static GatewayBuilder gateway(@Nonnull String destinationName, @Nonnull String uri) {
        return new GatewayBuilder(destinationName, uri);
    }

    @Nonnull
    @Generated
    ImmutableList<DestinationHeaderProvider> getCustomHeaderProviders() {
        return this.customHeaderProviders;
    }

    @Generated
    public Option<Object> get(String arg0) {
        return this.baseProperties.get(arg0);
    }

    @Generated
    public Iterable<String> getPropertyNames() {
        return this.baseProperties.getPropertyNames();
    }

    @Generated
    public <ValueT> Option<ValueT> get(String key, Class<ValueT> expectedType) {
        return this.baseProperties.get(key, expectedType);
    }

    @Generated
    public <ValueT> Option<ValueT> get(String key, Function<Object, ValueT> conversion) {
        return this.baseProperties.get(key, conversion);
    }

    @Generated
    public <ValueT> Option<ValueT> get(DestinationPropertyKey<ValueT> propertyKey) {
        return this.baseProperties.get(propertyKey);
    }

    public static final class Builder
    extends AbstractBuilder<Builder> {
        private Builder(@Nonnull String uri) {
            this.property(DestinationProperty.URI, uri);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }

    public static final class GatewayBuilder
    extends AbstractBuilder<GatewayBuilder> {
        private GatewayBuilder(@Nonnull String destinationName, @Nonnull String uri) {
            if (destinationName.isEmpty()) {
                throw new IllegalArgumentException("The 'destinationName' property is required for destination-gateway but was not set.");
            }
            this.header(TransparentProxyDestination.DESTINATION_NAME_HEADER_KEY, destinationName);
            this.property(DestinationProperty.URI, uri);
        }

        @Override
        protected GatewayBuilder getThis() {
            return this;
        }

        @Nonnull
        public GatewayBuilder fragmentName(@Nonnull String fragmentName) {
            return (GatewayBuilder)this.header(new Header(TransparentProxyDestination.FRAGMENT_NAME_HEADER_KEY, fragmentName));
        }

        @Nonnull
        public GatewayBuilder destinationLevel(@Nonnull DestinationServiceOptionsAugmenter.CrossLevelScope destinationLevel) {
            return (GatewayBuilder)this.header(new Header(TransparentProxyDestination.DESTINATION_LEVEL_HEADER_KEY, destinationLevel.toString()));
        }

        @Nonnull
        public GatewayBuilder fragmentLevel(@Nonnull DestinationServiceOptionsAugmenter.CrossLevelScope fragmentLevel) {
            return (GatewayBuilder)this.header(new Header(TransparentProxyDestination.FRAGMENT_LEVEL_HEADER_KEY, fragmentLevel.toString()));
        }

        @Nonnull
        public GatewayBuilder fragmentOptional(boolean fragmentOptional) {
            return (GatewayBuilder)this.header(new Header(TransparentProxyDestination.FRAGMENT_OPTIONAL_HEADER_KEY, Boolean.toString(fragmentOptional)));
        }
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        final List<Header> headers = new ArrayList<Header>();
        final List<DestinationHeaderProvider> customHeaderProviders = new ArrayList<DestinationHeaderProvider>();
        final DefaultDestination.Builder propertiesBuilder = DefaultDestination.builder();

        protected abstract B getThis();

        @Nonnull
        public B property(@Nonnull String key, @Nonnull Object value) {
            this.propertiesBuilder.property(key, value);
            return this.getThis();
        }

        @Nonnull
        public <ValueT> B property(@Nonnull DestinationPropertyKey<ValueT> key, @Nonnull ValueT value) {
            return this.property(key.getKeyName(), value);
        }

        @Nonnull
        public B headers(@Nonnull Collection<Header> headers) {
            this.headers.addAll(headers);
            return this.getThis();
        }

        @Nonnull
        public B header(@Nonnull Header header) {
            this.headers.add(header);
            return this.getThis();
        }

        @Nonnull
        public B header(@Nonnull String headerName, @Nonnull String headerValue) {
            return this.header(new Header(headerName, headerValue));
        }

        @Nonnull
        public B tenantSubdomain(@Nonnull String tenantSubdomain) {
            if (TransparentProxyDestination.containsHeader(this.headers, TransparentProxyDestination.TENANT_ID_HEADER_KEY)) {
                throw new IllegalStateException(TransparentProxyDestination.TENANT_ID_AND_TENANT_SUBDOMAIN_BOTH_PASSED_ERROR_MESSAGE);
            }
            return this.header(new Header(TransparentProxyDestination.TENANT_SUBDOMAIN_HEADER_KEY, tenantSubdomain));
        }

        @Nonnull
        public B tenantId(@Nonnull String tenantId) {
            if (TransparentProxyDestination.containsHeader(this.headers, TransparentProxyDestination.TENANT_SUBDOMAIN_HEADER_KEY)) {
                throw new IllegalStateException(TransparentProxyDestination.TENANT_ID_AND_TENANT_SUBDOMAIN_BOTH_PASSED_ERROR_MESSAGE);
            }
            return this.header(new Header(TransparentProxyDestination.TENANT_ID_HEADER_KEY, tenantId));
        }

        @Nonnull
        public B tokenServiceTenant(@Nonnull String tokenServiceTenant) {
            return this.header(new Header(TransparentProxyDestination.TOKEN_SERVICE_TENANT_HEADER_KEY, tokenServiceTenant));
        }

        @Nonnull
        public B clientAssertion(@Nonnull String clientAssertion) {
            return this.header(new Header(TransparentProxyDestination.CLIENT_ASSERTION_HEADER_KEY, clientAssertion));
        }

        @Nonnull
        public B clientAssertionType(@Nonnull String clientAssertionType) {
            return this.header(new Header(TransparentProxyDestination.CLIENT_ASSERTION_TYPE_HEADER_KEY, clientAssertionType));
        }

        @Nonnull
        public B clientAssertionDestinationName(@Nonnull String clientAssertionDestinationName) {
            return this.header(new Header(TransparentProxyDestination.CLIENT_ASSERTION_DESTINATION_NAME_HEADER_KEY, clientAssertionDestinationName));
        }

        @Nonnull
        public B authorization(@Nonnull String authorization) {
            return this.header(new Header(TransparentProxyDestination.AUTHORIZATION_HEADER_KEY, authorization));
        }

        @Nonnull
        public B subjectTokenType(@Nonnull String subjectTokenType) {
            return this.header(new Header(TransparentProxyDestination.SUBJECT_TOKEN_TYPE_HEADER_KEY, subjectTokenType));
        }

        @Nonnull
        public B actorToken(@Nonnull String actorToken) {
            return this.header(new Header(TransparentProxyDestination.ACTOR_TOKEN_HEADER_KEY, actorToken));
        }

        @Nonnull
        public B actorTokenType(@Nonnull String actorTokenType) {
            return this.header(new Header(TransparentProxyDestination.ACTOR_TOKEN_TYPE_HEADER_KEY, actorTokenType));
        }

        @Nonnull
        public B redirectUri(@Nonnull String redirectUri) {
            return this.header(new Header(TransparentProxyDestination.REDIRECT_URI_HEADER_KEY, redirectUri));
        }

        @Nonnull
        public B codeVerifier(@Nonnull String codeVerifier) {
            return this.header(new Header(TransparentProxyDestination.CODE_VERIFIER_HEADER_KEY, codeVerifier));
        }

        @Nonnull
        public B chainName(@Nonnull String chainName) {
            return this.header(new Header(TransparentProxyDestination.CHAIN_NAME_HEADER_KEY, chainName));
        }

        @Nonnull
        public B chainVarSubjectToken(@Nonnull String subjectToken) {
            return this.header(new Header(TransparentProxyDestination.CHAIN_VAR_SUBJECT_TOKEN_HEADER_KEY, subjectToken));
        }

        @Nonnull
        public B chainVarSubjectTokenType(@Nonnull String subjectTokenType) {
            return this.header(new Header(TransparentProxyDestination.CHAIN_VAR_SUBJECT_TOKEN_TYPE_HEADER_KEY, subjectTokenType));
        }

        @Nonnull
        public B chainVarSamlProviderDestinationName(@Nonnull String samlProviderDestinationName) {
            return this.header(new Header(TransparentProxyDestination.CHAIN_VAR_SAML_PROVIDER_DESTINATION_NAME_HEADER_KEY, samlProviderDestinationName));
        }

        @Nonnull
        public TransparentProxyDestination build() {
            return new TransparentProxyDestination((DestinationProperties)this.propertiesBuilder.build(), this.headers, this.customHeaderProviders);
        }
    }
}

