/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationRetrieval;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceOptionsAugmenter;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceRetrievalStrategy;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceTokenExchangeStrategy;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceV1Response;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationUtility;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DestinationRetrievalStrategyResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DestinationRetrievalStrategyResolver.class);
    private static final Strategy tokenExchangeOnlyStrategy = new Strategy(OnBehalfOf.NAMED_USER_CURRENT_TENANT, false);
    private final Supplier<String> providerTenantIdSupplier;
    private final Function<Strategy, DestinationServiceV1Response> destinationRetriever;
    private final Function<OnBehalfOf, List<DestinationProperties>> allDestinationRetriever;
    static final String JWT_ATTR_EXT = "ext_attr";
    static final String JWT_ATTR_ENHANCER = "enhancer";
    static final String JWT_ATTR_XSUAA = "XSUAA";

    static DestinationRetrievalStrategyResolver forSingleDestination(Supplier<String> providerTenantIdSupplier, Function<Strategy, DestinationServiceV1Response> destinationRetriever) {
        return new DestinationRetrievalStrategyResolver(providerTenantIdSupplier, destinationRetriever, any -> Collections.emptyList());
    }

    static DestinationRetrievalStrategyResolver forAllDestinations(Supplier<String> providerTenantIdSupplier, Function<OnBehalfOf, List<DestinationProperties>> allDestinationRetriever) {
        return new DestinationRetrievalStrategyResolver(providerTenantIdSupplier, any -> null, allDestinationRetriever);
    }

    Strategy resolveSingleRequestStrategy(@Nonnull DestinationServiceRetrievalStrategy retrievalStrategy, @Nonnull DestinationServiceTokenExchangeStrategy tokenExchangeStrategy) {
        OnBehalfOf behalfTechnicalUser = switch (retrievalStrategy) {
            case DestinationServiceRetrievalStrategy.ALWAYS_PROVIDER -> OnBehalfOf.TECHNICAL_USER_PROVIDER;
            case DestinationServiceRetrievalStrategy.CURRENT_TENANT, DestinationServiceRetrievalStrategy.ONLY_SUBSCRIBER -> OnBehalfOf.TECHNICAL_USER_CURRENT_TENANT;
            default -> throw new IllegalStateException("Unexpected retrieval strategy " + retrievalStrategy + " when building a request towards the destination service.");
        };
        switch (tokenExchangeStrategy) {
            case FORWARD_USER_TOKEN: {
                return new Strategy(behalfTechnicalUser, true);
            }
            case LOOKUP_ONLY: {
                return new Strategy(behalfTechnicalUser, false);
            }
            case EXCHANGE_ONLY: {
                return new Strategy(OnBehalfOf.NAMED_USER_CURRENT_TENANT, false);
            }
        }
        throw new IllegalStateException("Unexpected token exchange strategy " + tokenExchangeStrategy + " when building a request towards the destination service.");
    }

    DestinationRetrieval prepareSupplier(@Nonnull DestinationOptions options) {
        DestinationServiceRetrievalStrategy retrievalStrategy = (DestinationServiceRetrievalStrategy)((Object)DestinationServiceOptionsAugmenter.getRetrievalStrategy(options).getOrElse((Object)DestinationServiceRetrievalStrategy.CURRENT_TENANT));
        DestinationServiceTokenExchangeStrategy tokenExchangeStrategy = (DestinationServiceTokenExchangeStrategy)((Object)DestinationServiceOptionsAugmenter.getTokenExchangeStrategy(options).getOrElse(this::getDefaultTokenExchangeStrategy));
        log.debug("Loading destination from reuse-destination-service with retrieval strategy {} and token exchange strategy {}.", (Object)retrievalStrategy, (Object)tokenExchangeStrategy);
        return this.prepareSupplier(retrievalStrategy, tokenExchangeStrategy);
    }

    @Nonnull
    private DestinationServiceTokenExchangeStrategy getDefaultTokenExchangeStrategy() {
        Map attributes = (Map)AuthTokenAccessor.tryGetCurrentToken().map(t -> t.getJwt().getClaim(JWT_ATTR_EXT).asMap()).getOrNull();
        if (attributes == null || !JWT_ATTR_XSUAA.equalsIgnoreCase("" + attributes.get(JWT_ATTR_ENHANCER))) {
            log.debug("Falling back to {}. Current user token may not originate from XSUAA.", (Object)DestinationServiceTokenExchangeStrategy.LOOKUP_THEN_EXCHANGE);
            return DestinationServiceTokenExchangeStrategy.LOOKUP_THEN_EXCHANGE;
        }
        return DestinationServiceTokenExchangeStrategy.FORWARD_USER_TOKEN;
    }

    DestinationRetrieval prepareSupplier(@Nonnull DestinationServiceRetrievalStrategy retrievalStrategy, @Nonnull DestinationServiceTokenExchangeStrategy tokenExchangeStrategy) throws DestinationAccessException {
        log.debug("Preparing request(s) towards the destination service based on the strategies {} and {}", (Object)retrievalStrategy, (Object)tokenExchangeStrategy);
        this.warnOrThrowOnUnsupportedCombinations(retrievalStrategy, tokenExchangeStrategy);
        if (tokenExchangeStrategy == DestinationServiceTokenExchangeStrategy.LOOKUP_THEN_EXCHANGE) {
            Strategy strategy = this.resolveSingleRequestStrategy(retrievalStrategy, DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY);
            return new DestinationRetrieval(() -> {
                DestinationServiceV1Response result = this.destinationRetriever.apply(strategy);
                if (!this.doesDestinationConfigurationRequireUserTokenExchange(result)) {
                    return result;
                }
                if (retrievalStrategy == DestinationServiceRetrievalStrategy.ALWAYS_PROVIDER && !this.currentTenantIsProvider()) {
                    throw new DestinationAccessException("Can't perform token exchange, the current token is not issued for the provider tenant.");
                }
                return this.destinationRetriever.apply(tokenExchangeOnlyStrategy);
            }, strategy.getBehalf());
        }
        Strategy strategy = this.resolveSingleRequestStrategy(retrievalStrategy, tokenExchangeStrategy);
        return new DestinationRetrieval(() -> this.destinationRetriever.apply(strategy), strategy.getBehalf());
    }

    private void warnOrThrowOnUnsupportedCombinations(@Nonnull DestinationServiceRetrievalStrategy retrievalStrategy, @Nullable DestinationServiceTokenExchangeStrategy tokenExchangeStrategy) {
        if (retrievalStrategy == DestinationServiceRetrievalStrategy.ONLY_SUBSCRIBER && this.currentTenantIsProvider()) {
            throw new DestinationAccessException("The current tenant is the provider tenant, which should not be the case with the option " + DestinationServiceRetrievalStrategy.ONLY_SUBSCRIBER + ". Cannot retrieve destination.");
        }
        if (retrievalStrategy == DestinationServiceRetrievalStrategy.ALWAYS_PROVIDER && !this.currentTenantIsProvider()) {
            if (tokenExchangeStrategy == DestinationServiceTokenExchangeStrategy.EXCHANGE_ONLY) {
                throw new DestinationAccessException("The current tenant is not the provider tenant, which should not be the case with the options " + DestinationServiceRetrievalStrategy.ALWAYS_PROVIDER + " and " + DestinationServiceTokenExchangeStrategy.EXCHANGE_ONLY + ". Cannot retrieve destination.");
            }
            if (tokenExchangeStrategy != DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY) {
                log.warn("The current tenant is not the provider tenant. Only destinations which don't require a user token will be supported. Use retrieval strategy {} to avoid this warning.", (Object)DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY);
            }
        }
    }

    Supplier<List<DestinationProperties>> prepareSupplierAllDestinations(@Nonnull DestinationOptions options) {
        DestinationServiceTokenExchangeStrategy tokenExchangeStrategy = (DestinationServiceTokenExchangeStrategy)((Object)DestinationServiceOptionsAugmenter.getTokenExchangeStrategy(options).getOrElse((Object)DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY));
        if (tokenExchangeStrategy != DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY) {
            log.warn("The provided token exchange strategy {} is not applicable while retrieving all destinations, hence switching to {} ", (Object)tokenExchangeStrategy, (Object)DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY);
        }
        DestinationServiceRetrievalStrategy retrievalStrategy = (DestinationServiceRetrievalStrategy)((Object)DestinationServiceOptionsAugmenter.getRetrievalStrategy(options).getOrElse((Object)DestinationServiceRetrievalStrategy.CURRENT_TENANT));
        return this.prepareSupplierAllDestinations(retrievalStrategy);
    }

    Supplier<List<DestinationProperties>> prepareSupplierAllDestinations(@Nonnull DestinationServiceRetrievalStrategy strategy) throws IllegalArgumentException {
        this.warnOrThrowOnUnsupportedCombinations(strategy, null);
        switch (strategy) {
            case ALWAYS_PROVIDER: {
                return () -> this.allDestinationRetriever.apply(OnBehalfOf.TECHNICAL_USER_PROVIDER);
            }
            case CURRENT_TENANT: 
            case ONLY_SUBSCRIBER: {
                return () -> this.allDestinationRetriever.apply(OnBehalfOf.TECHNICAL_USER_CURRENT_TENANT);
            }
        }
        throw new IllegalArgumentException("The provided destination retrieval strategy " + strategy + " is not valid.");
    }

    boolean doesDestinationConfigurationRequireUserTokenExchange(@Nonnull DestinationServiceV1Response response) {
        Map<String, String> destinationConfiguration = response.getDestinationConfiguration();
        Try<AuthenticationType> authenticationType = this.determineAuthenticationType(destinationConfiguration);
        if (authenticationType.isSuccess()) {
            AuthenticationType authType = (AuthenticationType)authenticationType.get();
            String systemUser = destinationConfiguration.get(DestinationProperty.SYSTEM_USER.getKeyName());
            return DestinationUtility.requiresUserTokenExchange((AuthenticationType)authType, (String)systemUser);
        }
        log.warn("No configuration value set for 'Authentication' in destination {}.", (Object)destinationConfiguration.get(DestinationProperty.NAME.getKeyName()));
        return false;
    }

    private boolean currentTenantIsProvider() {
        String currentTenantId = (String)TenantAccessor.tryGetCurrentTenant().map(Tenant::getTenantId).getOrNull();
        String providerTenantId = this.providerTenantIdSupplier.get();
        return Objects.equals(currentTenantId, providerTenantId);
    }

    private Try<AuthenticationType> determineAuthenticationType(Map<String, String> destinationConfiguration) {
        TreeMap<String, String> destinationData = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        destinationData.putAll(destinationConfiguration);
        String authenticationValue = (String)destinationData.get(DestinationProperty.AUTH_TYPE.getKeyName());
        return Try.of((CheckedFunction0 & Serializable)() -> AuthenticationType.ofIdentifier((String)authenticationValue));
    }

    @Generated
    public DestinationRetrievalStrategyResolver(Supplier<String> providerTenantIdSupplier, Function<Strategy, DestinationServiceV1Response> destinationRetriever, Function<OnBehalfOf, List<DestinationProperties>> allDestinationRetriever) {
        this.providerTenantIdSupplier = providerTenantIdSupplier;
        this.destinationRetriever = destinationRetriever;
        this.allDestinationRetriever = allDestinationRetriever;
    }

    static final class Strategy {
        private final OnBehalfOf behalf;
        private final boolean forwardToken;

        @Generated
        public Strategy(OnBehalfOf behalf, boolean forwardToken) {
            this.behalf = behalf;
            this.forwardToken = forwardToken;
        }

        @Generated
        public OnBehalfOf getBehalf() {
            return this.behalf;
        }

        @Generated
        public boolean isForwardToken() {
            return this.forwardToken;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Strategy)) {
                return false;
            }
            Strategy other = (Strategy)o;
            if (this.isForwardToken() != other.isForwardToken()) {
                return false;
            }
            OnBehalfOf this$behalf = this.getBehalf();
            OnBehalfOf other$behalf = other.getBehalf();
            return !(this$behalf == null ? other$behalf != null : !this$behalf.equals(other$behalf));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isForwardToken() ? 79 : 97);
            OnBehalfOf $behalf = this.getBehalf();
            result = result * 59 + ($behalf == null ? 43 : $behalf.hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "DestinationRetrievalStrategyResolver.Strategy(behalf=" + this.getBehalf() + ", forwardToken=" + this.isForwardToken() + ")";
        }
    }
}

