/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.Beta;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.cache.CacheManager;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationRetrieval;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationRetrievalStrategyResolver;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceAdapter;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceV1Response;
import com.sap.cloud.sdk.cloudplatform.connectivity.GetOrComputeAllDestinationsCommand;
import com.sap.cloud.sdk.cloudplatform.connectivity.GetOrComputeSingleDestinationCommand;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.resilience.CacheExpirationStrategy;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorator;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceRuntimeException;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationService
implements DestinationLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DestinationService.class);
    private static final String PATH_DEFAULT = "/destinations/";
    private static final String PATH_SERVICE_INSTANCE = "/instanceDestinations";
    private static final String PATH_SUBACCOUNT = "/subaccountDestinations";
    static final ResilienceConfiguration.TimeLimiterConfiguration DEFAULT_TIME_LIMITER = ResilienceConfiguration.TimeLimiterConfiguration.of().timeoutDuration(Duration.ofSeconds(6L));
    static final ResilienceConfiguration.CircuitBreakerConfiguration DEFAULT_SINGLE_DEST_CIRCUIT_BREAKER = ResilienceConfiguration.CircuitBreakerConfiguration.of().waitDuration(Duration.ofSeconds(6L));
    static final ResilienceConfiguration.CircuitBreakerConfiguration DEFAULT_ALL_DEST_CIRCUIT_BREAKER = ResilienceConfiguration.CircuitBreakerConfiguration.of().waitDuration(Duration.ofMinutes(1L));
    private static final Gson GSON = new Gson();
    @Nonnull
    private final DestinationServiceAdapter adapter;
    @Nonnull
    private final ResilienceConfiguration singleDestResilience;
    @Nonnull
    private final ResilienceConfiguration allDestResilience;

    public DestinationService() {
        this(new DestinationServiceAdapter());
    }

    DestinationService(@Nonnull DestinationServiceAdapter adapter) {
        this(adapter, DestinationService.createResilienceConfiguration("singleDestResilience", DEFAULT_TIME_LIMITER, DEFAULT_SINGLE_DEST_CIRCUIT_BREAKER), DestinationService.createResilienceConfiguration("allDestResilience", DEFAULT_TIME_LIMITER, DEFAULT_ALL_DEST_CIRCUIT_BREAKER));
    }

    @Nonnull
    static ResilienceConfiguration createResilienceConfiguration(@Nonnull String identifier, @Nonnull ResilienceConfiguration.TimeLimiterConfiguration timeLimiterConfiguration, @Nonnull ResilienceConfiguration.CircuitBreakerConfiguration circuitBreakerConfiguration) {
        return ResilienceConfiguration.of((String)(DestinationService.class + identifier)).isolationMode(ResilienceIsolationMode.TENANT_OPTIONAL).timeLimiterConfiguration(timeLimiterConfiguration).circuitBreakerConfiguration(circuitBreakerConfiguration);
    }

    @Nonnull
    public Try<Destination> tryGetDestination(@Nonnull String destinationName, @Nonnull DestinationOptions options) {
        return Cache.getOrComputeDestination(this, destinationName, options, this::loadAndParseDestination);
    }

    Destination loadAndParseDestination(String destName, DestinationOptions options) throws DestinationAccessException, DestinationNotFoundException {
        String servicePath = PATH_DEFAULT + destName;
        Function<DestinationRetrievalStrategyResolver.Strategy, DestinationServiceV1Response> destinationRetriever = strategy -> this.resilientCall(() -> this.retrieveDestination((DestinationRetrievalStrategyResolver.Strategy)strategy, servicePath), this.singleDestResilience);
        DestinationRetrievalStrategyResolver destinationRetrievalStrategyResolver = DestinationRetrievalStrategyResolver.forSingleDestination(this.adapter::getProviderTenantId, destinationRetriever);
        DestinationRetrieval retrieval = destinationRetrievalStrategyResolver.prepareSupplier(options);
        return DestinationServiceFactory.fromDestinationServiceV1Response(retrieval.get(), retrieval.getOnBehalfOf());
    }

    @Nonnull
    DestinationServiceV1Response retrieveDestination(DestinationRetrievalStrategyResolver.Strategy strategy, String servicePath) {
        String response = strategy.isForwardToken() ? this.adapter.getConfigurationAsJsonWithUserToken(servicePath, strategy.getBehalf()) : this.adapter.getConfigurationAsJson(servicePath, strategy.getBehalf());
        return DestinationService.deserializeDestinationResponse(response);
    }

    @Deprecated
    @Nonnull
    public Try<Iterable<Destination>> tryGetAllDestinations() {
        return this.tryGetAllDestinations(DestinationOptions.builder().build());
    }

    @Nonnull
    public Collection<DestinationProperties> getAllDestinationProperties() {
        return new ArrayList<DestinationProperties>((Collection)Cache.getOrComputeAllDestinations(DestinationOptions.builder().build(), this::getAllDestinationsByRetrievalStrategy).get());
    }

    @Nonnull
    public DestinationProperties getDestinationProperties(@Nonnull String destinationName) {
        return this.getAllDestinationProperties().stream().filter(dest -> dest.get(DestinationProperty.NAME).contains((Object)destinationName)).findAny().orElseThrow(() -> new DestinationNotFoundException("Destination " + destinationName + " not found."));
    }

    @Nonnull
    @Deprecated
    public Try<Iterable<Destination>> tryGetAllDestinations(@Nonnull DestinationOptions options) {
        Try<List<DestinationProperties>> maybeDestinationList = Cache.getOrComputeAllDestinations(options, this::getAllDestinationsByRetrievalStrategy);
        if (maybeDestinationList.isFailure()) {
            return Try.failure((Throwable)maybeDestinationList.getCause());
        }
        List destinationList = (List)maybeDestinationList.get();
        ArrayList<DefaultDestination> result = new ArrayList<DefaultDestination>();
        for (DestinationProperties destination : destinationList) {
            DefaultDestination.Builder builder = DefaultDestination.builder();
            destination.getPropertyNames().forEach(key -> builder.property(key, destination.get(key).get()));
            result.add(builder.build());
        }
        return Try.success(result);
    }

    @Nonnull
    private Try<List<DestinationProperties>> getAllDestinationsByRetrievalStrategy(@Nonnull DestinationOptions options) {
        DestinationRetrievalStrategyResolver resolver = DestinationRetrievalStrategyResolver.forAllDestinations(this.adapter::getProviderTenantId, this::loadAndParseAllDestinations);
        return Try.success((Object)options).map(resolver::prepareSupplierAllDestinations).map(Supplier::get);
    }

    @Nonnull
    private List<DestinationProperties> loadAndParseAllDestinations(@Nonnull OnBehalfOf behalf) {
        List serviceInstanceDestinations = this.resilientCall(() -> this.getAndDeserializeDestinations(PATH_SERVICE_INSTANCE, behalf), this.allDestResilience);
        List subAccountDestinations = this.resilientCall(() -> this.getAndDeserializeDestinations(PATH_SUBACCOUNT, behalf), this.allDestResilience);
        LinkedHashMap<String, DestinationProperties> result = new LinkedHashMap<String, DestinationProperties>();
        for (DestinationProperties destination : serviceInstanceDestinations) {
            result.putIfAbsent((String)destination.get(DestinationProperty.NAME).get(), destination);
        }
        for (DestinationProperties destination : subAccountDestinations) {
            result.putIfAbsent((String)destination.get(DestinationProperty.NAME).get(), destination);
        }
        log.debug("Loaded {} destinations: {}", (Object)result.size(), result.keySet());
        return new ArrayList<DestinationProperties>(result.values());
    }

    @Nonnull
    private static DestinationServiceV1Response deserializeDestinationResponse(@Nonnull String json) throws DestinationAccessException {
        try {
            return (DestinationServiceV1Response)GSON.fromJson(json, DestinationServiceV1Response.class);
        }
        catch (Exception e) {
            log.debug("Failed to parse destination response payload: {}", (Object)json);
            String message = "Illegal JSON response while fetching a destination from destination service";
            throw new DestinationAccessException("Illegal JSON response while fetching a destination from destination service", (Throwable)e);
        }
    }

    @Nonnull
    private List<Destination> getAndDeserializeDestinations(@Nonnull String servicePath, @Nonnull OnBehalfOf behalf) throws DestinationAccessException {
        String json = this.adapter.getConfigurationAsJson(servicePath, behalf);
        return Streams.stream((Iterable)((JsonElement)GSON.fromJson(json, JsonElement.class)).getAsJsonArray()).map(jsonElement -> (Map)GSON.fromJson(jsonElement, Map.class)).map(DefaultDestination::fromMap).peek(d -> {
            if (d.get(DestinationProperty.NAME).isEmpty()) {
                throw new DestinationAccessException("Found a destination without name. A name is required for destinations defined in the destination service.");
            }
        }).map(DefaultDestination.Builder::build).collect(Collectors.toList());
    }

    private <T> T resilientCall(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration) {
        try {
            return (T)ResilienceDecorator.executeSupplier(supplier, (ResilienceConfiguration)configuration);
        }
        catch (ResilienceRuntimeException e) {
            if (DestinationService.hasCauseAssignableFrom(e, DestinationNotFoundException.class)) {
                throw new DestinationNotFoundException((Throwable)e);
            }
            throw new DestinationAccessException("Failed to get destination.", (Throwable)e);
        }
    }

    private static boolean hasCauseAssignableFrom(@Nonnull Throwable t, @Nonnull Class<?> cls) {
        return ExceptionUtils.getThrowableList((Throwable)t).stream().map(Object::getClass).anyMatch(cls::isAssignableFrom);
    }

    @Nonnull
    @Beta
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    DestinationService(@Nonnull DestinationServiceAdapter adapter, @Nonnull ResilienceConfiguration singleDestResilience, @Nonnull ResilienceConfiguration allDestResilience) {
        if (adapter == null) {
            throw new NullPointerException("adapter is marked non-null but is null");
        }
        if (singleDestResilience == null) {
            throw new NullPointerException("singleDestResilience is marked non-null but is null");
        }
        if (allDestResilience == null) {
            throw new NullPointerException("allDestResilience is marked non-null but is null");
        }
        this.adapter = adapter;
        this.singleDestResilience = singleDestResilience;
        this.allDestResilience = allDestResilience;
    }

    @Nonnull
    @Generated
    DestinationServiceAdapter getAdapter() {
        return this.adapter;
    }

    @Nonnull
    @Generated
    ResilienceConfiguration getSingleDestResilience() {
        return this.singleDestResilience;
    }

    @Nonnull
    @Generated
    ResilienceConfiguration getAllDestResilience() {
        return this.allDestResilience;
    }

    @Beta
    public static final class Cache {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(Cache.class);
        public static final long DEFAULT_SIZE_LIMIT = 1000L;
        public static final Duration DEFAULT_EXPIRATION_DURATION = Duration.ofMinutes(5L);
        public static final CacheExpirationStrategy DEFAULT_EXPIRATION_STRATEGY = CacheExpirationStrategy.WHEN_CREATED;
        @Nonnull
        private static Option<Long> sizeLimit = Option.some((Object)1000L);
        @Nonnull
        private static Option<Duration> expirationDuration = Option.some((Object)DEFAULT_EXPIRATION_DURATION);
        @Nonnull
        private static CacheExpirationStrategy expirationStrategy = DEFAULT_EXPIRATION_STRATEGY;
        @Nonnull
        private static Option<com.github.benmanes.caffeine.cache.Cache<CacheKey, Destination>> destinationsCache = Option.none();
        @Nonnull
        private static Option<com.github.benmanes.caffeine.cache.Cache<CacheKey, List<DestinationProperties>>> allDestinationsCache = Option.none();
        @Nonnull
        private static Option<com.github.benmanes.caffeine.cache.Cache<CacheKey, ReentrantLock>> isolationLocks = Option.none();
        private static boolean cacheEnabled = true;
        private static boolean changeDetectionEnabled = true;

        static boolean isEnabled() {
            return cacheEnabled;
        }

        static boolean isChangeDetectionEnabled() {
            return changeDetectionEnabled;
        }

        @Nonnull
        static com.github.benmanes.caffeine.cache.Cache<CacheKey, Destination> instanceSingle() {
            Cache.throwIfDisabled();
            return (com.github.benmanes.caffeine.cache.Cache)destinationsCache.get();
        }

        @Nonnull
        static com.github.benmanes.caffeine.cache.Cache<CacheKey, List<DestinationProperties>> instanceAll() {
            Cache.throwIfDisabled();
            return (com.github.benmanes.caffeine.cache.Cache)allDestinationsCache.get();
        }

        @Nonnull
        static com.github.benmanes.caffeine.cache.Cache<CacheKey, ReentrantLock> isolationLocks() {
            Cache.throwIfDisabled();
            return (com.github.benmanes.caffeine.cache.Cache)isolationLocks.get();
        }

        public static void disable() {
            log.debug("Disabling the destination cache.");
            cacheEnabled = false;
            destinationsCache = Cache.prepareCache(null, destinationsCache);
            allDestinationsCache = Cache.prepareCache(null, allDestinationsCache);
            isolationLocks = Cache.prepareCache(null, isolationLocks);
        }

        static void reset() {
            log.warn("Resetting the destination cache. This should not be done outside of testing.");
            if (!Cache.isEnabled()) {
                cacheEnabled = true;
            }
            changeDetectionEnabled = true;
            sizeLimit = Option.some((Object)1000L);
            expirationDuration = Option.some((Object)DEFAULT_EXPIRATION_DURATION);
            expirationStrategy = DEFAULT_EXPIRATION_STRATEGY;
            Cache.recreateSingleCache();
            Cache.recreateGetAllCache();
            Cache.recreateIsolationLockCache();
        }

        public static void setSizeLimit(@Nonnegative long size) {
            Cache.throwIfDisabled();
            log.debug("Setting destination cache size limit to {}.", (Object)size);
            sizeLimit = Option.some((Object)size);
            Cache.recreateSingleCache();
        }

        public static void disableSizeLimit() {
            Cache.throwIfDisabled();
            log.debug("Disabling destination cache size limit. The cache now stores an infinite number of entries.");
            sizeLimit = Option.none();
            Cache.recreateSingleCache();
        }

        public static void setExpiration(@Nonnull Duration duration, @Nonnull CacheExpirationStrategy strategy) {
            Cache.throwIfDisabled();
            log.debug("Setting destination cache expiration to {} {}.", (Object)duration, (Object)strategy.name());
            expirationDuration = Option.some((Object)duration);
            expirationStrategy = strategy;
            Cache.recreateSingleCache();
            Cache.recreateGetAllCache();
        }

        public static void disableExpiration() {
            Cache.throwIfDisabled();
            log.debug("Destination cache expiration has been disabled. The cache will now keep its entries until evicted (potentially forever).");
            expirationDuration = Option.none();
            if (changeDetectionEnabled) {
                log.warn("Using the 'change detection' mode is not supported when disabling the Destination cache expiration. Therefore, change detection mode will be disabled from now on.");
                Cache.disableChangeDetection();
                return;
            }
            Cache.recreateSingleCache();
            Cache.recreateGetAllCache();
        }

        @Deprecated
        @Beta
        public static void enableChangeDetection() {
            Cache.throwIfDisabled();
            if (changeDetectionEnabled) {
                return;
            }
            changeDetectionEnabled = true;
            log.debug("Destination change detection has been enabled.");
            if (!expirationDuration.isDefined()) {
                log.warn("Using the 'change detection' mode is not supported with disabled Destination cache expiration. Therefore, the default expiration ({}{}) will be restored.", (Object)DEFAULT_EXPIRATION_DURATION, (Object)DEFAULT_EXPIRATION_STRATEGY);
                expirationDuration = Option.some((Object)DEFAULT_EXPIRATION_DURATION);
                expirationStrategy = DEFAULT_EXPIRATION_STRATEGY;
            }
            allDestinationsCache = Cache.prepareCache(Cache.prepareCacheBuilder((Option<Long>)Option.none(), expirationDuration, CacheExpirationStrategy.WHEN_CREATED).build(), allDestinationsCache);
            destinationsCache = Cache.prepareCache(Cache.prepareCacheBuilder(sizeLimit, (Option<Duration>)Option.some((Object)Duration.ofDays(1L)), expirationStrategy).build(), destinationsCache);
        }

        @Beta
        public static void disableChangeDetection() {
            Cache.throwIfDisabled();
            if (!changeDetectionEnabled) {
                return;
            }
            changeDetectionEnabled = false;
            log.debug("Destination change detection has been disabled.");
            Cache.recreateSingleCache();
            Cache.recreateGetAllCache();
        }

        private static void recreateSingleCache() {
            if (!changeDetectionEnabled) {
                destinationsCache = Cache.prepareCache(Cache.prepareCacheBuilder().build(), destinationsCache);
                return;
            }
            if (!expirationDuration.isDefined()) {
                log.warn("Using the 'change detection' mode is not supported with disabled Destination cache expiration. Therefore, the default expiration strategy ({}) will be restored.", (Object)DEFAULT_EXPIRATION_STRATEGY);
                expirationStrategy = DEFAULT_EXPIRATION_STRATEGY;
            }
            destinationsCache = Cache.prepareCache(Cache.prepareCacheBuilder(sizeLimit, (Option<Duration>)Option.some((Object)Duration.ofDays(1L)), expirationStrategy).build(), destinationsCache);
        }

        private static void recreateGetAllCache() {
            if (!changeDetectionEnabled) {
                allDestinationsCache = Cache.prepareCache(Cache.prepareCacheBuilder((Option<Long>)Option.none(), expirationDuration, expirationStrategy).build(), allDestinationsCache);
                return;
            }
            if (!expirationDuration.isDefined()) {
                log.warn("Using the 'change detection' mode is not supported with disabled Destination cache expiration. Therefore, the default expiration duration ({}) will be restored.", (Object)DEFAULT_EXPIRATION_DURATION);
                expirationDuration = Option.some((Object)DEFAULT_EXPIRATION_DURATION);
            }
            allDestinationsCache = Cache.prepareCache(Cache.prepareCacheBuilder((Option<Long>)Option.none(), expirationDuration, CacheExpirationStrategy.WHEN_CREATED).build(), allDestinationsCache);
        }

        private static void recreateIsolationLockCache() {
            isolationLocks = Cache.prepareCache(Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(30L)).build(), isolationLocks);
        }

        private static <V> Option<com.github.benmanes.caffeine.cache.Cache<CacheKey, V>> prepareCache(@Nullable com.github.benmanes.caffeine.cache.Cache<CacheKey, V> newCache, @Nonnull Option<com.github.benmanes.caffeine.cache.Cache<CacheKey, V>> existingCache) {
            if (existingCache.isDefined()) {
                Cache.logCacheModifiedWarning((com.github.benmanes.caffeine.cache.Cache)existingCache.get());
                CacheManager.unregister((com.github.benmanes.caffeine.cache.Cache)((com.github.benmanes.caffeine.cache.Cache)existingCache.get()));
                ((com.github.benmanes.caffeine.cache.Cache)existingCache.get()).invalidateAll();
                ((com.github.benmanes.caffeine.cache.Cache)existingCache.get()).cleanUp();
            }
            if (newCache == null) {
                return Option.none();
            }
            return Option.some((Object)CacheManager.register(newCache));
        }

        private static void logCacheModifiedWarning(@Nonnull com.github.benmanes.caffeine.cache.Cache<CacheKey, ?> cache) {
            if (!log.isWarnEnabled()) {
                return;
            }
            if (cache.estimatedSize() > 0L) {
                log.warn("The destination cache is changed even though there are already entries within the cache. Those entries will be deleted, which might result in performance degradation. Consider configuring the cache only once at application startup to avoid this issue.");
            }
        }

        @Nonnull
        private static Caffeine<Object, Object> prepareCacheBuilder() {
            return Cache.prepareCacheBuilder(sizeLimit, expirationDuration, expirationStrategy);
        }

        @Nonnull
        private static Caffeine<Object, Object> prepareCacheBuilder(@Nonnull Option<Long> sizeLimit, @Nonnull Option<Duration> expirationDuration, @Nonnull CacheExpirationStrategy expirationStrategy) {
            Caffeine builder = Caffeine.newBuilder();
            if (sizeLimit.isDefined()) {
                builder = builder.maximumSize(((Long)sizeLimit.get()).longValue());
            }
            if (expirationDuration.isDefined()) {
                switch (expirationStrategy) {
                    case WHEN_CREATED: 
                    case WHEN_LAST_MODIFIED: {
                        builder = builder.expireAfterWrite((Duration)expirationDuration.get());
                        break;
                    }
                    case WHEN_LAST_ACCESSED: 
                    case WHEN_LAST_TOUCHED: {
                        builder = builder.expireAfterAccess((Duration)expirationDuration.get());
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unhandled '%s': %s.", CacheExpirationStrategy.class.getName(), expirationStrategy.name()));
                    }
                }
            }
            return builder;
        }

        private static Try<Destination> getOrComputeDestination(@Nonnull DestinationService loader, @Nonnull String destinationName, @Nonnull DestinationOptions options, @Nonnull BiFunction<String, DestinationOptions, Destination> destinationDownloader) {
            if (!cacheEnabled) {
                return Try.ofSupplier(() -> (Destination)destinationDownloader.apply(destinationName, options));
            }
            GetOrComputeAllDestinationsCommand getAllCommand = changeDetectionEnabled ? GetOrComputeAllDestinationsCommand.prepareCommand(options, Cache.instanceAll(), Cache.isolationLocks(), loader::getAllDestinationsByRetrievalStrategy) : null;
            Try<GetOrComputeSingleDestinationCommand> command = GetOrComputeSingleDestinationCommand.prepareCommand(destinationName, options, Cache.instanceSingle(), Cache.isolationLocks(), destinationDownloader, getAllCommand);
            return command.flatMap(GetOrComputeSingleDestinationCommand::execute);
        }

        private static Try<List<DestinationProperties>> getOrComputeAllDestinations(@Nonnull DestinationOptions options, @Nonnull Function<DestinationOptions, Try<List<DestinationProperties>>> destinationDownloader) {
            if (!cacheEnabled) {
                return destinationDownloader.apply(options);
            }
            return GetOrComputeAllDestinationsCommand.prepareCommand(options, Cache.instanceAll(), Cache.isolationLocks(), destinationDownloader).execute();
        }

        private Cache() {
            throw new IllegalStateException("This static class must never be instantiated.");
        }

        private static void throwIfDisabled() {
            if (!cacheEnabled) {
                throw new IllegalStateException("Attempted to access or configure the cache after disabling it.");
            }
        }

        @Nonnull
        @Generated
        static Option<Duration> getExpirationDuration() {
            return expirationDuration;
        }

        static {
            Cache.recreateSingleCache();
            Cache.recreateGetAllCache();
            Cache.recreateIsolationLockCache();
        }
    }

    @Beta
    public static final class Builder {
        @Nullable
        private ResilienceConfiguration.TimeLimiterConfiguration timeLimiterConfiguration = null;
        @Nullable
        private String providerTenantId;

        @Nonnull
        public Builder withTimeLimiterConfiguration(@Nonnull ResilienceConfiguration.TimeLimiterConfiguration timeLimiterConfiguration) {
            this.timeLimiterConfiguration = timeLimiterConfiguration;
            return this;
        }

        @Nonnull
        Builder withProviderTenant(@Nonnull Tenant providerTenant) {
            this.providerTenantId = providerTenant.getTenantId();
            return this;
        }

        @Nonnull
        public DestinationService build() {
            ResilienceConfiguration.TimeLimiterConfiguration timeLimiter = this.timeLimiterConfiguration != null ? this.timeLimiterConfiguration : DEFAULT_TIME_LIMITER;
            return new DestinationService(new DestinationServiceAdapter(null, null, this.providerTenantId), DestinationService.createResilienceConfiguration("singleDestResilience", timeLimiter, DEFAULT_SINGLE_DEST_CIRCUIT_BREAKER), DestinationService.createResilienceConfiguration("allDestResilience", timeLimiter, DEFAULT_ALL_DEST_CIRCUIT_BREAKER));
        }

        @Generated
        private Builder() {
        }
    }
}

