/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.sap.cloud.environment.servicebinding.api.DefaultServiceBindingAccessor;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceIdentifier;
import com.sap.cloud.environment.servicebinding.api.TypedMapView;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpEntityUtil;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.exception.MultipleServiceBindingsException;
import com.sap.cloud.sdk.cloudplatform.exception.NoServiceBindingException;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DestinationServiceAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DestinationServiceAdapter.class);
    private static final String SERVICE_PATH = "destination-configuration/v1";
    @Nonnull
    final Function<OnBehalfOf, HttpDestination> serviceDestinationLoader;
    @Nonnull
    private final Supplier<ServiceBinding> serviceBindingSupplier;
    @Nullable
    private final String providerTenantId;

    DestinationServiceAdapter() {
        this(null, null, null);
    }

    DestinationServiceAdapter(@Nullable Function<OnBehalfOf, HttpDestination> serviceDestinationLoader, @Nullable Supplier<ServiceBinding> serviceBindingSupplier, @Nullable String providerTenantId) {
        this.serviceDestinationLoader = serviceDestinationLoader != null ? serviceDestinationLoader : this.prepareServiceDestinationComputation();
        this.serviceBindingSupplier = serviceBindingSupplier != null ? serviceBindingSupplier : DestinationServiceAdapter::getDestinationServiceBinding;
        this.providerTenantId = providerTenantId;
    }

    @Nonnull
    String getProviderTenantId() throws DestinationAccessException {
        if (this.providerTenantId != null) {
            return this.providerTenantId;
        }
        TypedMapView credentials = (TypedMapView)Try.of((CheckedFunction0 & Serializable)() -> {
            ServiceBinding binding = this.serviceBindingSupplier.get();
            return TypedMapView.ofCredentials((ServiceBinding)binding);
        }).getOrElseThrow(e -> new DestinationAccessException("Could not resolve destination to Destination Service on behalf of provider.", e));
        if (credentials.containsKey("tenantid")) {
            return credentials.getString("tenantid");
        }
        throw new DestinationAccessException("The provider tenant id is not defined in the service binding. Please verify that the service binding contains the field 'tenantid' in the credentials list.");
    }

    private Function<OnBehalfOf, HttpDestination> prepareServiceDestinationComputation() {
        ConcurrentHashMap result = new ConcurrentHashMap();
        return behalf -> result.computeIfAbsent(behalf, b -> {
            try {
                ServiceBinding binding = this.serviceBindingSupplier.get();
                ServiceBindingDestinationOptions options = ServiceBindingDestinationOptions.forService((ServiceBinding)binding).onBehalfOf(b).build();
                return ServiceBindingDestinationLoader.defaultLoaderChain().getDestination(options);
            }
            catch (Exception e) {
                throw new DestinationAccessException("Could not resolve destination to Destination Service on behalf of " + b + ".", (Throwable)e);
            }
        });
    }

    @Nonnull
    private String requestDestinationConfigurationAsJson(@Nonnull String servicePath, @Nonnull Destination serviceDestination, boolean enableUserToken) throws DestinationAccessException, DestinationNotFoundException {
        HttpResponse response;
        URI requestUri;
        try {
            requestUri = new URI(SERVICE_PATH + servicePath);
        }
        catch (URISyntaxException e) {
            throw new DestinationAccessException((Throwable)e);
        }
        log.debug("Querying Destination Service via URI {}.", (Object)requestUri);
        HttpGet request = new HttpGet(requestUri);
        if (enableUserToken) {
            AuthTokenAccessor.tryGetCurrentToken().map(AuthToken::getJwt).map(DecodedJWT::getToken).map(it -> new BasicHeader("x-user-token", it)).peek(arg_0 -> ((HttpUriRequest)request).addHeader(arg_0));
        }
        try {
            response = HttpClientAccessor.getHttpClient((Destination)serviceDestination).execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new DestinationAccessException((Throwable)e);
        }
        log.debug("Destination service returned HTTP status {} ({})", (Object)response.getStatusLine().getStatusCode(), (Object)response.getStatusLine().getReasonPhrase());
        StatusLine status = response.getStatusLine();
        int statusCode = status.getStatusCode();
        String reasonPhrase = status.getReasonPhrase();
        if (statusCode != 200) {
            if (statusCode == 404) {
                throw new DestinationNotFoundException(null, "Destination could not be found for path " + servicePath + ".");
            }
            throw new DestinationAccessException(String.format("Failed to get destinations: destination service returned HTTP status %s (%S) at '%s'.,", statusCode, reasonPhrase, requestUri));
        }
        try {
            String responseBody = HttpEntityUtil.getResponseBody((HttpResponse)response);
            if (responseBody == null) {
                throw new DestinationAccessException("Failed to get destinations: no body returned in response.");
            }
            return responseBody;
        }
        catch (IOException e) {
            throw new DestinationAccessException((Throwable)e);
        }
    }

    @Nonnull
    String getConfigurationAsJsonWithUserToken(@Nonnull String servicePath, @Nonnull OnBehalfOf behalf) throws DestinationAccessException, DestinationNotFoundException {
        return this.getConfigurationAsJsonInternal(servicePath, behalf, true);
    }

    @Nonnull
    String getConfigurationAsJson(@Nonnull String servicePath, @Nonnull OnBehalfOf behalf) throws DestinationAccessException, DestinationNotFoundException {
        return this.getConfigurationAsJsonInternal(servicePath, behalf, false);
    }

    @Nonnull
    private String getConfigurationAsJsonInternal(@Nonnull String servicePath, @Nonnull OnBehalfOf behalf, boolean xUserToken) throws DestinationAccessException, DestinationNotFoundException {
        HttpDestination serviceDestination = Objects.requireNonNull(this.serviceDestinationLoader.apply(behalf), () -> "Destination for Destination Service on behalf of " + behalf + " not found.");
        log.debug("Querying BTP destination service on service path {} to fetch all destinations at service instance level and using destination: {}", (Object)servicePath, (Object)serviceDestination);
        return this.requestDestinationConfigurationAsJson(servicePath, (Destination)serviceDestination, xUserToken);
    }

    @Nonnull
    static ServiceBinding getDestinationServiceBinding() {
        List matchingBindings = DefaultServiceBindingAccessor.getInstance().getServiceBindings().stream().filter(binding -> ServiceIdentifier.DESTINATION.equals(binding.getServiceIdentifier().orElse(null))).collect(Collectors.toList());
        if (matchingBindings.isEmpty()) {
            throw new NoServiceBindingException("Please make sure you have the Destination Service bound to your application.");
        }
        if (matchingBindings.size() > 1) {
            throw new MultipleServiceBindingsException("Having multiple Destination Service bindings is not supported.");
        }
        return (ServiceBinding)matchingBindings.get(0);
    }

    @Nonnull
    @Generated
    Function<OnBehalfOf, HttpDestination> getServiceDestinationLoader() {
        return this.serviceDestinationLoader;
    }
}

