/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.AuthTokenHeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultRfcDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationHeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationKeyStoreExtractor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationService;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceV1Response;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DestinationServiceFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DestinationServiceFactory.class);
    private static final String PROVIDER_TENANT_ID = "";

    DestinationServiceFactory() {
    }

    @Nonnull
    static Destination fromDestinationServiceV1Response(@Nonnull DestinationServiceV1Response response) throws DestinationAccessException {
        return DestinationServiceFactory.fromDestinationServiceV1Response(response, OnBehalfOf.NAMED_USER_CURRENT_TENANT);
    }

    @Nonnull
    static Destination fromDestinationServiceV1Response(@Nonnull DestinationServiceV1Response response, @Nonnull OnBehalfOf onBehalfOf) throws DestinationAccessException {
        Map<String, String> destConf = response.getDestinationConfiguration();
        DefaultDestination.Builder baseBuilder = DefaultDestination.fromMap(destConf);
        baseBuilder.property(DestinationProperty.PROPERTIES_FOR_CHANGE_DETECTION, destConf.keySet());
        baseBuilder.property(DestinationProperty.TENANT_ID, (Object)DestinationServiceFactory.getDestinationTenantId(onBehalfOf));
        if (baseBuilder.get(DestinationProperty.TYPE).contains((Object)DestinationType.RFC)) {
            return DestinationServiceFactory.handleRfcDestination((DestinationProperties)baseBuilder.build());
        }
        if (baseBuilder.get(DestinationProperty.TYPE).contains((Object)DestinationType.HTTP)) {
            return DestinationServiceFactory.handleHttpDestination(baseBuilder.build(), response.getCertificates(), response.getAuthTokens());
        }
        return baseBuilder.build();
    }

    private static String getDestinationTenantId(@Nonnull OnBehalfOf onBehalfOf) {
        switch (onBehalfOf) {
            case TECHNICAL_USER_PROVIDER: {
                return PROVIDER_TENANT_ID;
            }
            case NAMED_USER_CURRENT_TENANT: 
            case TECHNICAL_USER_CURRENT_TENANT: {
                Try tenantId = TenantAccessor.tryGetCurrentTenant().map(Tenant::getTenantId);
                return (String)tenantId.getOrElse((Object)PROVIDER_TENANT_ID);
            }
        }
        throw new IllegalStateException("Unknown OnBehalfOf: " + onBehalfOf);
    }

    private static Destination handleRfcDestination(DestinationProperties baseProperties) {
        return DefaultRfcDestination.fromProperties((DestinationProperties)baseProperties);
    }

    private static Destination handleHttpDestination(@Nonnull DefaultDestination baseProperties, @Nullable List<DestinationServiceV1Response.DestinationCertificate> certificates, @Nullable List<DestinationServiceV1Response.DestinationAuthToken> authTokens) {
        DefaultHttpDestination.Builder builder = DefaultHttpDestination.fromProperties((DestinationProperties)baseProperties);
        if (certificates != null && !certificates.isEmpty()) {
            certificates.forEach(DestinationServiceFactory::determineAndSetCertificateExpirationTime);
            builder.property(DestinationProperty.CERTIFICATES, certificates);
            DestinationKeyStoreExtractor keyStoreExtractor = new DestinationKeyStoreExtractor(arg_0 -> ((DefaultHttpDestination.Builder)builder).get(arg_0));
            keyStoreExtractor.getKeyStore().peek(arg_0 -> ((DefaultHttpDestination.Builder)builder).keyStore(arg_0));
            keyStoreExtractor.getTrustStore().peek(arg_0 -> ((DefaultHttpDestination.Builder)builder).trustStore(arg_0));
        }
        if (authTokens != null && !authTokens.isEmpty()) {
            AuthenticationType authType = (AuthenticationType)builder.get(DestinationProperty.AUTH_TYPE).getOrElse((Object)AuthenticationType.NO_AUTHENTICATION);
            authTokens.forEach(t -> DestinationServiceFactory.throwOnTokenError((String)builder.get(DestinationProperty.NAME).getOrNull(), t));
            authTokens.forEach(t -> DestinationServiceFactory.setExpirationTimestamp(t, authType));
            builder.property(DestinationProperty.AUTH_TOKENS, authTokens);
            builder.headerProviders(new DestinationHeaderProvider[]{new AuthTokenHeaderProvider()});
        }
        return builder.build();
    }

    private static void throwOnTokenError(String destinationName, DestinationServiceV1Response.DestinationAuthToken destinationAuthToken) {
        if (destinationAuthToken.getError() != null) {
            String msg = "Failed to read authentication token of destination '%s'. The destination service responded with an error: '%s'.\nIn case only the properties of a destination should be accessed, without performing authorization flows, please use the 'getDestinationProperties'  method on 'DestinationService' instead.";
            throw new DestinationAccessException("Failed to read authentication token of destination '%s'. The destination service responded with an error: '%s'.\nIn case only the properties of a destination should be accessed, without performing authorization flows, please use the 'getDestinationProperties'  method on 'DestinationService' instead.".formatted(destinationName, destinationAuthToken.getError()));
        }
    }

    private static void setExpirationTimestamp(@Nonnull DestinationServiceV1Response.DestinationAuthToken authToken, @Nonnull AuthenticationType authType) {
        Option maybeExpiresIn = Option.of((Object)authToken.getExpiresIn()).filter(val -> !StringUtils.isBlank((CharSequence)val)).map(Long::valueOf);
        if (maybeExpiresIn.isEmpty() && authType != AuthenticationType.BASIC_AUTHENTICATION) {
            maybeExpiresIn = DestinationService.Cache.getExpirationDuration().map(Duration::getSeconds);
        }
        maybeExpiresIn.map(val -> LocalDateTime.now().plusSeconds((long)val)).peek(authToken::setExpiryTimestamp);
    }

    private static void determineAndSetCertificateExpirationTime(@Nonnull DestinationServiceV1Response.DestinationCertificate cert) {
        if (!DestinationService.Cache.isEnabled() || !DestinationService.Cache.isChangeDetectionEnabled()) {
            return;
        }
        Duration duration = (Duration)DestinationService.Cache.getExpirationDuration().getOrElse((Object)DestinationService.Cache.DEFAULT_EXPIRATION_DURATION);
        cert.setExpiryTimestamp(LocalDateTime.now().plus(duration));
    }
}

