/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.base.Functions;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceOptionsAugmenter;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceTokenExchangeStrategy;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationServiceV1Response;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationUtility;
import com.sap.cloud.sdk.cloudplatform.connectivity.GetOrComputeAllDestinationsCommand;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.security.principal.exception.PrincipalAccessException;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetOrComputeSingleDestinationCommand {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetOrComputeSingleDestinationCommand.class);
    private static final long EXPIRATION_BUFFER_TIME = 10L;
    @Nonnull
    private final String destinationName;
    @Nonnull
    private final CacheKey cacheKey;
    @Nullable
    private final CacheKey additionalKeyWithTenantAndPrincipal;
    @Nonnull
    private final ReentrantLock isolationLock;
    @Nonnull
    private final Cache<CacheKey, Destination> destinationCache;
    @Nonnull
    private final Supplier<Destination> destinationSupplier;
    @Nonnull
    private final DestinationServiceTokenExchangeStrategy exchangeStrategy;
    @Nullable
    private final GetOrComputeAllDestinationsCommand getAllCommand;

    static Try<GetOrComputeSingleDestinationCommand> prepareCommand(@Nonnull String destinationName, @Nonnull DestinationOptions destinationOptions, @Nonnull Cache<CacheKey, Destination> destinationCache, @Nonnull Cache<CacheKey, ReentrantLock> isolationLocks, @Nonnull BiFunction<String, DestinationOptions, Destination> destinationRetriever, @Nullable GetOrComputeAllDestinationsCommand getAllCommand) {
        CacheKey cacheKey;
        Supplier<Destination> destinationSupplier = () -> (Destination)destinationRetriever.apply(destinationName, destinationOptions);
        DestinationServiceTokenExchangeStrategy exchangeStrategy = (DestinationServiceTokenExchangeStrategy)((Object)DestinationServiceOptionsAugmenter.getTokenExchangeStrategy(destinationOptions).getOrElse((Object)DestinationServiceTokenExchangeStrategy.LOOKUP_THEN_EXCHANGE));
        CacheKey additionalKeyWithTenantAndPrincipal = null;
        if (exchangeStrategy == DestinationServiceTokenExchangeStrategy.EXCHANGE_ONLY) {
            try {
                cacheKey = CacheKey.ofTenantAndPrincipalIsolation();
            }
            catch (PrincipalAccessException | TenantAccessException e) {
                return Try.failure((Throwable)new DestinationAccessException("Failed to determine tenant/principal information required for destination token exchange strategy " + DestinationServiceTokenExchangeStrategy.EXCHANGE_ONLY, e));
            }
        } else {
            cacheKey = CacheKey.ofTenantOptionalIsolation();
            if (exchangeStrategy == DestinationServiceTokenExchangeStrategy.LOOKUP_THEN_EXCHANGE || exchangeStrategy == DestinationServiceTokenExchangeStrategy.FORWARD_USER_TOKEN) {
                additionalKeyWithTenantAndPrincipal = CacheKey.ofTenantAndPrincipalOptionalIsolation().append(new Object[]{destinationName, destinationOptions});
            }
        }
        cacheKey.append(new Object[]{destinationName, destinationOptions});
        ReentrantLock isolationLock = Objects.requireNonNull((ReentrantLock)isolationLocks.get((Object)cacheKey, any -> new ReentrantLock()));
        return Try.success((Object)new GetOrComputeSingleDestinationCommand(destinationName, cacheKey, additionalKeyWithTenantAndPrincipal, isolationLock, destinationCache, destinationSupplier, exchangeStrategy, getAllCommand));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Try<Destination> execute() {
        Destination result = this.getCachedDestination();
        if (result != null) {
            return Try.success((Object)result);
        }
        try {
            this.isolationLock.lock();
            result = this.getCachedDestination();
            if (result != null) {
                Try try_ = Try.success((Object)result);
                return try_;
            }
            Try maybeResult = Try.ofSupplier(this.destinationSupplier);
            if (maybeResult.isFailure()) {
                Try try_ = maybeResult;
                return try_;
            }
            result = (Destination)maybeResult.get();
            switch (this.exchangeStrategy) {
                case LOOKUP_ONLY: 
                case EXCHANGE_ONLY: {
                    this.destinationCache.put((Object)this.cacheKey, (Object)result);
                    this.logErroneousCombinations((DestinationProperties)result, this.destinationName, this.exchangeStrategy);
                    break;
                }
                case LOOKUP_THEN_EXCHANGE: 
                case FORWARD_USER_TOKEN: {
                    if (!DestinationUtility.requiresUserTokenExchange((DestinationProperties)result)) {
                        this.destinationCache.put((Object)this.cacheKey, (Object)result);
                        break;
                    }
                    if (this.additionalKeyWithTenantAndPrincipal.getPrincipalId().isEmpty()) {
                        String message = "No principal is available in the current ThreadContext, but a principal is required for fetching the destination %s. This typically means that the current context is malformed, containing inconsistent information about the authentication token, tenant and principal.";
                        Try try_ = Try.failure((Throwable)new DestinationAccessException("No principal is available in the current ThreadContext, but a principal is required for fetching the destination %s. This typically means that the current context is malformed, containing inconsistent information about the authentication token, tenant and principal.".formatted(this.destinationName)));
                        return try_;
                    }
                    this.destinationCache.put((Object)this.additionalKeyWithTenantAndPrincipal, (Object)result);
                }
            }
            Try try_ = Try.success((Object)result);
            return try_;
        }
        finally {
            this.isolationLock.unlock();
        }
    }

    private void logErroneousCombinations(@Nonnull DestinationProperties result, @Nonnull String destinationName, @Nonnull DestinationServiceTokenExchangeStrategy exchangeStrategy) {
        if (DestinationUtility.requiresUserTokenExchange((DestinationProperties)result) && exchangeStrategy == DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY) {
            log.debug("The destination {} was retrieved with strategy {}, but it requires user token exchange. Hence, the destination cannot be used to connect to the target system successfully, please refer to the documentation of {} to find the recommended strategy. Caching the destination for all users of the current tenant since it was obtained without user token exchange. ", new Object[]{destinationName, DestinationServiceTokenExchangeStrategy.LOOKUP_ONLY, DestinationServiceTokenExchangeStrategy.class.getSimpleName()});
        }
        if (!DestinationUtility.requiresUserTokenExchange((DestinationProperties)result) && exchangeStrategy == DestinationServiceTokenExchangeStrategy.EXCHANGE_ONLY) {
            log.warn("The destination {} was retrieved with strategy {}, but doesn't require user token exchange. This is not recommended, please refer to the documentation of {}. Caching the destination for the current user of the current tenant since it was obtained with a user token.", new Object[]{destinationName, DestinationServiceTokenExchangeStrategy.EXCHANGE_ONLY, DestinationServiceTokenExchangeStrategy.class.getSimpleName()});
        }
    }

    @Nullable
    private Destination getCachedDestination() {
        Destination maybeDestination = (Destination)this.destinationCache.getIfPresent((Object)this.cacheKey);
        if (maybeDestination == null && this.additionalKeyWithTenantAndPrincipal != null) {
            maybeDestination = (Destination)this.destinationCache.getIfPresent((Object)this.additionalKeyWithTenantAndPrincipal);
        }
        if (maybeDestination == null) {
            return null;
        }
        if (GetOrComputeSingleDestinationCommand.authTokenIsExpired(maybeDestination) || GetOrComputeSingleDestinationCommand.certificateIsExpired(maybeDestination)) {
            return null;
        }
        if (this.getAllCommand == null) {
            return maybeDestination;
        }
        Try<List<DestinationProperties>> allDestinations = this.getAllCommand.execute();
        if (allDestinations.isFailure()) {
            String message = "Failed to resolve all destinations of the current tenant from the destination service. Cannot perform change detection. {} will therefore be assumed to remain unchanged.";
            log.warn("Failed to resolve all destinations of the current tenant from the destination service. Cannot perform change detection. {} will therefore be assumed to remain unchanged.", (Object)this.destinationName);
            log.debug("Failed to resolve all destinations of the current tenant from the destination service. Cannot perform change detection. {} will therefore be assumed to remain unchanged.", (Object)this.destinationName, (Object)allDestinations.getCause());
            return maybeDestination;
        }
        if (GetOrComputeSingleDestinationCommand.destinationIsChanged((List)allDestinations.get(), maybeDestination)) {
            return null;
        }
        return maybeDestination;
    }

    private static boolean certificateIsExpired(Destination destination) {
        return destination.get(DestinationProperty.CERTIFICATES).toStream().flatMap((Function)Functions.identity()).map(t -> ((DestinationServiceV1Response.DestinationCertificate)t).getExpiryTimestamp()).filter(Objects::nonNull).min().filter(t -> LocalDateTime.now().plusSeconds(10L).isAfter((ChronoLocalDateTime<?>)t)).isDefined();
    }

    private static boolean authTokenIsExpired(@Nonnull Destination destination) {
        return destination.get(DestinationProperty.AUTH_TOKENS).toStream().flatMap((Function)Functions.identity()).map(t -> ((DestinationServiceV1Response.DestinationAuthToken)t).getExpiryTimestamp()).filter(Objects::nonNull).min().filter(t -> LocalDateTime.now().plusSeconds(10L).isAfter((ChronoLocalDateTime<?>)t)).isDefined();
    }

    private static boolean destinationIsChanged(@Nonnull List<DestinationProperties> allDestinations, @Nonnull Destination cachedDestination) {
        String destinationName = (String)cachedDestination.get(DestinationProperty.NAME).get();
        DestinationProperties matchingDestination = allDestinations.stream().filter(destination -> destination.get(DestinationProperty.NAME).contains((Object)destinationName)).findFirst().orElse(null);
        if (matchingDestination == null) {
            return true;
        }
        return !GetOrComputeSingleDestinationCommand.destinationIsEqualTo(matchingDestination, cachedDestination);
    }

    static boolean destinationIsEqualTo(@Nonnull DestinationProperties destinationFromGetAllEndPoint, @Nonnull Destination individuallyRetrievedDestination) {
        Option actualProperty;
        Option expectedProperty;
        for (String propertyName : destinationFromGetAllEndPoint.getPropertyNames()) {
            expectedProperty = destinationFromGetAllEndPoint.get(propertyName);
            if (expectedProperty.equals((Object)(actualProperty = individuallyRetrievedDestination.get(propertyName)))) continue;
            log.debug("Detected change in destination property {}", (Object)propertyName);
            return false;
        }
        for (String propertyName : (Collection)individuallyRetrievedDestination.get(DestinationProperty.PROPERTIES_FOR_CHANGE_DETECTION).get()) {
            expectedProperty = individuallyRetrievedDestination.get(propertyName);
            if (expectedProperty.equals((Object)(actualProperty = destinationFromGetAllEndPoint.get(propertyName)))) continue;
            log.debug("Detected change in destination property {}", (Object)propertyName);
            return false;
        }
        return true;
    }

    @Generated
    private GetOrComputeSingleDestinationCommand(@Nonnull String destinationName, @Nonnull CacheKey cacheKey, @Nullable CacheKey additionalKeyWithTenantAndPrincipal, @Nonnull ReentrantLock isolationLock, @Nonnull Cache<CacheKey, Destination> destinationCache, @Nonnull Supplier<Destination> destinationSupplier, @Nonnull DestinationServiceTokenExchangeStrategy exchangeStrategy, @Nullable GetOrComputeAllDestinationsCommand getAllCommand) {
        if (destinationName == null) {
            throw new NullPointerException("destinationName is marked non-null but is null");
        }
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        if (isolationLock == null) {
            throw new NullPointerException("isolationLock is marked non-null but is null");
        }
        if (destinationCache == null) {
            throw new NullPointerException("destinationCache is marked non-null but is null");
        }
        if (destinationSupplier == null) {
            throw new NullPointerException("destinationSupplier is marked non-null but is null");
        }
        if (exchangeStrategy == null) {
            throw new NullPointerException("exchangeStrategy is marked non-null but is null");
        }
        this.destinationName = destinationName;
        this.cacheKey = cacheKey;
        this.additionalKeyWithTenantAndPrincipal = additionalKeyWithTenantAndPrincipal;
        this.isolationLock = isolationLock;
        this.destinationCache = destinationCache;
        this.destinationSupplier = destinationSupplier;
        this.exchangeStrategy = exchangeStrategy;
        this.getAllCommand = getAllCommand;
    }

    @Nonnull
    @Generated
    CacheKey getCacheKey() {
        return this.cacheKey;
    }

    @Nullable
    @Generated
    CacheKey getAdditionalKeyWithTenantAndPrincipal() {
        return this.additionalKeyWithTenantAndPrincipal;
    }

    @Nonnull
    @Generated
    DestinationServiceTokenExchangeStrategy getExchangeStrategy() {
        return this.exchangeStrategy;
    }
}

