/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.SecurityConfigurationStrategy;
import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.mtls.SSLContextFactory;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.security.KeyStore;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CertificateBasedHttpClientFactory
implements HttpClientFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateBasedHttpClientFactory.class);

    @Nonnull
    public CloseableHttpClient createClient(@Nullable ClientIdentity clientIdentity) {
        log.info("Using CertificateBasedHttpClientFactory service");
        if (clientIdentity == null || !clientIdentity.isCertificateBased()) {
            log.debug("Setting up default http client");
            return HttpClients.createDefault();
        }
        log.debug("Trying to setup a HTTPS client with certificate: {} and private key: {}", (Object)clientIdentity.getCertificate(), (Object)clientIdentity.getKey());
        KeyStore keyStore = CertificateBasedHttpClientFactory.loadKeyStore(clientIdentity);
        DefaultHttpDestination httpDestinationProperties = DefaultHttpDestination.builder((String)"").securityConfiguration(SecurityConfigurationStrategy.FROM_DESTINATION).authenticationType(AuthenticationType.NO_AUTHENTICATION).keyStore(keyStore).build();
        HttpClient httpClient = HttpClientAccessor.getHttpClientFactory().createHttpClient((HttpDestinationProperties)httpDestinationProperties);
        if (httpClient instanceof CloseableHttpClient) {
            return (CloseableHttpClient)httpClient;
        }
        throw new IllegalStateException(String.format("Unable to instantiate a new HTTPS client using certificate based authentication. The created client is an instance of \"%s\" but we expected it to be a \"%s\".", httpClient.getClass(), CloseableHttpClient.class));
    }

    @Nonnull
    private static KeyStore loadKeyStore(@Nonnull ClientIdentity clientIdentity) {
        return (KeyStore)Try.of((CheckedFunction0 & Serializable)() -> SSLContextFactory.getInstance().createKeyStore(clientIdentity)).getOrElseThrow(e -> new IllegalArgumentException("Unable to create a key store from the provided client identity.", (Throwable)e));
    }
}

