/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.annotations.Beta;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.TypedMapView;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.security.config.ClientCertificate;
import com.sap.cloud.security.config.ClientCredentials;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.config.CredentialType;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class DefaultOAuth2PropertySupplier
implements OAuth2PropertySupplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultOAuth2PropertySupplier.class);
    @Nonnull
    public static final List<String> DEFAULT_UAA_CREDENTIAL_PATH = Collections.singletonList("uaa");
    @Nonnull
    protected final ServiceBindingDestinationOptions options;
    @Nonnull
    protected final TypedMapView credentials;
    @Nonnull
    private final List<String> oauthPropertyPath;

    public DefaultOAuth2PropertySupplier(@Nonnull ServiceBindingDestinationOptions options) {
        this(options, DEFAULT_UAA_CREDENTIAL_PATH);
    }

    public DefaultOAuth2PropertySupplier(@Nonnull ServiceBindingDestinationOptions options, @Nonnull List<String> oauthPropertyPath) {
        this.options = options;
        this.oauthPropertyPath = oauthPropertyPath;
        this.credentials = TypedMapView.ofCredentials((ServiceBinding)options.getServiceBinding());
    }

    @Override
    public boolean isOAuth2Binding() {
        return this.getOAuthCredential(String.class, "clientid").isDefined();
    }

    @Override
    @Nonnull
    public URI getServiceUri() {
        return this.getCredentialOrThrow(URI.class, "url");
    }

    @Override
    @Nonnull
    public URI getTokenUri() {
        String tokenUrlProperty = this.getCredentialType() == CredentialType.X509 ? "certurl" : "url";
        return this.getOAuthCredentialOrThrow(URI.class, tokenUrlProperty);
    }

    @Override
    @Nonnull
    public ClientIdentity getClientIdentity() {
        return this.getCredentialType() == CredentialType.X509 ? this.getCertificateIdentity() : this.getSecretIdentity();
    }

    @Nonnull
    protected List<String> getOAuthPropertyPath() {
        return new ArrayList<String>(this.oauthPropertyPath);
    }

    @Nonnull
    ClientIdentity getCertificateIdentity() {
        String clientid = this.getOAuthCredentialOrThrow(String.class, "clientid");
        String cert = this.getOAuthCredentialOrThrow(String.class, "certificate");
        String key = this.getOAuthCredentialOrThrow(String.class, "key");
        return new ClientCertificate(cert, key, clientid);
    }

    @Nonnull
    ClientIdentity getSecretIdentity() {
        String clientid = this.getOAuthCredentialOrThrow(String.class, "clientid");
        String secret = this.getOAuthCredentialOrThrow(String.class, "clientsecret");
        return new ClientCredentials(clientid, secret);
    }

    @Nonnull
    CredentialType getCredentialType() {
        return (CredentialType)this.getOAuthCredential(CredentialType.class, "credential-type").getOrElse((Object)CredentialType.BINDING_SECRET);
    }

    @Nonnull
    protected <T> T getCredentialOrThrow(@Nonnull Class<T> resultType, String ... path) throws DestinationAccessException {
        return (T)this.getCredential(resultType, path).getOrElseThrow(() -> new DestinationAccessException("Failed to resolve property " + Arrays.toString(path) + " from service binding."));
    }

    @Nonnull
    protected <T> Option<T> getCredential(@Nonnull Class<T> resultType, String ... path) {
        return this.getCredentialInternal(resultType, this.credentials, Arrays.asList(path));
    }

    @Nonnull
    protected <T> T getOAuthCredentialOrThrow(@Nonnull Class<T> resultType, String ... path) throws DestinationAccessException {
        return (T)this.getOAuthCredential(resultType, path).getOrElseThrow(() -> new DestinationAccessException("Failed to resolve property " + this.getOAuthPropertyPath() + Arrays.toString(path) + " from service binding."));
    }

    @Nonnull
    protected <T> Option<T> getOAuthCredential(@Nonnull Class<T> resultType, String ... path) {
        List<String> fullPath = this.getOAuthPropertyPath();
        fullPath.addAll(Arrays.asList(path));
        return this.getCredentialInternal(resultType, this.credentials, fullPath);
    }

    @Nonnull
    private <T> Option<T> getCredentialInternal(@Nonnull Class<T> resultType, @Nonnull TypedMapView currentNode, @Nonnull List<String> names) {
        if (names.isEmpty()) {
            log.warn("Passed an empty property path to load from the service binding. This should never happen.");
            return Option.none();
        }
        if (names.size() == 1) {
            return Try.of((CheckedFunction0 & Serializable)() -> currentNode.get((String)names.get(0))).map(o -> DefaultOAuth2PropertySupplier.convert(o, resultType)).toOption();
        }
        return Try.of((CheckedFunction0 & Serializable)() -> currentNode.getMapView((String)names.get(0))).toOption().flatMap(it -> this.getCredentialInternal(resultType, (TypedMapView)it, names.subList(1, names.size())));
    }

    @Nullable
    static <T> T convert(@Nullable Object value, @Nonnull Class<T> cls) throws DestinationAccessException {
        if (value == null) {
            return null;
        }
        if (cls.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        if (cls == String.class) {
            return (T)value.toString();
        }
        if (cls == URI.class) {
            try {
                return (T)new URI(value.toString());
            }
            catch (ClassCastException | URISyntaxException e) {
                throw new DestinationAccessException("Unable to convert '" + value + "' into an URI.", (Throwable)e);
            }
        }
        if (cls == Integer.class) {
            try {
                return (T)Integer.valueOf((String)value);
            }
            catch (ClassCastException | NumberFormatException e) {
                throw new DestinationAccessException("Unable to convert '" + value + "' into an Integer.", (Throwable)e);
            }
        }
        if (cls == CredentialType.class) {
            try {
                CredentialType result = CredentialType.from((String)((String)value));
                if (result == null) {
                    throw new IllegalArgumentException();
                }
                return (T)result;
            }
            catch (ClassCastException | IllegalArgumentException e) {
                throw new DestinationAccessException("Unable to convert '" + value + "' into a CredentialType.", (Throwable)e);
            }
        }
        throw new DestinationAccessException("Property value " + value + " could not be parsed into unknown type " + cls.getSimpleName());
    }
}

