/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationHeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2ServiceImpl;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuthHeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import com.sap.cloud.security.config.ClientIdentity;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class OAuth2DestinationBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2DestinationBuilder.class);
    private static final Duration TOKEN_RETRIEVAL_TIMEOUT = Duration.ofSeconds(10L);

    @Nonnull
    public static BuilderWithTargetUrl forTargetUrl(@Nonnull String targetUrl) {
        return tokenUrl -> (client, behalf) -> properties -> () -> {
            OAuth2ServiceImpl oauth2service = OAuth2ServiceImpl.fromCredentials(tokenUrl, client);
            DefaultHttpDestination.Builder destinationBuilder = DefaultHttpDestination.builder((String)targetUrl);
            String destinationName = UUID.randomUUID().toString();
            destinationBuilder.property(DestinationProperty.NAME, (Object)destinationName);
            properties.forEach((arg_0, arg_1) -> ((DefaultHttpDestination.Builder)destinationBuilder).property(arg_0, arg_1));
            destinationBuilder.property("oauth-resilience-config", (Object)OAuth2DestinationBuilder.createTokenRetrievalResilienceConfiguration(destinationName));
            return destinationBuilder.headerProviders(new DestinationHeaderProvider[]{new OAuthHeaderProvider(oauth2service, behalf, "Authorization")}).build();
        };
    }

    @Nonnull
    private static ResilienceConfiguration createTokenRetrievalResilienceConfiguration(@Nonnull String destinationName) {
        return ResilienceConfiguration.of((String)destinationName).isolationMode(ResilienceIsolationMode.TENANT_OPTIONAL).timeLimiterConfiguration(ResilienceConfiguration.TimeLimiterConfiguration.of((Duration)TOKEN_RETRIEVAL_TIMEOUT));
    }

    @FunctionalInterface
    @Beta
    public static interface BuilderWithTargetUrl {
        @Nonnull
        public BuilderWithTokenEndpoint withTokenEndpoint(@Nonnull String var1);
    }

    @FunctionalInterface
    @Beta
    public static interface BuilderWithTokenEndpoint {
        @Nonnull
        public BuilderWithClient withClient(@Nonnull ClientIdentity var1, @Nonnull OnBehalfOf var2);
    }

    @FunctionalInterface
    @Beta
    public static interface BuilderWithClient {
        @Nonnull
        public BuilderWithProperties withProperties(@Nonnull Map<String, String> var1);

        @Nonnull
        default public HttpDestination build() {
            return this.withProperties(Collections.emptyMap()).build();
        }
    }

    @FunctionalInterface
    @Beta
    public static interface BuilderWithProperties {
        @Nonnull
        public HttpDestination build();
    }
}

