/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationOAuthTokenException;
import com.sap.cloud.sdk.cloudplatform.exception.CloudPlatformException;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorator;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.ClientCredentialsTokenFlow;
import com.sap.cloud.security.xsuaa.tokenflows.JwtBearerTokenFlow;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import com.sap.cloud.security.xsuaa.util.UriUtil;
import io.vavr.control.Try;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OAuth2ServiceImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2ServiceImpl.class);
    private final XsuaaTokenFlows tokenFlows;

    OAuth2ServiceImpl(XsuaaTokenFlows tokenFlows) {
        this.tokenFlows = tokenFlows;
    }

    static OAuth2ServiceImpl fromCredentials(String uri, ClientIdentity identity) {
        DefaultOAuth2TokenService tokenService = new DefaultOAuth2TokenService(HttpClientFactory.create((ClientIdentity)identity));
        Endpoints endpoints = Endpoints.fromBaseUri(URI.create(uri));
        XsuaaTokenFlows tokenFlow = new XsuaaTokenFlows((OAuth2TokenService)tokenService, (OAuth2ServiceEndpointsProvider)endpoints, identity);
        return new OAuth2ServiceImpl(tokenFlow);
    }

    @Nonnull
    String retrieveAccessToken(@Nonnull OnBehalfOf behalf, @Nonnull ResilienceConfiguration resilienceConfig) {
        log.debug("Retrieving Access Token from XSUAA on behalf of {}.", (Object)behalf);
        OAuth2TokenResponse tokenResponse = (OAuth2TokenResponse)ResilienceDecorator.executeSupplier(() -> {
            switch (behalf) {
                case TECHNICAL_USER_PROVIDER: 
                case TECHNICAL_USER_CURRENT_TENANT: {
                    return this.executeClientCredentialsFlow(behalf);
                }
                case NAMED_USER_CURRENT_TENANT: {
                    return this.executeUserExchangeFlow();
                }
            }
            throw new IllegalStateException("Unknown behalf " + behalf);
        }, (ResilienceConfiguration)resilienceConfig);
        if (tokenResponse == null) {
            String message = "OAuth2 token request failed";
            log.debug("OAuth2 token request failed");
            throw new DestinationOAuthTokenException(null, "OAuth2 token request failed");
        }
        String accessToken = tokenResponse.getAccessToken();
        if (accessToken == null) {
            String message = "OAuth2 token request succeeded but the response did not contain an access token";
            log.debug("OAuth2 token request succeeded but the response did not contain an access token: {}", (Object)tokenResponse);
            throw new DestinationOAuthTokenException(null, "OAuth2 token request succeeded but the response did not contain an access token");
        }
        return accessToken;
    }

    @Nullable
    private OAuth2TokenResponse executeClientCredentialsFlow(OnBehalfOf behalf) {
        String zoneId;
        ClientCredentialsTokenFlow flow = this.tokenFlows.clientCredentialsTokenFlow();
        switch (behalf) {
            case TECHNICAL_USER_PROVIDER: {
                log.debug("Using subdomain of provider tenant.");
                zoneId = null;
                break;
            }
            case TECHNICAL_USER_CURRENT_TENANT: {
                zoneId = (String)TenantAccessor.tryGetCurrentTenant().map(Tenant::getTenantId).getOrNull();
                if (zoneId != null) break;
                log.debug("No current tenant/zone available.");
                log.debug("Falling back to provider tenant/zone using the provider UAA subdomain.");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown behalf " + behalf);
            }
        }
        if (zoneId != null) {
            flow.zoneId(zoneId);
        }
        return (OAuth2TokenResponse)Try.of(() -> ((ClientCredentialsTokenFlow)flow).execute()).getOrElseThrow(e -> new TokenRequestFailedException("Failed to resolve access token.", e));
    }

    @Nullable
    private OAuth2TokenResponse executeUserExchangeFlow() {
        JwtBearerTokenFlow flow = this.tokenFlows.jwtBearerTokenFlow();
        Try maybeToken = AuthTokenAccessor.tryGetCurrentToken().map(AuthToken::getJwt);
        Try maybeTenant = TenantAccessor.tryGetCurrentTenant().map(Tenant::getTenantId);
        if (maybeToken.isFailure()) {
            throw new CloudPlatformException("Failed to get the current user token.", maybeToken.getCause());
        }
        Token token = (Token)maybeToken.map(DecodedJWT::getToken).map(Token::create).get();
        if (maybeTenant.isFailure()) {
            log.warn("Unexpected state: An Auth Token was found in the current context, but the current tenant is undefined.This is unexpected, please ensure the TenantAccessor and AuthTokenAccessor return consistent results.Proceeding with tenant {} defined in the current token.", (Object)token.getAppTid());
            log.debug("The following token is used for the JwtBearerTokenFlow: {}", (Object)token);
        } else if (!((String)maybeTenant.get()).equals(token.getAppTid())) {
            throw new CloudPlatformException("Unexpected state: Auth Token and tenant of the current context have different tenant IDs.AuthTokenAccessor returned a token containing tenant ID " + token.getAppTid() + " while TenantAccessor returned " + (String)maybeTenant.get() + ". This is unexpected, please ensure the TenantAccessor and AuthTokenAccessor return consistent results.");
        }
        flow.token(token);
        return (OAuth2TokenResponse)Try.of(() -> ((JwtBearerTokenFlow)flow).execute()).getOrElseThrow(e -> new TokenRequestFailedException("Failed to resolve access token.", e));
    }

    private static class Endpoints
    implements OAuth2ServiceEndpointsProvider {
        private static final String TOKEN_PATH = "/oauth/token";
        private static final String AUTHORIZE_PATH = "/oauth/authorize";
        private static final String KEYSET_PATH = "/token_keys";
        @Nonnull
        private final URI tokenEndpoint;
        @Nullable
        private final URI authorizeEndpoint;
        @Nullable
        private final URI jwksUri;

        @Nonnull
        static Endpoints fromBaseUri(URI baseUri) {
            URI tokenEndpoint = UriUtil.expandPath((URI)baseUri, (String)TOKEN_PATH);
            URI authorizeEndpoint = UriUtil.expandPath((URI)baseUri, (String)AUTHORIZE_PATH);
            URI jwksUri = UriUtil.expandPath((URI)baseUri, (String)KEYSET_PATH);
            return new Endpoints(tokenEndpoint, authorizeEndpoint, jwksUri);
        }

        @Generated
        public Endpoints(@Nonnull URI tokenEndpoint, @Nullable URI authorizeEndpoint, @Nullable URI jwksUri) {
            if (tokenEndpoint == null) {
                throw new NullPointerException("tokenEndpoint is marked non-null but is null");
            }
            this.tokenEndpoint = tokenEndpoint;
            this.authorizeEndpoint = authorizeEndpoint;
            this.jwksUri = jwksUri;
        }

        @Nonnull
        @Generated
        public URI getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        @Nullable
        @Generated
        public URI getAuthorizeEndpoint() {
            return this.authorizeEndpoint;
        }

        @Nullable
        @Generated
        public URI getJwksUri() {
            return this.jwksUri;
        }
    }
}

