/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationHeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationRequestContext;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2ServiceImpl;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import io.vavr.control.Option;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;

class OAuthHeaderProvider
implements DestinationHeaderProvider {
    static final String PROPERTY_OAUTH2_RESILIENCE_CONFIG = "oauth-resilience-config";
    @Nonnull
    private final OAuth2ServiceImpl oauth2service;
    @Nonnull
    private final OnBehalfOf behalf;
    @Nonnull
    private final String authHeaderName;

    @Nonnull
    public List<Header> getHeaders(@Nonnull DestinationRequestContext requestContext) {
        DestinationProperties destination = requestContext.getDestination();
        Option resilienceConfig = destination.get(PROPERTY_OAUTH2_RESILIENCE_CONFIG, ResilienceConfiguration.class);
        String accessToken = this.oauth2service.retrieveAccessToken(this.behalf, (ResilienceConfiguration)resilienceConfig.getOrElseThrow(IllegalStateException::new));
        return Collections.singletonList(new Header(this.authHeaderName, "Bearer " + accessToken));
    }

    @Generated
    public OAuthHeaderProvider(@Nonnull OAuth2ServiceImpl oauth2service, @Nonnull OnBehalfOf behalf, @Nonnull String authHeaderName) {
        if (oauth2service == null) {
            throw new NullPointerException("oauth2service is marked non-null but is null");
        }
        if (behalf == null) {
            throw new NullPointerException("behalf is marked non-null but is null");
        }
        if (authHeaderName == null) {
            throw new NullPointerException("authHeaderName is marked non-null but is null");
        }
        this.oauth2service = oauth2service;
        this.behalf = behalf;
        this.authHeaderName = authHeaderName;
    }
}

