/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.environment.servicebinding.api.ServiceIdentifier;
import com.sap.cloud.sdk.cloudplatform.connectivity.BtpServiceOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultOAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.MultiUrlPropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2PropertySupplierResolver;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

class BtpServicePropertySuppliers {
    static final OAuth2PropertySupplierResolver DESTINATION = OAuth2PropertySupplierResolver.forServiceIdentifier(ServiceIdentifier.DESTINATION, Destination::new);
    static final OAuth2PropertySupplierResolver CONNECTIVITY = OAuth2PropertySupplierResolver.forServiceIdentifier(ServiceIdentifier.CONNECTIVITY, ConnectivityProxy::new);
    static final OAuth2PropertySupplierResolver WORKFLOW = OAuth2PropertySupplierResolver.forServiceIdentifier(ServiceIdentifier.WORKFLOW, MultiUrlPropertySupplier.of(BtpServiceOptions.WorkflowOptions.class).withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.WorkflowOptions>)BtpServiceOptions.WorkflowOptions.REST_API, "workflow_rest_url").withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.WorkflowOptions>)BtpServiceOptions.WorkflowOptions.ODATA_API, "workflow_odata_url").factory());
    static final OAuth2PropertySupplierResolver BUSINESS_RULES = OAuth2PropertySupplierResolver.forServiceIdentifier(ServiceIdentifier.BUSINESS_RULES, MultiUrlPropertySupplier.of(BtpServiceOptions.BusinessRulesOptions.class).withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.BusinessRulesOptions>)BtpServiceOptions.BusinessRulesOptions.AUTHORING_API, "rule_repository_url").withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.BusinessRulesOptions>)BtpServiceOptions.BusinessRulesOptions.EXECUTION_API, "rule_runtime_url").factory());
    static final OAuth2PropertySupplierResolver BUSINESS_LOGGING = OAuth2PropertySupplierResolver.forServiceIdentifier(ServiceIdentifier.of((String)"business-logging"), MultiUrlPropertySupplier.of(BtpServiceOptions.BusinessLoggingOptions.class).withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.BusinessLoggingOptions>)BtpServiceOptions.BusinessLoggingOptions.CONFIG_API, "configservice").withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.BusinessLoggingOptions>)BtpServiceOptions.BusinessLoggingOptions.TEXT_API, "textresourceservice").withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.BusinessLoggingOptions>)BtpServiceOptions.BusinessLoggingOptions.READ_API, "readservice").withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.BusinessLoggingOptions>)BtpServiceOptions.BusinessLoggingOptions.WRITE_API, "writeservice").factory());
    private static final List<OAuth2PropertySupplierResolver> DEFAULT_SERVICE_RESOLVERS = new ArrayList<OAuth2PropertySupplierResolver>();

    BtpServicePropertySuppliers() {
    }

    static List<OAuth2PropertySupplierResolver> getDefaultServiceResolvers() {
        return new ArrayList<OAuth2PropertySupplierResolver>(DEFAULT_SERVICE_RESOLVERS);
    }

    static {
        DEFAULT_SERVICE_RESOLVERS.add(DESTINATION);
        DEFAULT_SERVICE_RESOLVERS.add(CONNECTIVITY);
        DEFAULT_SERVICE_RESOLVERS.add(BUSINESS_RULES);
        DEFAULT_SERVICE_RESOLVERS.add(WORKFLOW);
        DEFAULT_SERVICE_RESOLVERS.add(BUSINESS_LOGGING);
    }

    private static class ConnectivityProxy
    extends DefaultOAuth2PropertySupplier {
        ConnectivityProxy(@Nonnull ServiceBindingDestinationOptions options) {
            super(options, Collections.emptyList());
        }

        @Override
        @Nonnull
        public URI getServiceUri() {
            String host = this.getCredentialOrThrow(String.class, "onpremise_proxy_host");
            Integer port = (Integer)this.getCredential(Integer.class, "onpremise_proxy_http_port").getOrElse(() -> this.getCredentialOrThrow(Integer.class, "onpremise_proxy_port"));
            try {
                return new URI("http", null, host, port, null, null, null);
            }
            catch (URISyntaxException e) {
                throw new DestinationAccessException("Failed to construct proxy URL", (Throwable)e);
            }
        }
    }

    private static class Destination
    extends DefaultOAuth2PropertySupplier {
        Destination(@Nonnull ServiceBindingDestinationOptions options) {
            super(options, Collections.emptyList());
        }

        @Override
        @Nonnull
        public URI getServiceUri() {
            return this.getCredentialOrThrow(URI.class, "uri");
        }
    }
}

