/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.annotations.Beta;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class OAuth2Options {
    public static final OAuth2Options DEFAULT = new OAuth2Options(false, Map.of(), null);
    private final boolean skipTokenRetrieval;
    @Nonnull
    private final Map<String, String> additionalTokenRetrievalParameters;
    @Nullable
    private final KeyStore clientKeyStore;

    public boolean skipTokenRetrieval() {
        return this.skipTokenRetrieval;
    }

    @Nonnull
    public Map<String, String> getAdditionalTokenRetrievalParameters() {
        return new HashMap<String, String>(this.additionalTokenRetrievalParameters);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    private OAuth2Options(boolean skipTokenRetrieval, @Nonnull Map<String, String> additionalTokenRetrievalParameters, @Nullable KeyStore clientKeyStore) {
        if (additionalTokenRetrievalParameters == null) {
            throw new NullPointerException("additionalTokenRetrievalParameters is marked non-null but is null");
        }
        this.skipTokenRetrieval = skipTokenRetrieval;
        this.additionalTokenRetrievalParameters = additionalTokenRetrievalParameters;
        this.clientKeyStore = clientKeyStore;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2Options)) {
            return false;
        }
        OAuth2Options other = (OAuth2Options)o;
        if (this.skipTokenRetrieval != other.skipTokenRetrieval) {
            return false;
        }
        Map<String, String> this$additionalTokenRetrievalParameters = this.getAdditionalTokenRetrievalParameters();
        Map<String, String> other$additionalTokenRetrievalParameters = other.getAdditionalTokenRetrievalParameters();
        if (this$additionalTokenRetrievalParameters == null ? other$additionalTokenRetrievalParameters != null : !((Object)this$additionalTokenRetrievalParameters).equals(other$additionalTokenRetrievalParameters)) {
            return false;
        }
        KeyStore this$clientKeyStore = this.getClientKeyStore();
        KeyStore other$clientKeyStore = other.getClientKeyStore();
        return !(this$clientKeyStore == null ? other$clientKeyStore != null : !this$clientKeyStore.equals(other$clientKeyStore));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.skipTokenRetrieval ? 79 : 97);
        Map<String, String> $additionalTokenRetrievalParameters = this.getAdditionalTokenRetrievalParameters();
        result = result * 59 + ($additionalTokenRetrievalParameters == null ? 43 : ((Object)$additionalTokenRetrievalParameters).hashCode());
        KeyStore $clientKeyStore = this.getClientKeyStore();
        result = result * 59 + ($clientKeyStore == null ? 43 : $clientKeyStore.hashCode());
        return result;
    }

    @Nullable
    @Generated
    public KeyStore getClientKeyStore() {
        return this.clientKeyStore;
    }

    @Beta
    public static class Builder {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(Builder.class);
        private boolean skipTokenRetrieval = false;
        private final Map<String, String> additionalTokenRetrievalParameters = new HashMap<String, String>();
        private KeyStore clientKeyStore;

        @Nonnull
        public Builder withSkipTokenRetrieval(boolean skipTokenRetrieval) {
            this.skipTokenRetrieval = skipTokenRetrieval;
            return this;
        }

        @Nonnull
        public Builder withTokenRetrievalParameter(@Nonnull String key, @Nonnull String value) {
            this.additionalTokenRetrievalParameters.put(key, value);
            return this;
        }

        @Nonnull
        public Builder withTokenRetrievalParameters(@Nonnull Map<String, String> parameters) {
            this.additionalTokenRetrievalParameters.putAll(parameters);
            return this;
        }

        @Nonnull
        public Builder withClientKeyStore(@Nonnull KeyStore clientKeyStore) {
            this.clientKeyStore = clientKeyStore;
            return this;
        }

        @Nonnull
        public OAuth2Options build() {
            if (this.skipTokenRetrieval && !this.additionalTokenRetrievalParameters.isEmpty()) {
                log.warn("{} have been configured to skip the OAuth2 token retrieval, but there are also additional token request parameters. As there will be no token retrieved, the additional parameters are ignored.\n", OAuth2Options.class);
            }
            return new OAuth2Options(this.skipTokenRetrieval, new HashMap<String, String>(this.additionalTokenRetrievalParameters), this.clientKeyStore);
        }
    }
}

