/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationHeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationRequestContext;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2Service;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import io.vavr.control.Option;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;

class OAuth2HeaderProvider
implements DestinationHeaderProvider {
    @Nonnull
    private final OAuth2Service oauth2service;
    @Nonnull
    private final String authHeaderName;

    @Nonnull
    public List<Header> getHeaders(@Nonnull DestinationRequestContext requestContext) {
        HttpDestination destination = requestContext.getDestination();
        this.assertTenantRemainedConsistent((DestinationProperties)destination);
        String accessToken = this.oauth2service.retrieveAccessToken();
        return Collections.singletonList(new Header(this.authHeaderName, "Bearer " + accessToken));
    }

    private void assertTenantRemainedConsistent(@Nonnull DestinationProperties destination) {
        String currentTenantId;
        Option maybeTenantId = destination.get(DestinationProperty.TENANT_ID);
        if (maybeTenantId.isEmpty()) {
            return;
        }
        String destinationTenantId = (String)maybeTenantId.get();
        if (!destinationTenantId.equals(currentTenantId = (String)TenantAccessor.tryGetCurrentTenant().map(Tenant::getTenantId).getOrElse((Object)""))) {
            String msg = "Tenant ID of destination '%s' does not match the current tenant ID. Destination was created specifically for tenant '%s', but the current tenant is '%s'.";
            String destinationName = (String)destination.get(DestinationProperty.NAME).getOrNull();
            throw new IllegalStateException(String.format("Tenant ID of destination '%s' does not match the current tenant ID. Destination was created specifically for tenant '%s', but the current tenant is '%s'.", destinationName, destinationTenantId, currentTenantId));
        }
    }

    @Generated
    public OAuth2HeaderProvider(@Nonnull OAuth2Service oauth2service, @Nonnull String authHeaderName) {
        if (oauth2service == null) {
            throw new NullPointerException("oauth2service is marked non-null but is null");
        }
        if (authHeaderName == null) {
            throw new NullPointerException("authHeaderName is marked non-null but is null");
        }
        this.oauth2service = oauth2service;
        this.authHeaderName = authHeaderName;
    }
}

