/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceIdentifier;
import com.sap.cloud.environment.servicebinding.api.TypedMapView;
import com.sap.cloud.sdk.cloudplatform.connectivity.BtpServiceOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import io.vavr.CheckedFunction0;
import io.vavr.Lazy;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityAuthenticationServiceBindingDestinationLoader
implements ServiceBindingDestinationLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdentityAuthenticationServiceBindingDestinationLoader.class);
    private static final DestinationAccessException NOT_EXACTLY_ONE_ENDPOINT = new DestinationAccessException("The IAS-based service binding contains multiple HTTP endpoints.");
    private static final String PROPERTY_MISSING_TEMPLATE = "The '%s' attribute of the IAS-based service binding is missing.";
    private static final String PROPERTY_TYPE_MISMATCH_TEMPLATE = "The '%s' attribute of the IAS-based service binding is expected to be an instance of %s, but is of type %s instead.";
    private static final String PROPERTY_TYPE_MISMATCH_WITH_FALLBACK_TEMPLATE = "The '{}' attribute of the IAS-based service binding is expected to be an instance of {}, which is not the case. The fallback value will be used instead.";
    @Nonnull
    private final Lazy<ServiceBindingDestinationLoader> delegateLoader;

    public IdentityAuthenticationServiceBindingDestinationLoader() {
        this.delegateLoader = Lazy.of(ServiceBindingDestinationLoader::defaultLoaderChain);
    }

    IdentityAuthenticationServiceBindingDestinationLoader(@Nonnull ServiceBindingDestinationLoader delegateLoader) {
        this.delegateLoader = Lazy.of(() -> delegateLoader);
    }

    ServiceBindingDestinationLoader getDelegateLoader() {
        return (ServiceBindingDestinationLoader)this.delegateLoader.get();
    }

    @Nonnull
    public Try<HttpDestination> tryGetDestination(@Nonnull ServiceBindingDestinationOptions options) {
        Try maybeDestination;
        ServiceBindingDestinationOptions.Builder optionsBuilder;
        ServiceBinding serviceBinding = options.getServiceBinding();
        TypedMapView credentials = TypedMapView.ofCredentials((ServiceBinding)serviceBinding);
        String preparedMessage = "Failed to create a destination for service '%s' using IAS OAuth credentials.".formatted(serviceBinding.getServiceIdentifier().orElse(null));
        if (!IasServiceBindingView.isBackedByIas(credentials)) {
            return Try.failure((Throwable)new DestinationNotFoundException(null, preparedMessage + " The service binding does not represent a re-use service backed by IAS."));
        }
        Try maybeEndpoint = IasServiceBindingView.tryFromCredentials(credentials).flatMapTry(IdentityAuthenticationServiceBindingDestinationLoader::tryGetEndpoint);
        if (maybeEndpoint.isFailure()) {
            return Try.failure((Throwable)new DestinationAccessException(preparedMessage, maybeEndpoint.getCause()));
        }
        HttpEndpointEntry endpoint = (HttpEndpointEntry)maybeEndpoint.get();
        try {
            optionsBuilder = ServiceBindingDestinationOptions.forService((ServiceIdentifier)ServiceIdentifier.IDENTITY_AUTHENTICATION);
        }
        catch (DestinationAccessException e) {
            return Try.failure((Throwable)new DestinationAccessException(preparedMessage, (Throwable)e));
        }
        optionsBuilder.onBehalfOf(options.getOnBehalfOf()).withOption(BtpServiceOptions.AuthenticationServiceOptions.withTargetUri((URI)endpoint.uri));
        if (!endpoint.alwaysRequiresToken) {
            optionsBuilder.withOption(BtpServiceOptions.IasOptions.withoutTokenForTechnicalProviderUser());
        }
        return (maybeDestination = this.getDelegateLoader().tryGetDestination(optionsBuilder.build())).isSuccess() ? maybeDestination : Try.failure((Throwable)new DestinationAccessException(null, preparedMessage, maybeDestination.getCause()));
    }

    @Nonnull
    private static Try<HttpEndpointEntry> tryGetEndpoint(@Nonnull IasServiceBindingView bindingView) {
        if (bindingView.endpoints.size() != 1) {
            return Try.failure((Throwable)NOT_EXACTLY_ONE_ENDPOINT);
        }
        return Try.success((Object)bindingView.endpoints.get(0));
    }

    private static <T> T getOrThrow(@Nonnull Class<T> valueClass, @Nonnull TypedMapView mapView, @Nonnull String key) {
        if (!mapView.containsKey(key)) {
            throw new DestinationAccessException(PROPERTY_MISSING_TEMPLATE.formatted(key));
        }
        Object value = mapView.get(key);
        if (value == null || !valueClass.isAssignableFrom(value.getClass())) {
            String actualValueClassName = value == null ? "null" : value.getClass().getSimpleName();
            throw new DestinationAccessException(PROPERTY_TYPE_MISMATCH_TEMPLATE.formatted(key, valueClass.getSimpleName(), actualValueClassName));
        }
        return (T)value;
    }

    private static <T> T getWithFallbackOrThrow(@Nonnull Class<T> valueClass, @Nonnull TypedMapView mapView, @Nonnull String key, @Nullable T fallback) {
        if (!mapView.containsKey(key)) {
            return fallback;
        }
        return IdentityAuthenticationServiceBindingDestinationLoader.getOrThrow(valueClass, mapView, key);
    }

    private static <T> T getWithFallback(@Nonnull Class<T> valueClass, @Nonnull TypedMapView mapView, @Nonnull String key, @Nullable T fallback) {
        if (!mapView.containsKey(key)) {
            return fallback;
        }
        Object value = mapView.get(key);
        if (value == null || !valueClass.isAssignableFrom(value.getClass())) {
            log.trace(PROPERTY_TYPE_MISMATCH_WITH_FALLBACK_TEMPLATE, (Object)key, valueClass);
            return fallback;
        }
        return (T)mapView.get(key);
    }

    private static final class IasServiceBindingView {
        @Nonnull
        private final List<HttpEndpointEntry> endpoints;

        @Nonnull
        static Try<IasServiceBindingView> tryFromCredentials(@Nonnull TypedMapView credentials) {
            return Try.of((CheckedFunction0 & Serializable)() -> IasServiceBindingView.getHttpEndpointsOrThrow(credentials)).map(IasServiceBindingView::new);
        }

        private static boolean isBackedByIas(@Nonnull TypedMapView credentials) {
            TypedMapView authenticationService = IdentityAuthenticationServiceBindingDestinationLoader.getWithFallback(TypedMapView.class, credentials, "authentication-service", null);
            if (authenticationService == null) {
                return false;
            }
            String serviceLabel = IdentityAuthenticationServiceBindingDestinationLoader.getWithFallback(String.class, authenticationService, "service-label", null);
            return "identity".equalsIgnoreCase(serviceLabel);
        }

        @Nonnull
        private static List<HttpEndpointEntry> getHttpEndpointsOrThrow(@Nonnull TypedMapView credentials) {
            TypedMapView rawEndpoints = IdentityAuthenticationServiceBindingDestinationLoader.getOrThrow(TypedMapView.class, credentials, "endpoints");
            ArrayList<HttpEndpointEntry> endpoints = new ArrayList<HttpEndpointEntry>();
            for (String name : rawEndpoints.getKeys()) {
                TypedMapView rawEntry;
                HttpEndpointEntry endpoint = HttpEndpointEntry.fromRawEntryOrThrow(name, rawEntry = IdentityAuthenticationServiceBindingDestinationLoader.getOrThrow(TypedMapView.class, rawEndpoints, name));
                if (endpoint == null) continue;
                endpoints.add(endpoint);
            }
            return endpoints;
        }

        @Generated
        public IasServiceBindingView(@Nonnull List<HttpEndpointEntry> endpoints) {
            if (endpoints == null) {
                throw new NullPointerException("endpoints is marked non-null but is null");
            }
            this.endpoints = endpoints;
        }

        @Nonnull
        @Generated
        public List<HttpEndpointEntry> getEndpoints() {
            return this.endpoints;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IasServiceBindingView)) {
                return false;
            }
            IasServiceBindingView other = (IasServiceBindingView)o;
            List<HttpEndpointEntry> this$endpoints = this.getEndpoints();
            List<HttpEndpointEntry> other$endpoints = other.getEndpoints();
            return !(this$endpoints == null ? other$endpoints != null : !((Object)this$endpoints).equals(other$endpoints));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<HttpEndpointEntry> $endpoints = this.getEndpoints();
            result = result * 59 + ($endpoints == null ? 43 : ((Object)$endpoints).hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "IdentityAuthenticationServiceBindingDestinationLoader.IasServiceBindingView(endpoints=" + this.getEndpoints() + ")";
        }
    }

    private static final class HttpEndpointEntry {
        @Nonnull
        private final String name;
        @Nonnull
        private final URI uri;
        private final boolean alwaysRequiresToken;
        private final boolean requiresMutualTls;

        @Nullable
        static HttpEndpointEntry fromRawEntryOrThrow(@Nonnull String name, @Nonnull TypedMapView rawEntry) {
            if (!HttpEndpointEntry.isHttpEndpoint(rawEntry)) {
                return null;
            }
            URI uri = HttpEndpointEntry.getUriOrThrow(rawEntry);
            boolean requiresTokenForTechnicalAccess = HttpEndpointEntry.getAlwaysRequiresTokenOrThrow(rawEntry);
            boolean requiresMutualTls = HttpEndpointEntry.getRequiresMutualTlsOrThrow(rawEntry);
            return new HttpEndpointEntry(name, uri, requiresTokenForTechnicalAccess, requiresMutualTls);
        }

        private static boolean isHttpEndpoint(@Nonnull TypedMapView rawEntry) {
            String protocol = IdentityAuthenticationServiceBindingDestinationLoader.getWithFallback(String.class, rawEntry, "protocol", "http");
            return "http".equalsIgnoreCase(protocol);
        }

        @Nonnull
        private static URI getUriOrThrow(@Nonnull TypedMapView rawEntry) {
            return URI.create(IdentityAuthenticationServiceBindingDestinationLoader.getOrThrow(String.class, rawEntry, "uri"));
        }

        private static boolean getAlwaysRequiresTokenOrThrow(@Nonnull TypedMapView rawEntry) {
            return IdentityAuthenticationServiceBindingDestinationLoader.getWithFallbackOrThrow(Boolean.class, rawEntry, "always-requires-token", true);
        }

        private static boolean getRequiresMutualTlsOrThrow(@Nonnull TypedMapView rawEntry) {
            return IdentityAuthenticationServiceBindingDestinationLoader.getWithFallbackOrThrow(Boolean.class, rawEntry, "requires-mtls", true);
        }

        @Generated
        public HttpEndpointEntry(@Nonnull String name, @Nonnull URI uri, boolean alwaysRequiresToken, boolean requiresMutualTls) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            this.name = name;
            this.uri = uri;
            this.alwaysRequiresToken = alwaysRequiresToken;
            this.requiresMutualTls = requiresMutualTls;
        }

        @Nonnull
        @Generated
        public String getName() {
            return this.name;
        }

        @Nonnull
        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public boolean isAlwaysRequiresToken() {
            return this.alwaysRequiresToken;
        }

        @Generated
        public boolean isRequiresMutualTls() {
            return this.requiresMutualTls;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpEndpointEntry)) {
                return false;
            }
            HttpEndpointEntry other = (HttpEndpointEntry)o;
            if (this.isAlwaysRequiresToken() != other.isAlwaysRequiresToken()) {
                return false;
            }
            if (this.isRequiresMutualTls() != other.isRequiresMutualTls()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            URI this$uri = this.getUri();
            URI other$uri = other.getUri();
            return !(this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAlwaysRequiresToken() ? 79 : 97);
            result = result * 59 + (this.isRequiresMutualTls() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            URI $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "IdentityAuthenticationServiceBindingDestinationLoader.HttpEndpointEntry(name=" + this.getName() + ", uri=" + this.getUri() + ", alwaysRequiresToken=" + this.isAlwaysRequiresToken() + ", requiresMutualTls=" + this.isRequiresMutualTls() + ")";
        }
    }
}

