/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.environment.servicebinding.api.ServiceIdentifier;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OAuth2PropertySupplierResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2PropertySupplierResolver.class);
    @Nonnull
    private final Predicate<ServiceBindingDestinationOptions> matcher;
    @Nonnull
    private final Function<ServiceBindingDestinationOptions, OAuth2PropertySupplier> resolver;

    static OAuth2PropertySupplierResolver forServiceIdentifier(@Nonnull ServiceIdentifier identifier, @Nonnull Function<ServiceBindingDestinationOptions, OAuth2PropertySupplier> resolver) {
        return new OAuth2PropertySupplierResolver(opts -> identifier.equals(opts.getServiceBinding().getServiceIdentifier().orElse(null)), resolver);
    }

    boolean matches(@Nonnull ServiceBindingDestinationOptions options) {
        return this.matcher.test(options);
    }

    @Nullable
    OAuth2PropertySupplier resolve(@Nonnull ServiceBindingDestinationOptions options) {
        return this.resolver.apply(options);
    }

    @Generated
    OAuth2PropertySupplierResolver(@Nonnull Predicate<ServiceBindingDestinationOptions> matcher, @Nonnull Function<ServiceBindingDestinationOptions, OAuth2PropertySupplier> resolver) {
        if (matcher == null) {
            throw new NullPointerException("matcher is marked non-null but is null");
        }
        if (resolver == null) {
            throw new NullPointerException("resolver is marked non-null but is null");
        }
        this.matcher = matcher;
        this.resolver = resolver;
    }
}

