/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.environment.servicebinding.api.ServiceIdentifier;
import com.sap.cloud.sdk.cloudplatform.connectivity.BtpServicePropertySuppliers;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationHeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationProperty;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2HeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2Options;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2PropertySupplierResolver;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2Service;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.security.config.ClientIdentity;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2ServiceBindingDestinationLoader
implements ServiceBindingDestinationLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2ServiceBindingDestinationLoader.class);
    @Nonnull
    static final List<OAuth2PropertySupplierResolver> DEFAULT_SERVICE_RESOLVERS = BtpServicePropertySuppliers.getDefaultServiceResolvers();
    @Nonnull
    private final List<OAuth2PropertySupplierResolver> resolvers;

    public OAuth2ServiceBindingDestinationLoader() {
        this(DEFAULT_SERVICE_RESOLVERS);
    }

    OAuth2ServiceBindingDestinationLoader(@Nonnull List<OAuth2PropertySupplierResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public static void registerPropertySupplier(@Nonnull ServiceIdentifier service, @Nonnull Function<ServiceBindingDestinationOptions, OAuth2PropertySupplier> propertySupplier) {
        log.debug("Prepending a new default resolver {} for service identifier {}.", propertySupplier, (Object)service);
        DEFAULT_SERVICE_RESOLVERS.add(0, OAuth2PropertySupplierResolver.forServiceIdentifier(service, propertySupplier));
    }

    public static void registerPropertySupplier(@Nonnull Predicate<ServiceBindingDestinationOptions> optionsMatcher, @Nonnull Function<ServiceBindingDestinationOptions, OAuth2PropertySupplier> propertySupplier) {
        log.debug("Prepending a new default resolver {} with matcher {}.", propertySupplier, optionsMatcher);
        DEFAULT_SERVICE_RESOLVERS.add(0, new OAuth2PropertySupplierResolver(optionsMatcher, propertySupplier));
    }

    static void resetPropertySuppliers() {
        log.warn("Resetting the default OAuth2 property suppliers. This should only be used in tests.");
        DEFAULT_SERVICE_RESOLVERS.clear();
        DEFAULT_SERVICE_RESOLVERS.addAll(BtpServicePropertySuppliers.getDefaultServiceResolvers());
    }

    @Nonnull
    public Try<HttpDestination> tryGetDestination(@Nonnull ServiceBindingDestinationOptions options) {
        OAuth2Options tokenRetrievalOptions;
        ClientIdentity clientIdentity;
        URI tokenUri;
        URI serviceUri;
        ServiceIdentifier identifier = options.getServiceBinding().getServiceIdentifier().orElse(null);
        log.debug("Checking if the service binding with identifier '{}' can be transformed into a OAuth destination.", (Object)identifier);
        OAuth2PropertySupplier propertySupplier = this.getOAuth2PropertySupplier(options);
        if (propertySupplier == null) {
            String msg = "Could not transform service binding with identifier '%s' into a destination: None of the %s implementations matched the service binding format. If the binding contains OAuth credentials and is expected to be handled by this loader please inspect the log output. In case the service binding is not supported by default you may provide your own implementation by using the static `registerPropertySupplier` method.";
            return Try.failure((Throwable)new DestinationNotFoundException(null, String.format("Could not transform service binding with identifier '%s' into a destination: None of the %s implementations matched the service binding format. If the binding contains OAuth credentials and is expected to be handled by this loader please inspect the log output. In case the service binding is not supported by default you may provide your own implementation by using the static `registerPropertySupplier` method.", identifier, this.resolvers.size())));
        }
        log.debug("Creating an OAuth2 destination for service '{}'.", (Object)identifier);
        try {
            serviceUri = propertySupplier.getServiceUri();
            tokenUri = propertySupplier.getTokenUri();
            clientIdentity = propertySupplier.getClientIdentity();
            tokenRetrievalOptions = propertySupplier.getOAuth2Options();
        }
        catch (DestinationAccessException e) {
            return Try.failure((Throwable)e);
        }
        catch (Exception e) {
            String msg = "Failed to retrieve OAuth2 properties for service binding of service '%s'.";
            return Try.failure((Throwable)new DestinationAccessException(String.format("Failed to retrieve OAuth2 properties for service binding of service '%s'.", identifier), (Throwable)e));
        }
        Option destinationToBeProxied = options.getOption(ServiceBindingDestinationOptions.Options.ProxyOptions.class);
        try {
            OnBehalfOf behalfOf = options.getOnBehalfOf();
            if (destinationToBeProxied.isDefined()) {
                String msg = "Using the given service {} as a proxy service to enhance destination {}.";
                log.debug("Using the given service {} as a proxy service to enhance destination {}.", (Object)identifier, destinationToBeProxied.get());
                HttpDestination dest = this.toProxiedDestination((HttpDestination)destinationToBeProxied.get(), serviceUri, tokenUri, clientIdentity, behalfOf, tokenRetrievalOptions, identifier);
                return Try.success((Object)dest);
            }
            return Try.success((Object)this.toDestination(serviceUri, tokenUri, clientIdentity, behalfOf, tokenRetrievalOptions, identifier));
        }
        catch (Exception e) {
            String msg = "Failed to instantiate OAuth destination based on given properties.";
            return Try.failure((Throwable)new DestinationAccessException("Failed to instantiate OAuth destination based on given properties.", (Throwable)e));
        }
    }

    @Nullable
    private OAuth2PropertySupplier getOAuth2PropertySupplier(@Nonnull ServiceBindingDestinationOptions options) {
        for (OAuth2PropertySupplierResolver resolver : this.resolvers) {
            Try matchTry = Try.of((CheckedFunction0 & Serializable)() -> resolver.matches(options));
            if (matchTry.isFailure()) {
                log.error("Failed to check whether binding options match the resolver.", matchTry.getCause());
                continue;
            }
            if (!((Boolean)matchTry.get()).booleanValue()) continue;
            log.debug("A resolver matched the given options, loading the relevant property supplier.");
            Try supplierTry = Try.of((CheckedFunction0 & Serializable)() -> resolver.resolve(options));
            if (supplierTry.isFailure()) {
                log.error("Failed to resolve the property supplier with provided options.", supplierTry.getCause());
                continue;
            }
            OAuth2PropertySupplier supplier = (OAuth2PropertySupplier)supplierTry.get();
            log.debug("Using property supplier {} for the given options.", (Object)supplier.getClass().getName());
            Try isOAuthTry = Try.of(supplier::isOAuth2Binding);
            if (isOAuthTry.isFailure()) {
                log.error("Failed to check whether the property supplier supports OAuth2.", isOAuthTry.getCause());
                continue;
            }
            if (!((Boolean)isOAuthTry.get()).booleanValue()) {
                log.debug("Supplier {} was applied but claims the binding is not an OAuth2 binding.", (Object)supplier);
                continue;
            }
            return supplier;
        }
        return null;
    }

    @Nonnull
    HttpDestination toDestination(@Nonnull URI serviceUri, @Nonnull URI tokenUri, @Nonnull ClientIdentity clientIdentity, @Nonnull OnBehalfOf behalf, @Nonnull OAuth2Options oAuth2Options, @Nullable ServiceIdentifier serviceIdentifier) {
        String idString = (String)Option.of((Object)serviceIdentifier).map(ServiceIdentifier::toString).getOrElse((Object)"unknown") + "-" + clientIdentity.getId().hashCode();
        log.debug("Creating a new OAuth2 destination for service {} with name '{}'.", (Object)serviceIdentifier, (Object)idString);
        DefaultHttpDestination.Builder destinationBuilder = DefaultHttpDestination.builder((URI)serviceUri).name(idString);
        if (oAuth2Options.skipTokenRetrieval()) {
            log.debug("Skipping OAuth2 token retrieval for destination '{}'.", (Object)idString);
        } else {
            DestinationHeaderProvider headerProvider = this.createHeaderProvider(tokenUri, clientIdentity, behalf, "Authorization", oAuth2Options, serviceIdentifier);
            destinationBuilder.headerProviders(new DestinationHeaderProvider[]{headerProvider});
        }
        if (oAuth2Options.getClientKeyStore() != null) {
            log.debug("Securing communication to OAuth2 destination '{}' using mTLS.", (Object)idString);
            destinationBuilder.keyStore(oAuth2Options.getClientKeyStore());
        }
        return destinationBuilder.build();
    }

    @Nonnull
    HttpDestination toProxiedDestination(@Nonnull HttpDestination destinationToBeProxied, @Nonnull URI proxyUrl, @Nonnull URI tokenUrl, @Nonnull ClientIdentity clientIdentity, @Nonnull OnBehalfOf behalf, @Nonnull OAuth2Options oAuth2Options, @Nullable ServiceIdentifier serviceIdentifier) {
        String destinationName = (String)destinationToBeProxied.get(DestinationProperty.NAME).getOrElse((Object)"<unnamed-destination>");
        DefaultHttpDestination.Builder destinationBuilder = DefaultHttpDestination.fromDestination((Destination)destinationToBeProxied);
        if (oAuth2Options.skipTokenRetrieval()) {
            log.debug("Skipping OAuth2 token retrieval for proxied destination '{}'.", (Object)destinationName);
        } else {
            DestinationHeaderProvider headerProvider = this.createHeaderProvider(tokenUrl, clientIdentity, behalf, "Proxy-Authorization", oAuth2Options, serviceIdentifier);
            destinationBuilder.headerProviders(new DestinationHeaderProvider[]{headerProvider});
        }
        if (oAuth2Options.getClientKeyStore() != null) {
            log.debug("Securing communication to OAuth2 proxy server for proxied destination '{}' using mTLS.", (Object)destinationName);
            destinationBuilder.keyStore(oAuth2Options.getClientKeyStore());
        }
        if (destinationToBeProxied.getProxyConfiguration().isDefined()) {
            return destinationBuilder.buildInternal();
        }
        return destinationBuilder.proxy(proxyUrl).buildInternal();
    }

    DestinationHeaderProvider createHeaderProvider(@Nonnull URI tokenUrl, @Nonnull ClientIdentity clientIdentity, @Nonnull OnBehalfOf behalf, @Nonnull String authHeader, @Nonnull OAuth2Options oAuth2Options, @Nullable ServiceIdentifier serviceIdentifier) {
        log.debug("Creating a new OAuth2 header provider for client id '{}'.", (Object)clientIdentity.getId());
        OAuth2Service oAuth2Service = OAuth2Service.builder().withTokenUri(tokenUrl).withIdentity(clientIdentity).withOnBehalfOf(behalf).withTenantPropagationStrategyFrom(serviceIdentifier).withAdditionalParameters(oAuth2Options.getAdditionalTokenRetrievalParameters()).withTimeLimiter(oAuth2Options.getTimeLimiter()).build();
        return new OAuth2HeaderProvider(oAuth2Service, authHeader);
    }
}

