/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.sap.cloud.environment.servicebinding.api.ServiceIdentifier;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.cache.CacheManager;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2Options;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.SecurityLibWorkarounds;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationOAuthTokenException;
import com.sap.cloud.sdk.cloudplatform.exception.CloudPlatformException;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorator;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantWithSubdomain;
import com.sap.cloud.security.client.HttpClientFactory;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.util.UriUtil;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OAuth2Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2Service.class);
    static final Cache<CacheKey, OAuth2TokenService> tokenServiceCache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    @Nonnull
    private final URI tokenUri;
    @Nonnull
    private final ClientIdentity identity;
    @Nonnull
    private final OnBehalfOf onBehalfOf;
    @Nonnull
    private final TenantPropagationStrategy tenantPropagationStrategy;
    @Nonnull
    private final Map<String, String> additionalParameters;
    @Nonnull
    private final ResilienceConfiguration resilienceConfiguration;

    @Nonnull
    OAuth2TokenService getTokenService(@Nullable String tenantId) {
        CacheKey key = CacheKey.fromIds((String)tenantId, null).append(new Object[]{this.identity});
        return (OAuth2TokenService)tokenServiceCache.get((Object)key, this::createTokenService);
    }

    @Nonnull
    private OAuth2TokenService createTokenService(@Nonnull CacheKey ignored) {
        if (!(this.identity instanceof SecurityLibWorkarounds.ZtisClientIdentity)) {
            return new DefaultOAuth2TokenService(HttpClientFactory.create((ClientIdentity)this.identity));
        }
        DefaultHttpDestination destination = DefaultHttpDestination.builder((String)"").name("oauth-destination-ztis-" + this.identity.getId().hashCode()).keyStore(((SecurityLibWorkarounds.ZtisClientIdentity)this.identity).getKeyStore()).build();
        try {
            return new DefaultOAuth2TokenService((CloseableHttpClient)HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination));
        }
        catch (ClassCastException e) {
            String msg = "For the X509_ATTESTED credential type the 'HttpClientAccessor' must return instances of 'CloseableHttpClient'";
            throw new DestinationAccessException("For the X509_ATTESTED credential type the 'HttpClientAccessor' must return instances of 'CloseableHttpClient'", (Throwable)e);
        }
    }

    @Nonnull
    String retrieveAccessToken() {
        log.debug("Retrieving Access Token from '{}' on behalf of {} with client id '{}'.", new Object[]{this.tokenUri, this.onBehalfOf, this.identity.getId()});
        OAuth2TokenResponse tokenResponse = (OAuth2TokenResponse)ResilienceDecorator.executeSupplier(() -> {
            switch (this.onBehalfOf) {
                case TECHNICAL_USER_PROVIDER: {
                    return this.executeClientCredentialsFlow(null);
                }
                case TECHNICAL_USER_CURRENT_TENANT: {
                    Tenant tenant = (Tenant)TenantAccessor.tryGetCurrentTenant().getOrNull();
                    return this.executeClientCredentialsFlow(tenant);
                }
                case NAMED_USER_CURRENT_TENANT: {
                    return this.executeUserExchangeFlow();
                }
            }
            throw new IllegalStateException("Unknown behalf " + String.valueOf(this.onBehalfOf));
        }, (ResilienceConfiguration)this.resilienceConfiguration);
        if (tokenResponse == null) {
            String message = "OAuth2 token request failed";
            log.debug("OAuth2 token request failed");
            throw new DestinationOAuthTokenException(null, "OAuth2 token request failed");
        }
        String accessToken = tokenResponse.getAccessToken();
        if (accessToken == null) {
            String message = "OAuth2 token request succeeded but the response did not contain an access token";
            log.debug("OAuth2 token request succeeded but the response did not contain an access token: {}", (Object)tokenResponse);
            throw new DestinationOAuthTokenException(null, "OAuth2 token request succeeded but the response did not contain an access token");
        }
        return accessToken;
    }

    @Nullable
    private OAuth2TokenResponse executeClientCredentialsFlow(@Nullable Tenant tenant) {
        log.debug("Retrieving OAuth token via client credentials flow against '{}' on behalf of {} (using tenant {}).", new Object[]{this.tokenUri, this.onBehalfOf, tenant});
        String tenantId = this.getTenantIdOrNull(tenant);
        String zidHeaderValue = this.getTenantHeaderOrNull(tenantId);
        this.setAppTidInCaseOfIAS(tenantId);
        String tenantSubdomain = this.getTenantSubdomainOrNull(tenant);
        OAuth2TokenService tokenService = this.getTokenService(tenantId);
        return (OAuth2TokenResponse)Try.of((CheckedFunction0 & Serializable)() -> tokenService.retrieveAccessTokenViaClientCredentialsGrant(this.tokenUri, this.identity, zidHeaderValue, tenantSubdomain, this.additionalParameters, false)).getOrElseThrow(e -> new TokenRequestFailedException("Failed to resolve access token.", e));
    }

    private void setAppTidInCaseOfIAS(@Nullable String tenantId) {
        if (this.tenantPropagationStrategy == TenantPropagationStrategy.TENANT_SUBDOMAIN && tenantId != null) {
            this.additionalParameters.put("app_tid", tenantId);
        }
    }

    @Nullable
    private String getTenantIdOrNull(@Nullable Tenant tenant) {
        return tenant == null ? null : tenant.getTenantId();
    }

    @Nullable
    private String getTenantHeaderOrNull(@Nullable String tenantId) {
        if (this.tenantPropagationStrategy != TenantPropagationStrategy.ZID_HEADER) {
            return null;
        }
        return tenantId;
    }

    @Nullable
    private String getTenantSubdomainOrNull(@Nullable Tenant tenant) {
        if (this.tenantPropagationStrategy != TenantPropagationStrategy.TENANT_SUBDOMAIN) {
            return null;
        }
        if (tenant == null) {
            return null;
        }
        if (!(tenant instanceof TenantWithSubdomain)) {
            String msg = "Unable to get subdomain of tenant '%s' because the instance is not an instance of %s.";
            throw new DestinationAccessException("Unable to get subdomain of tenant '%s' because the instance is not an instance of %s.".formatted(tenant, TenantWithSubdomain.class.getSimpleName()));
        }
        TenantWithSubdomain tenantWithSubdomain = (TenantWithSubdomain)tenant;
        String subdomain = tenantWithSubdomain.getSubdomain();
        if (subdomain == null) {
            throw new DestinationAccessException("The given tenant '%s' does not have a subdomain defined.".formatted(tenant));
        }
        return subdomain;
    }

    @Nullable
    private OAuth2TokenResponse executeUserExchangeFlow() {
        log.debug("Retrieving OAuth token via user token exchange flow against '{}'.", (Object)this.tokenUri);
        Try maybeToken = AuthTokenAccessor.tryGetCurrentToken().map(AuthToken::getJwt);
        Try maybeTenant = TenantAccessor.tryGetCurrentTenant();
        if (maybeToken.isFailure()) {
            throw new CloudPlatformException("Failed to get the current user token.", maybeToken.getCause());
        }
        Token token = (Token)maybeToken.map(DecodedJWT::getToken).map(Token::create).get();
        if (maybeTenant.isFailure()) {
            log.warn("Unexpected state: An Auth Token was found in the current context, but the current tenant is undefined.This is unexpected, please ensure the TenantAccessor and AuthTokenAccessor return consistent results.Proceeding with tenant {} defined in the current token.", (Object)token.getAppTid());
            log.debug("The following token is used for the JwtBearerTokenFlow: {}", (Object)token);
        } else if (!((Tenant)maybeTenant.get()).getTenantId().equals(token.getAppTid())) {
            throw new CloudPlatformException("Unexpected state: Auth Token and tenant of the current context have different tenant IDs.AuthTokenAccessor returned a token containing tenant ID " + token.getAppTid() + " while TenantAccessor returned " + String.valueOf(maybeTenant.get()) + ". This is unexpected, please ensure the TenantAccessor and AuthTokenAccessor return consistent results.");
        }
        String tenantId = token.getAppTid();
        this.setAppTidInCaseOfIAS(tenantId);
        OAuth2TokenService tokenService = this.getTokenService(tenantId);
        String tenantSubdomain = this.getTenantSubdomainOrNull((Tenant)maybeTenant.getOrNull());
        return (OAuth2TokenResponse)Try.of((CheckedFunction0)(switch (this.tenantPropagationStrategy) {
            case TenantPropagationStrategy.ZID_HEADER -> (CheckedFunction0 & Serializable)() -> tokenService.retrieveAccessTokenViaJwtBearerTokenGrant(this.tokenUri, this.identity, token.getTokenValue(), this.additionalParameters, false, tenantId);
            case TenantPropagationStrategy.TENANT_SUBDOMAIN -> (CheckedFunction0 & Serializable)() -> tokenService.retrieveAccessTokenViaJwtBearerTokenGrant(this.tokenUri, this.identity, token.getTokenValue(), tenantSubdomain, this.additionalParameters, false);
            default -> throw new DestinationAccessException("Unhandled TenantPropagation Strategy: %s.".formatted(new Object[]{this.tenantPropagationStrategy}));
        })).getOrElseThrow(e -> new TokenRequestFailedException("Failed to resolve access token.", e));
    }

    @Nonnull
    static Builder builder() {
        return new Builder();
    }

    @Generated
    OAuth2Service(@Nonnull URI tokenUri, @Nonnull ClientIdentity identity, @Nonnull OnBehalfOf onBehalfOf, @Nonnull TenantPropagationStrategy tenantPropagationStrategy, @Nonnull Map<String, String> additionalParameters, @Nonnull ResilienceConfiguration resilienceConfiguration) {
        if (tokenUri == null) {
            throw new NullPointerException("tokenUri is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (onBehalfOf == null) {
            throw new NullPointerException("onBehalfOf is marked non-null but is null");
        }
        if (tenantPropagationStrategy == null) {
            throw new NullPointerException("tenantPropagationStrategy is marked non-null but is null");
        }
        if (additionalParameters == null) {
            throw new NullPointerException("additionalParameters is marked non-null but is null");
        }
        if (resilienceConfiguration == null) {
            throw new NullPointerException("resilienceConfiguration is marked non-null but is null");
        }
        this.tokenUri = tokenUri;
        this.identity = identity;
        this.onBehalfOf = onBehalfOf;
        this.tenantPropagationStrategy = tenantPropagationStrategy;
        this.additionalParameters = additionalParameters;
        this.resilienceConfiguration = resilienceConfiguration;
    }

    @Nonnull
    @Generated
    ResilienceConfiguration getResilienceConfiguration() {
        return this.resilienceConfiguration;
    }

    static {
        CacheManager.register(tokenServiceCache);
    }

    static enum TenantPropagationStrategy {
        TENANT_SUBDOMAIN,
        ZID_HEADER;

    }

    static class Builder {
        private static final String XSUAA_TOKEN_PATH = "/oauth/token";
        private URI tokenUri;
        private ClientIdentity identity;
        private OnBehalfOf onBehalfOf = OnBehalfOf.TECHNICAL_USER_CURRENT_TENANT;
        private TenantPropagationStrategy tenantPropagationStrategy = TenantPropagationStrategy.ZID_HEADER;
        private final Map<String, String> additionalParameters = new HashMap<String, String>();
        private ResilienceConfiguration.TimeLimiterConfiguration timeLimiter = OAuth2Options.DEFAULT_TIMEOUT;

        Builder() {
        }

        @Nonnull
        Builder withTokenUri(@Nonnull String tokenUri) {
            return this.withTokenUri(URI.create(tokenUri));
        }

        @Nonnull
        Builder withTokenUri(@Nonnull URI tokenUri) {
            URI uri = tokenUri.getPath() == null || tokenUri.getPath().isBlank() ? UriUtil.expandPath((URI)tokenUri, (String)XSUAA_TOKEN_PATH) : tokenUri;
            this.tokenUri = uri;
            return this;
        }

        @Nonnull
        Builder withIdentity(@Nonnull ClientIdentity identity) {
            this.identity = identity;
            return this;
        }

        @Nonnull
        Builder withOnBehalfOf(@Nonnull OnBehalfOf onBehalfOf) {
            this.onBehalfOf = onBehalfOf;
            return this;
        }

        @Nonnull
        Builder withTenantPropagationStrategy(@Nonnull TenantPropagationStrategy tenantPropagationStrategy) {
            this.tenantPropagationStrategy = tenantPropagationStrategy;
            return this;
        }

        @Nonnull
        Builder withTenantPropagationStrategyFrom(@Nullable ServiceIdentifier serviceIdentifier) {
            TenantPropagationStrategy tenantPropagationStrategy = ServiceIdentifier.IDENTITY_AUTHENTICATION.equals((Object)serviceIdentifier) ? TenantPropagationStrategy.TENANT_SUBDOMAIN : TenantPropagationStrategy.ZID_HEADER;
            this.tenantPropagationStrategy = tenantPropagationStrategy;
            return this;
        }

        @Nonnull
        Builder withAdditionalParameter(@Nonnull String key, @Nonnull String value) {
            this.additionalParameters.put(key, value);
            return this;
        }

        @Nonnull
        Builder withAdditionalParameters(@Nonnull Map<String, String> additionalParameters) {
            this.additionalParameters.putAll(additionalParameters);
            return this;
        }

        @Nonnull
        Builder withTimeLimiter(@Nonnull ResilienceConfiguration.TimeLimiterConfiguration timeLimiter) {
            this.timeLimiter = timeLimiter;
            return this;
        }

        @Nonnull
        OAuth2Service build() {
            if (this.tokenUri == null || this.identity == null) {
                throw new ShouldNotHappenException("Some required parameters for the OAuth2Service are null.");
            }
            ResilienceConfiguration resilienceConfig = ResilienceConfiguration.of((String)(this.tokenUri.getHost() + "-" + this.identity.getId())).isolationMode(ResilienceIsolationMode.TENANT_OPTIONAL).timeLimiterConfiguration(this.timeLimiter);
            HashMap<String, String> additionalParameters = new HashMap<String, String>(this.additionalParameters);
            return new OAuth2Service(this.tokenUri, this.identity, this.onBehalfOf, this.tenantPropagationStrategy, additionalParameters, resilienceConfig);
        }

        @Generated
        URI getTokenUri() {
            return this.tokenUri;
        }

        @Generated
        ClientIdentity getIdentity() {
            return this.identity;
        }

        @Generated
        OnBehalfOf getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Generated
        TenantPropagationStrategy getTenantPropagationStrategy() {
            return this.tenantPropagationStrategy;
        }

        @Generated
        Map<String, String> getAdditionalParameters() {
            return this.additionalParameters;
        }

        @Generated
        ResilienceConfiguration.TimeLimiterConfiguration getTimeLimiter() {
            return this.timeLimiter;
        }
    }
}

