/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.environment.servicebinding.api.ServiceIdentifier;
import com.sap.cloud.sdk.cloudplatform.connectivity.BtpServiceOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultOAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.MultiUrlPropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2Options;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2PropertySupplierResolver;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.SecurityLibWorkarounds;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.security.config.ClientCertificate;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.mtls.SSLContextFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BtpServicePropertySuppliers {
    static final OAuth2PropertySupplierResolver XSUAA = OAuth2PropertySupplierResolver.forServiceIdentifier(ServiceIdentifier.XSUAA, Xsuaa::new);
    static final OAuth2PropertySupplierResolver DESTINATION = OAuth2PropertySupplierResolver.forServiceIdentifier(ServiceIdentifier.DESTINATION, Destination::new);
    static final OAuth2PropertySupplierResolver CONNECTIVITY = OAuth2PropertySupplierResolver.forServiceIdentifier(ServiceIdentifier.CONNECTIVITY, ConnectivityProxy::new);
    static final OAuth2PropertySupplierResolver IDENTITY_AUTHENTICATION = OAuth2PropertySupplierResolver.forServiceIdentifier(ServiceIdentifier.IDENTITY_AUTHENTICATION, IdentityAuthentication::new);
    static final OAuth2PropertySupplierResolver WORKFLOW = OAuth2PropertySupplierResolver.forServiceIdentifier(ServiceIdentifier.WORKFLOW, MultiUrlPropertySupplier.of(BtpServiceOptions.WorkflowOptions.class).withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.WorkflowOptions>)BtpServiceOptions.WorkflowOptions.REST_API, "workflow_rest_url").withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.WorkflowOptions>)BtpServiceOptions.WorkflowOptions.ODATA_API, "workflow_odata_url").factory());
    static final OAuth2PropertySupplierResolver BUSINESS_RULES = OAuth2PropertySupplierResolver.forServiceIdentifier(ServiceIdentifier.BUSINESS_RULES, MultiUrlPropertySupplier.of(BtpServiceOptions.BusinessRulesOptions.class).withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.BusinessRulesOptions>)BtpServiceOptions.BusinessRulesOptions.AUTHORING_API, "rule_repository_url").withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.BusinessRulesOptions>)BtpServiceOptions.BusinessRulesOptions.EXECUTION_API, "rule_runtime_url").factory());
    static final OAuth2PropertySupplierResolver BUSINESS_LOGGING = OAuth2PropertySupplierResolver.forServiceIdentifier(ServiceIdentifier.of((String)"business-logging"), MultiUrlPropertySupplier.of(BtpServiceOptions.BusinessLoggingOptions.class).withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.BusinessLoggingOptions>)BtpServiceOptions.BusinessLoggingOptions.CONFIG_API, "configservice", MultiUrlPropertySupplier.REMOVE_PATH).withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.BusinessLoggingOptions>)BtpServiceOptions.BusinessLoggingOptions.TEXT_API, "textresourceservice", MultiUrlPropertySupplier.REMOVE_PATH).withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.BusinessLoggingOptions>)BtpServiceOptions.BusinessLoggingOptions.READ_API, "readservice", MultiUrlPropertySupplier.REMOVE_PATH).withUrlKey((ServiceBindingDestinationOptions.OptionsEnhancer<BtpServiceOptions.BusinessLoggingOptions>)BtpServiceOptions.BusinessLoggingOptions.WRITE_API, "writeservice", MultiUrlPropertySupplier.REMOVE_PATH).factory());
    static final OAuth2PropertySupplierResolver AI_CORE = OAuth2PropertySupplierResolver.forServiceIdentifier(ServiceIdentifier.AI_CORE, AiCore::new);
    private static final List<OAuth2PropertySupplierResolver> DEFAULT_SERVICE_RESOLVERS = new ArrayList<OAuth2PropertySupplierResolver>();

    BtpServicePropertySuppliers() {
    }

    static List<OAuth2PropertySupplierResolver> getDefaultServiceResolvers() {
        return new ArrayList<OAuth2PropertySupplierResolver>(DEFAULT_SERVICE_RESOLVERS);
    }

    static {
        DEFAULT_SERVICE_RESOLVERS.add(XSUAA);
        DEFAULT_SERVICE_RESOLVERS.add(DESTINATION);
        DEFAULT_SERVICE_RESOLVERS.add(CONNECTIVITY);
        DEFAULT_SERVICE_RESOLVERS.add(BUSINESS_RULES);
        DEFAULT_SERVICE_RESOLVERS.add(WORKFLOW);
        DEFAULT_SERVICE_RESOLVERS.add(BUSINESS_LOGGING);
        DEFAULT_SERVICE_RESOLVERS.add(IDENTITY_AUTHENTICATION);
        DEFAULT_SERVICE_RESOLVERS.add(AI_CORE);
    }

    private static class AiCore
    extends DefaultOAuth2PropertySupplier {
        AiCore(@Nonnull ServiceBindingDestinationOptions options) {
            super(options, Collections.emptyList());
        }

        @Override
        @Nonnull
        public URI getServiceUri() {
            return this.getCredentialOrThrow(URI.class, "serviceurls", "AI_API_URL");
        }
    }

    private static class IdentityAuthentication
    extends DefaultOAuth2PropertySupplier {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(IdentityAuthentication.class);

        IdentityAuthentication(@Nonnull ServiceBindingDestinationOptions options) {
            super(options, List.of());
        }

        @Override
        @Nonnull
        public URI getServiceUri() {
            return (URI)this.options.getOption(BtpServiceOptions.AuthenticationServiceOptions.TargetUri.class).getOrElse(() -> super.getServiceUri());
        }

        @Override
        @Nonnull
        public URI getTokenUri() {
            String providerUrl = this.getCredentialOrThrow(String.class, "url");
            if (providerUrl.endsWith("/")) {
                providerUrl = providerUrl.substring(0, providerUrl.length() - 1);
            }
            return URI.create(providerUrl + "/oauth2/token");
        }

        @Override
        @Nonnull
        public OAuth2Options getOAuth2Options() {
            OAuth2Options.Builder builder = OAuth2Options.builder();
            this.options.getOption(OAuth2Options.TokenRetrievalTimeout.class).peek(builder::withTimeLimiter);
            if (this.skipTokenRetrieval()) {
                builder.withSkipTokenRetrieval(true);
            } else {
                this.attachIasCommunicationOptions(builder);
                builder.withTokenRetrievalParameter("app_tid", this.getCredentialOrThrow(String.class, "app_tid"));
            }
            this.attachClientKeyStore(builder);
            return builder.build();
        }

        private void attachIasCommunicationOptions(@Nonnull OAuth2Options.Builder optionsBuilder) {
            BtpServiceOptions.IasOptions.IasCommunicationOptions o = (BtpServiceOptions.IasOptions.IasCommunicationOptions)this.options.getOption(BtpServiceOptions.IasOptions.IasCommunicationOptions.class).getOrNull();
            if (o == null) {
                return;
            }
            if (o.getApplicationName() != null) {
                optionsBuilder.withTokenRetrievalParameter("resource", "urn:sap:identity:application:provider:name:" + o.getApplicationName());
                return;
            }
            if (o.getConsumerClientId() != null) {
                String value = "urn:sap:identity:consumer:clientid:" + o.getConsumerClientId();
                if (o.getConsumerTenantId() != null) {
                    value = value + ":apptid:" + o.getConsumerTenantId();
                }
                optionsBuilder.withTokenRetrievalParameter("resource", value);
            }
        }

        private boolean skipTokenRetrieval() {
            boolean tokenIsAlwaysRequired;
            OnBehalfOf behalf = this.options.getOnBehalfOf();
            Boolean noTokenRequired = (Boolean)this.options.getOption(BtpServiceOptions.IasOptions.NoTokenForTechnicalProviderUser.class).getOrElse((Object)false);
            boolean bl = tokenIsAlwaysRequired = noTokenRequired == false;
            if (tokenIsAlwaysRequired) {
                return false;
            }
            return switch (behalf) {
                default -> throw new IncompatibleClassChangeError();
                case OnBehalfOf.NAMED_USER_CURRENT_TENANT -> false;
                case OnBehalfOf.TECHNICAL_USER_PROVIDER -> true;
                case OnBehalfOf.TECHNICAL_USER_CURRENT_TENANT -> this.currentTenantIsProvider();
            };
        }

        private boolean currentTenantIsProvider() {
            String maybeTenantId = (String)TenantAccessor.tryGetCurrentTenant().map(Tenant::getTenantId).getOrNull();
            if (maybeTenantId == null) {
                return true;
            }
            String providerTenantId = this.getCredentialOrThrow(String.class, "app_tid");
            return maybeTenantId.equalsIgnoreCase(providerTenantId);
        }

        private void attachClientKeyStore(@Nonnull OAuth2Options.Builder optionsBuilder) {
            KeyStore maybeClientStore = this.getClientKeyStore();
            if (maybeClientStore != null) {
                optionsBuilder.withClientKeyStore(maybeClientStore);
            }
        }

        @Nullable
        private KeyStore getClientKeyStore() {
            ClientIdentity clientIdentity = this.getClientIdentity();
            if (clientIdentity instanceof SecurityLibWorkarounds.ZtisClientIdentity) {
                return ((SecurityLibWorkarounds.ZtisClientIdentity)clientIdentity).getKeyStore();
            }
            if (!(clientIdentity instanceof ClientCertificate)) {
                return null;
            }
            try {
                return SSLContextFactory.getInstance().createKeyStore(clientIdentity);
            }
            catch (Exception e) {
                throw new DestinationAccessException("Unable to extract client key store from IAS service binding.", (Throwable)e);
            }
        }
    }

    private static class ConnectivityProxy
    extends DefaultOAuth2PropertySupplier {
        ConnectivityProxy(@Nonnull ServiceBindingDestinationOptions options) {
            super(options, Collections.emptyList());
        }

        @Override
        @Nonnull
        public URI getServiceUri() {
            String host = this.getCredentialOrThrow(String.class, "onpremise_proxy_host");
            Integer port = (Integer)this.getCredential(Integer.class, "onpremise_proxy_http_port").getOrElse(() -> this.getCredentialOrThrow(Integer.class, "onpremise_proxy_port"));
            try {
                return new URI("http", null, host, port, null, null, null);
            }
            catch (URISyntaxException e) {
                throw new DestinationAccessException("Failed to construct proxy URL", (Throwable)e);
            }
        }
    }

    private static class Destination
    extends DefaultOAuth2PropertySupplier {
        Destination(@Nonnull ServiceBindingDestinationOptions options) {
            super(options, Collections.emptyList());
        }

        @Override
        @Nonnull
        public URI getServiceUri() {
            return this.getCredentialOrThrow(URI.class, "uri");
        }
    }

    private static class Xsuaa
    extends DefaultOAuth2PropertySupplier {
        public Xsuaa(@Nonnull ServiceBindingDestinationOptions options) {
            super(options, List.of());
        }

        @Override
        @Nonnull
        public URI getServiceUri() {
            return (URI)this.options.getOption(BtpServiceOptions.AuthenticationServiceOptions.TargetUri.class).getOrElse(() -> super.getServiceUri());
        }
    }
}

