/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultOAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import io.vavr.control.Option;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MultiUrlPropertySupplier<T extends ServiceBindingDestinationOptions.OptionsEnhancer<T>>
extends DefaultOAuth2PropertySupplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiUrlPropertySupplier.class);
    static final Function<URI, URI> REMOVE_PATH = uri -> uri.resolve("/");
    private final Class<T> enhancerClass;
    private final Map<ServiceBindingDestinationOptions.OptionsEnhancer<T>, UrlExtractor> urlExtractors;

    MultiUrlPropertySupplier(@Nonnull ServiceBindingDestinationOptions options, @Nonnull Class<T> enhancerClass, @Nonnull Map<ServiceBindingDestinationOptions.OptionsEnhancer<T>, UrlExtractor> urlExtractors) {
        super(options);
        this.enhancerClass = enhancerClass;
        this.urlExtractors = urlExtractors;
    }

    @Override
    @Nonnull
    public URI getServiceUri() {
        Option maybeOption = this.options.getOption(this.enhancerClass);
        if (maybeOption.isEmpty()) {
            throw new DestinationAccessException("No option given for which Business Rules API should be used. Please include an option " + this.enhancerClass.getName() + " in the service binding destination options.");
        }
        ServiceBindingDestinationOptions.OptionsEnhancer option = (ServiceBindingDestinationOptions.OptionsEnhancer)maybeOption.get();
        UrlExtractor urlExtractor = this.urlExtractors.get(option);
        if (urlExtractor == null) {
            throw new IllegalStateException("Found option value " + String.valueOf(option) + " for " + this.enhancerClass.getName() + ", but no URL key was registered for this value. Please ensure that for each possible choice a URL key is registered.");
        }
        return urlExtractor.getUrl(key -> {
            log.debug("Option {} selected, using binding key {}.", (Object)option, key);
            return this.getCredentialOrThrow(URI.class, "endpoints", (String)key);
        });
    }

    @Nonnull
    static <T extends ServiceBindingDestinationOptions.OptionsEnhancer<T>> Builder<T> of(@Nonnull Class<T> enhancerClass) {
        return new Builder<T>(enhancerClass);
    }

    static final class UrlExtractor {
        private static final Function<URI, URI> NO_TRANSFORMATION = url -> url;
        @Nonnull
        private final String urlKey;
        @Nonnull
        private final Function<URI, URI> urlTransformation;

        UrlExtractor(@Nonnull String urlKey) {
            this(urlKey, NO_TRANSFORMATION);
        }

        @Nonnull
        URI getUrl(@Nonnull Function<String, URI> urlReader) {
            URI rawUri = urlReader.apply(this.urlKey);
            return this.urlTransformation.apply(rawUri);
        }

        @Generated
        public UrlExtractor(@Nonnull String urlKey, @Nonnull Function<URI, URI> urlTransformation) {
            if (urlKey == null) {
                throw new NullPointerException("urlKey is marked non-null but is null");
            }
            if (urlTransformation == null) {
                throw new NullPointerException("urlTransformation is marked non-null but is null");
            }
            this.urlKey = urlKey;
            this.urlTransformation = urlTransformation;
        }
    }

    static final class Builder<T extends ServiceBindingDestinationOptions.OptionsEnhancer<T>> {
        private final Class<T> enhancerClass;
        private final Map<ServiceBindingDestinationOptions.OptionsEnhancer<T>, UrlExtractor> urlExtractors = new HashMap<ServiceBindingDestinationOptions.OptionsEnhancer<T>, UrlExtractor>();

        @Nonnull
        Builder<T> withUrlKey(@Nonnull ServiceBindingDestinationOptions.OptionsEnhancer<T> enhancer, @Nonnull String urlKey) {
            this.urlExtractors.put(enhancer, new UrlExtractor(urlKey));
            return this;
        }

        @Nonnull
        Builder<T> withUrlKey(@Nonnull ServiceBindingDestinationOptions.OptionsEnhancer<T> enhancer, @Nonnull String urlKey, @Nonnull Function<URI, URI> urlTransformation) {
            this.urlExtractors.put(enhancer, new UrlExtractor(urlKey, urlTransformation));
            return this;
        }

        @Nonnull
        Function<ServiceBindingDestinationOptions, OAuth2PropertySupplier> factory() {
            return options -> new MultiUrlPropertySupplier<T>((ServiceBindingDestinationOptions)options, this.enhancerClass, this.urlExtractors);
        }

        @Generated
        public Builder(Class<T> enhancerClass) {
            this.enhancerClass = enhancerClass;
        }
    }
}

