/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationHeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2HeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2Service;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.security.config.ClientIdentity;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2DestinationBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2DestinationBuilder.class);

    @Nonnull
    public static BuilderWithTargetUrl forTargetUrl(@Nonnull String targetUrl) {
        return tokenUrl -> (client, behalf) -> {
            OAuth2Service oauth2service = OAuth2Service.builder().withTokenUri(tokenUrl).withIdentity(client).withOnBehalfOf(behalf).build();
            DefaultHttpDestination.Builder destinationBuilder = DefaultHttpDestination.builder((String)targetUrl);
            destinationBuilder.name(String.valueOf(client.getId().hashCode()));
            return destinationBuilder.headerProviders(new DestinationHeaderProvider[]{new OAuth2HeaderProvider(oauth2service, "Authorization")});
        };
    }

    @FunctionalInterface
    public static interface BuilderWithTargetUrl {
        @Nonnull
        public BuilderWithTokenEndpoint withTokenEndpoint(@Nonnull String var1);
    }

    @FunctionalInterface
    public static interface BuilderWithTokenEndpoint {
        @Nonnull
        public DefaultHttpDestination.Builder withClient(@Nonnull ClientIdentity var1, @Nonnull OnBehalfOf var2);
    }
}

