/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import java.security.KeyStore;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OAuth2Options {
    public static final ResilienceConfiguration.TimeLimiterConfiguration DEFAULT_TIMEOUT = ResilienceConfiguration.TimeLimiterConfiguration.of((Duration)Duration.ofSeconds(10L));
    public static final TokenCacheParameters DEFAULT_TOKEN_CACHE_PARAMETERS = TokenCacheParameters.of(Duration.ofHours(1L), 1000, Duration.ofSeconds(30L));
    public static final OAuth2Options DEFAULT = new OAuth2Options(false, Map.of(), DEFAULT_TIMEOUT, null, DEFAULT_TOKEN_CACHE_PARAMETERS);
    private final boolean skipTokenRetrieval;
    @Nonnull
    private final Map<String, String> additionalTokenRetrievalParameters;
    @Nonnull
    private final ResilienceConfiguration.TimeLimiterConfiguration timeLimiter;
    @Nullable
    private final KeyStore clientKeyStore;
    @Nonnull
    private final TokenCacheParameters tokenCacheParameters;

    public boolean skipTokenRetrieval() {
        return this.skipTokenRetrieval;
    }

    @Nonnull
    public Map<String, String> getAdditionalTokenRetrievalParameters() {
        return new HashMap<String, String>(this.additionalTokenRetrievalParameters);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    private OAuth2Options(boolean skipTokenRetrieval, @Nonnull Map<String, String> additionalTokenRetrievalParameters, @Nonnull ResilienceConfiguration.TimeLimiterConfiguration timeLimiter, @Nullable KeyStore clientKeyStore, @Nonnull TokenCacheParameters tokenCacheParameters) {
        if (additionalTokenRetrievalParameters == null) {
            throw new NullPointerException("additionalTokenRetrievalParameters is marked non-null but is null");
        }
        if (timeLimiter == null) {
            throw new NullPointerException("timeLimiter is marked non-null but is null");
        }
        if (tokenCacheParameters == null) {
            throw new NullPointerException("tokenCacheParameters is marked non-null but is null");
        }
        this.skipTokenRetrieval = skipTokenRetrieval;
        this.additionalTokenRetrievalParameters = additionalTokenRetrievalParameters;
        this.timeLimiter = timeLimiter;
        this.clientKeyStore = clientKeyStore;
        this.tokenCacheParameters = tokenCacheParameters;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2Options)) {
            return false;
        }
        OAuth2Options other = (OAuth2Options)o;
        if (this.skipTokenRetrieval != other.skipTokenRetrieval) {
            return false;
        }
        Map<String, String> this$additionalTokenRetrievalParameters = this.getAdditionalTokenRetrievalParameters();
        Map<String, String> other$additionalTokenRetrievalParameters = other.getAdditionalTokenRetrievalParameters();
        if (this$additionalTokenRetrievalParameters == null ? other$additionalTokenRetrievalParameters != null : !((Object)this$additionalTokenRetrievalParameters).equals(other$additionalTokenRetrievalParameters)) {
            return false;
        }
        ResilienceConfiguration.TimeLimiterConfiguration this$timeLimiter = this.getTimeLimiter();
        ResilienceConfiguration.TimeLimiterConfiguration other$timeLimiter = other.getTimeLimiter();
        if (this$timeLimiter == null ? other$timeLimiter != null : !this$timeLimiter.equals(other$timeLimiter)) {
            return false;
        }
        KeyStore this$clientKeyStore = this.getClientKeyStore();
        KeyStore other$clientKeyStore = other.getClientKeyStore();
        if (this$clientKeyStore == null ? other$clientKeyStore != null : !this$clientKeyStore.equals(other$clientKeyStore)) {
            return false;
        }
        TokenCacheParameters this$tokenCacheParameters = this.getTokenCacheParameters();
        TokenCacheParameters other$tokenCacheParameters = other.getTokenCacheParameters();
        return !(this$tokenCacheParameters == null ? other$tokenCacheParameters != null : !this$tokenCacheParameters.equals(other$tokenCacheParameters));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.skipTokenRetrieval ? 79 : 97);
        Map<String, String> $additionalTokenRetrievalParameters = this.getAdditionalTokenRetrievalParameters();
        result = result * 59 + ($additionalTokenRetrievalParameters == null ? 43 : ((Object)$additionalTokenRetrievalParameters).hashCode());
        ResilienceConfiguration.TimeLimiterConfiguration $timeLimiter = this.getTimeLimiter();
        result = result * 59 + ($timeLimiter == null ? 43 : $timeLimiter.hashCode());
        KeyStore $clientKeyStore = this.getClientKeyStore();
        result = result * 59 + ($clientKeyStore == null ? 43 : $clientKeyStore.hashCode());
        TokenCacheParameters $tokenCacheParameters = this.getTokenCacheParameters();
        result = result * 59 + ($tokenCacheParameters == null ? 43 : $tokenCacheParameters.hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public ResilienceConfiguration.TimeLimiterConfiguration getTimeLimiter() {
        return this.timeLimiter;
    }

    @Nullable
    @Generated
    public KeyStore getClientKeyStore() {
        return this.clientKeyStore;
    }

    @Nonnull
    @Generated
    public TokenCacheParameters getTokenCacheParameters() {
        return this.tokenCacheParameters;
    }

    public static class Builder {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(Builder.class);
        private boolean skipTokenRetrieval = false;
        private final Map<String, String> additionalTokenRetrievalParameters = new HashMap<String, String>();
        private KeyStore clientKeyStore;
        private ResilienceConfiguration.TimeLimiterConfiguration timeLimiter = DEFAULT_TIMEOUT;
        private TokenCacheParameters tokenCacheParameters = DEFAULT_TOKEN_CACHE_PARAMETERS;

        @Nonnull
        public Builder withSkipTokenRetrieval(boolean skipTokenRetrieval) {
            this.skipTokenRetrieval = skipTokenRetrieval;
            return this;
        }

        @Nonnull
        public Builder withTokenRetrievalParameter(@Nonnull String key, @Nonnull String value) {
            this.additionalTokenRetrievalParameters.put(key, value);
            return this;
        }

        @Nonnull
        public Builder withTokenRetrievalParameters(@Nonnull Map<String, String> parameters) {
            this.additionalTokenRetrievalParameters.putAll(parameters);
            return this;
        }

        @Nonnull
        public Builder withClientKeyStore(@Nonnull KeyStore clientKeyStore) {
            this.clientKeyStore = clientKeyStore;
            return this;
        }

        @Nonnull
        public Builder withTimeLimiter(@Nonnull ResilienceConfiguration.TimeLimiterConfiguration timeLimiter) {
            this.timeLimiter = timeLimiter;
            return this;
        }

        @Nonnull
        public Builder withTokenCacheParameters(@Nonnull TokenCacheParameters tokenCacheParameters) {
            this.tokenCacheParameters = tokenCacheParameters;
            return this;
        }

        @Nonnull
        public OAuth2Options build() {
            if (this.skipTokenRetrieval && !this.additionalTokenRetrievalParameters.isEmpty()) {
                log.warn("{} have been configured to skip the OAuth2 token retrieval, but there are also additional token request parameters. As there will be no token retrieved, the additional parameters are ignored.\n", OAuth2Options.class);
            }
            return new OAuth2Options(this.skipTokenRetrieval, new HashMap<String, String>(this.additionalTokenRetrievalParameters), this.timeLimiter, this.clientKeyStore, this.tokenCacheParameters);
        }
    }

    @Beta
    public static class TokenCacheParameters
    implements ServiceBindingDestinationOptions.OptionsEnhancer<TokenCacheParameters> {
        @Nonnull
        private final Duration cacheDuration;
        @Nonnull
        private final Integer cacheSize;
        @Nonnull
        private final Duration tokenExpirationDelta;

        @Nonnull
        public TokenCacheParameters getValue() {
            return this;
        }

        @Nonnull
        @Generated
        public Duration getCacheDuration() {
            return this.cacheDuration;
        }

        @Nonnull
        @Generated
        public Integer getCacheSize() {
            return this.cacheSize;
        }

        @Nonnull
        @Generated
        public Duration getTokenExpirationDelta() {
            return this.tokenExpirationDelta;
        }

        @Generated
        private TokenCacheParameters(@Nonnull Duration cacheDuration, @Nonnull Integer cacheSize, @Nonnull Duration tokenExpirationDelta) {
            if (cacheDuration == null) {
                throw new NullPointerException("cacheDuration is marked non-null but is null");
            }
            if (cacheSize == null) {
                throw new NullPointerException("cacheSize is marked non-null but is null");
            }
            if (tokenExpirationDelta == null) {
                throw new NullPointerException("tokenExpirationDelta is marked non-null but is null");
            }
            this.cacheDuration = cacheDuration;
            this.cacheSize = cacheSize;
            this.tokenExpirationDelta = tokenExpirationDelta;
        }

        @Nonnull
        @Generated
        public static TokenCacheParameters of(@Nonnull Duration cacheDuration, @Nonnull Integer cacheSize, @Nonnull Duration tokenExpirationDelta) {
            return new TokenCacheParameters(cacheDuration, cacheSize, tokenExpirationDelta);
        }
    }

    public static class TokenRetrievalTimeout
    implements ServiceBindingDestinationOptions.OptionsEnhancer<ResilienceConfiguration.TimeLimiterConfiguration> {
        @Nonnull
        private final ResilienceConfiguration.TimeLimiterConfiguration value;

        @Nonnull
        @Generated
        public ResilienceConfiguration.TimeLimiterConfiguration getValue() {
            return this.value;
        }

        @Generated
        private TokenRetrievalTimeout(@Nonnull ResilienceConfiguration.TimeLimiterConfiguration value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }

        @Nonnull
        @Generated
        public static TokenRetrievalTimeout of(@Nonnull ResilienceConfiguration.TimeLimiterConfiguration value) {
            return new TokenRetrievalTimeout(value);
        }
    }
}

