/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultOAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import io.vavr.control.Option;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MultiUrlPropertySupplier<T extends ServiceBindingDestinationOptions.OptionsEnhancer<T>>
extends DefaultOAuth2PropertySupplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiUrlPropertySupplier.class);
    private final Class<T> enhancerClass;
    private final Map<ServiceBindingDestinationOptions.OptionsEnhancer<T>, String> urlKeys;

    private MultiUrlPropertySupplier(@Nonnull ServiceBindingDestinationOptions options, @Nonnull Class<T> enhancerClass, @Nonnull Map<ServiceBindingDestinationOptions.OptionsEnhancer<T>, String> urlKeys) {
        super(options);
        this.enhancerClass = enhancerClass;
        this.urlKeys = urlKeys;
    }

    @Override
    @Nonnull
    public URI getServiceUri() {
        Option maybeOption = this.options.getOption(this.enhancerClass);
        if (maybeOption.isEmpty()) {
            throw new DestinationAccessException("No option given for which Business Rules API should be used. Please include an option " + this.enhancerClass.getName() + " in the service binding destination options.");
        }
        ServiceBindingDestinationOptions.OptionsEnhancer option = (ServiceBindingDestinationOptions.OptionsEnhancer)maybeOption.get();
        String bindingKey = this.urlKeys.get(option);
        if (bindingKey == null) {
            throw new IllegalStateException("Found option value " + option + " for " + this.enhancerClass.getName() + ", but no URL key was registered for this value. Please ensure that for each possible choice a URL key is registered.");
        }
        log.debug("Option {} selected, using binding key {}.", (Object)option, (Object)bindingKey);
        return (URI)this.getCredential(URI.class, "endpoints", bindingKey).get();
    }

    @Nonnull
    static <T extends ServiceBindingDestinationOptions.OptionsEnhancer<T>> Builder<T> of(@Nonnull Class<T> enhancerClass) {
        return new Builder<T>(enhancerClass);
    }

    static final class Builder<T extends ServiceBindingDestinationOptions.OptionsEnhancer<T>> {
        private final Class<T> enhancerClass;
        private final Map<ServiceBindingDestinationOptions.OptionsEnhancer<T>, String> urlKeys = new HashMap<ServiceBindingDestinationOptions.OptionsEnhancer<T>, String>();

        @Nonnull
        Builder<T> withUrlKey(@Nonnull ServiceBindingDestinationOptions.OptionsEnhancer<T> enhancer, @Nonnull String urlKey) {
            this.urlKeys.put(enhancer, urlKey);
            return this;
        }

        @Nonnull
        Function<ServiceBindingDestinationOptions, OAuth2PropertySupplier> factory() {
            return options -> new MultiUrlPropertySupplier<T>((ServiceBindingDestinationOptions)options, this.enhancerClass, this.urlKeys);
        }

        @Generated
        public Builder(Class<T> enhancerClass) {
            this.enhancerClass = enhancerClass;
        }
    }
}

