/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.annotations.Beta;
import com.sap.cloud.environment.servicebinding.api.ServiceIdentifier;
import com.sap.cloud.sdk.cloudplatform.connectivity.BtpServicePropertySuppliers;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationHeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2HeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2PropertySupplierResolver;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2Service;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.security.config.ClientIdentity;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class OAuth2ServiceBindingDestinationLoader
implements ServiceBindingDestinationLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2ServiceBindingDestinationLoader.class);
    @Nonnull
    static final List<OAuth2PropertySupplierResolver> DEFAULT_SERVICE_RESOLVERS = BtpServicePropertySuppliers.getDefaultServiceResolvers();
    @Nonnull
    private final List<OAuth2PropertySupplierResolver> resolvers;

    public OAuth2ServiceBindingDestinationLoader() {
        this(DEFAULT_SERVICE_RESOLVERS);
    }

    OAuth2ServiceBindingDestinationLoader(@Nonnull List<OAuth2PropertySupplierResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public static void registerPropertySupplier(@Nonnull ServiceIdentifier service, @Nonnull Function<ServiceBindingDestinationOptions, OAuth2PropertySupplier> propertySupplier) {
        log.debug("Prepending a new default resolver {} for service identifier {}.", propertySupplier, (Object)service);
        DEFAULT_SERVICE_RESOLVERS.add(0, OAuth2PropertySupplierResolver.forServiceIdentifier(service, propertySupplier));
    }

    public static void registerPropertySupplier(@Nonnull Predicate<ServiceBindingDestinationOptions> optionsMatcher, @Nonnull Function<ServiceBindingDestinationOptions, OAuth2PropertySupplier> propertySupplier) {
        log.debug("Prepending a new default resolver {} with matcher {}.", propertySupplier, optionsMatcher);
        DEFAULT_SERVICE_RESOLVERS.add(0, new OAuth2PropertySupplierResolver(optionsMatcher, propertySupplier));
    }

    static void resetPropertySuppliers() {
        log.warn("Resetting the default OAuth2 property suppliers. This should only be used in tests.");
        DEFAULT_SERVICE_RESOLVERS.clear();
        DEFAULT_SERVICE_RESOLVERS.addAll(BtpServicePropertySuppliers.getDefaultServiceResolvers());
    }

    @Nonnull
    public Try<HttpDestination> tryGetDestination(@Nonnull ServiceBindingDestinationOptions options) {
        ClientIdentity clientIdentity;
        URI tokenUri;
        URI serviceUri;
        ServiceIdentifier identifier = options.getServiceBinding().getServiceIdentifier().orElse(null);
        log.debug("Creating an OAuth2 destination for service {}.", (Object)identifier);
        OAuth2PropertySupplier propertySupplier = this.getOAuth2PropertySupplier(options);
        if (propertySupplier == null) {
            String msg = "No property mapping for the provided service %s found. You may provide your own mapping by using the static `registerPropertySupplier` method.";
            return Try.failure((Throwable)new DestinationNotFoundException(null, String.format("No property mapping for the provided service %s found. You may provide your own mapping by using the static `registerPropertySupplier` method.", identifier)));
        }
        try {
            serviceUri = propertySupplier.getServiceUri();
            tokenUri = propertySupplier.getTokenUri();
            clientIdentity = propertySupplier.getClientIdentity();
        }
        catch (DestinationAccessException e) {
            return Try.failure((Throwable)e);
        }
        catch (Exception e) {
            String msg = "Failed to retrieve OAuth2 properties for service binding of service '%s'.";
            return Try.failure((Throwable)new DestinationAccessException(String.format("Failed to retrieve OAuth2 properties for service binding of service '%s'.", identifier), (Throwable)e));
        }
        Option destinationToBeProxied = options.getOption(ServiceBindingDestinationOptions.Options.ProxyOptions.class);
        try {
            OnBehalfOf behalfOf = options.getOnBehalfOf();
            if (destinationToBeProxied.isDefined()) {
                String msg = "Using the given service {} as a proxy service to enhance destination {}.";
                log.debug("Using the given service {} as a proxy service to enhance destination {}.", (Object)identifier, destinationToBeProxied.get());
                HttpDestination dest = this.toProxiedDestination((HttpDestination)destinationToBeProxied.get(), serviceUri, tokenUri, clientIdentity, behalfOf, identifier);
                return Try.success((Object)dest);
            }
            return Try.success((Object)this.toDestination(serviceUri, tokenUri, clientIdentity, behalfOf, identifier));
        }
        catch (Exception e) {
            String msg = "Failed to instantiate OAuth destination based on given properties.";
            return Try.failure((Throwable)new DestinationAccessException("Failed to instantiate OAuth destination based on given properties.", (Throwable)e));
        }
    }

    @Nullable
    private OAuth2PropertySupplier getOAuth2PropertySupplier(@Nonnull ServiceBindingDestinationOptions options) {
        for (OAuth2PropertySupplierResolver resolver : this.resolvers) {
            Try matchTry = Try.of((CheckedFunction0 & Serializable)() -> resolver.matches(options));
            if (matchTry.isFailure()) {
                log.error("Failed to check whether binding options match the resolver.", matchTry.getCause());
                continue;
            }
            if (!((Boolean)matchTry.get()).booleanValue()) continue;
            Try supplierTry = Try.of((CheckedFunction0 & Serializable)() -> resolver.resolve(options));
            if (supplierTry.isFailure()) {
                log.error("Failed to resolve the property supplier with provided options.", supplierTry.getCause());
                continue;
            }
            Try isOAuthTry = Try.of((CheckedFunction0 & Serializable)() -> ((OAuth2PropertySupplier)supplierTry.get()).isOAuth2Binding());
            if (isOAuthTry.isFailure()) {
                log.error("Failed to check whether the property supplier supports OAuth2.", isOAuthTry.getCause());
                continue;
            }
            if (!((Boolean)isOAuthTry.get()).booleanValue()) continue;
            return (OAuth2PropertySupplier)supplierTry.get();
        }
        return null;
    }

    @Nonnull
    HttpDestination toDestination(@Nonnull URI serviceUri, @Nonnull URI tokenUri, @Nonnull ClientIdentity clientIdentity, @Nonnull OnBehalfOf behalf, @Nullable ServiceIdentifier serviceIdentifier) {
        log.debug("Creating a new OAuth2 destination for service {}.", (Object)serviceIdentifier);
        DestinationHeaderProvider headerProvider = this.createHeaderProvider(tokenUri, clientIdentity, behalf, "Authorization", serviceIdentifier);
        String idString = (String)Option.of((Object)serviceIdentifier).map(ServiceIdentifier::toString).getOrElse((Object)"unknown") + "-" + clientIdentity.getId().hashCode();
        return DefaultHttpDestination.builder((URI)serviceUri).headerProviders(new DestinationHeaderProvider[]{headerProvider}).name(idString).build();
    }

    @Nonnull
    HttpDestination toProxiedDestination(@Nonnull HttpDestination destinationToBeProxied, @Nonnull URI proxyUrl, @Nonnull URI tokenUrl, @Nonnull ClientIdentity clientIdentity, @Nonnull OnBehalfOf behalf, @Nullable ServiceIdentifier serviceIdentifier) {
        DestinationHeaderProvider headerProvider = this.createHeaderProvider(tokenUrl, clientIdentity, behalf, "Proxy-Authorization", serviceIdentifier);
        return DefaultHttpDestination.fromDestination((Destination)destinationToBeProxied).proxy(proxyUrl).headerProviders(new DestinationHeaderProvider[]{headerProvider}).buildInternal();
    }

    DestinationHeaderProvider createHeaderProvider(@Nonnull URI tokenUrl, @Nonnull ClientIdentity clientIdentity, @Nonnull OnBehalfOf behalf, @Nonnull String authHeader, @Nullable ServiceIdentifier serviceIdentifier) {
        log.debug("Creating a new OAuth2 header provider for client id {}.", (Object)clientIdentity.getId());
        OAuth2Service oAuth2Service = OAuth2Service.builder().withTokenUri(tokenUrl).withIdentity(clientIdentity).withOnBehalfOf(behalf).withTenantPropagationStrategyFrom(serviceIdentifier).build();
        return new OAuth2HeaderProvider(oAuth2Service, authHeader);
    }
}

