/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.environment.servicebinding.api.DefaultServiceBindingAccessor;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceIdentifier;
import com.sap.cloud.environment.servicebinding.api.TypedMapView;
import com.sap.cloud.environment.servicebinding.api.exception.ServiceBindingAccessException;
import com.sap.cloud.sdk.cloudplatform.exception.CloudPlatformException;
import io.spiffe.bundle.x509bundle.X509Bundle;
import io.spiffe.exception.X509SvidException;
import io.spiffe.spiffeid.TrustDomain;
import io.spiffe.svid.x509svid.X509Svid;
import io.spiffe.workloadapi.DefaultX509Source;
import io.spiffe.workloadapi.X509Source;
import io.vavr.Lazy;
import io.vavr.NotImplementedError;
import io.vavr.control.Option;
import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroTrustIdentityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZeroTrustIdentityService.class);
    static final ServiceIdentifier ZTIS_IDENTIFIER = ServiceIdentifier.of((String)"zero-trust-identity");
    private static final String DEFAULT_SOCKET_PATH = "unix:///tmp/spire-agent/public/api.sock";
    private static final String SOCKET_ENVIRONMENT_VARIABLE = "SPIFFE_ENDPOINT_SOCKET";
    private static final Duration DEFAULT_SOCKET_TIMEOUT = Duration.ofSeconds(10L);
    private static final ZeroTrustIdentityService instance = new ZeroTrustIdentityService();
    private final Lazy<X509Source> source = Lazy.of(this::initX509Source);
    private final Lazy<TypedMapView> credentials;
    private KeyStoreCache keyStoreCache = null;

    private ZeroTrustIdentityService() {
        this.credentials = Lazy.of(ZeroTrustIdentityService::loadBinding);
    }

    ZeroTrustIdentityService(@Nonnull ServiceBinding binding) {
        this.credentials = Lazy.of(() -> TypedMapView.ofCredentials((ServiceBinding)binding));
    }

    private static TypedMapView loadBinding() {
        return DefaultServiceBindingAccessor.getInstance().getServiceBindings().stream().filter(it -> ZTIS_IDENTIFIER.equals(it.getServiceIdentifier().orElse(null))).map(TypedMapView::ofCredentials).findFirst().orElseThrow(() -> new ServiceBindingAccessException("No Zero Trust Identity Service binding found."));
    }

    X509Source initX509Source() {
        TypedMapView mapView = (TypedMapView)this.credentials.get();
        if (mapView.containsKey("certPath") && mapView.containsKey("keyPath")) {
            String message = "Found 'certPath' and 'keyPath' in Zero Trust Identity Service binding. Loading X509 SVID from the given file system location. This is intended for local testing only, since the certificates will not be rotated automatically.";
            log.info("Found 'certPath' and 'keyPath' in Zero Trust Identity Service binding. Loading X509 SVID from the given file system location. This is intended for local testing only, since the certificates will not be rotated automatically.");
            return new FileSystemX509Source();
        }
        String socketPath = (String)Option.of((Object)System.getenv(SOCKET_ENVIRONMENT_VARIABLE)).getOrElse((Object)DEFAULT_SOCKET_PATH);
        log.info("Using socket path {} for ZTIS agent.", (Object)socketPath);
        DefaultX509Source.X509SourceOptions x509SourceOptions = DefaultX509Source.X509SourceOptions.builder().spiffeSocketPath(socketPath).initTimeout(DEFAULT_SOCKET_TIMEOUT).build();
        try {
            return DefaultX509Source.newSource((DefaultX509Source.X509SourceOptions)x509SourceOptions);
        }
        catch (Exception e) {
            throw new CloudPlatformException("Failed to load the certificate from the unix socket: " + socketPath, (Throwable)e);
        }
    }

    @Nonnull
    X509Svid getX509Svid() {
        try {
            X509Svid svid = ((X509Source)this.source.get()).getX509Svid();
            return Objects.requireNonNull(svid, "X.509 certificate must not be null.");
        }
        catch (Exception e) {
            String message = "Failed to load a certificate using the Zero Trust Identity service. Please ensure your application is configured correctly according to: https://sap.github.io/cloud-sdk/docs/java/features/connectivity/mtls";
            throw new CloudPlatformException("Failed to load a certificate using the Zero Trust Identity service. Please ensure your application is configured correctly according to: https://sap.github.io/cloud-sdk/docs/java/features/connectivity/mtls", (Throwable)e);
        }
    }

    @Nonnull
    public String getSpiffeId() {
        return ((TypedMapView)this.credentials.get()).getMapView("workload").getString("spiffeID");
    }

    @Nonnull
    public Option<String> getAppIdentifier() {
        TypedMapView mapView = (TypedMapView)this.credentials.get();
        return Option.some((Object)mapView).filter(m -> m.containsKey("parameters")).map(m -> m.getMapView("parameters")).filter(m -> m.containsKey("app-identifier")).map(m -> m.getString("app-identifier")).filter(s -> !s.isBlank());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public KeyStore getOrCreateKeyStore() {
        X509Svid svid = this.getX509Svid();
        if (this.isKeyStoreCached(svid)) {
            return this.keyStoreCache.keyStore();
        }
        ZeroTrustIdentityService zeroTrustIdentityService = this;
        synchronized (zeroTrustIdentityService) {
            if (this.isKeyStoreCached(svid)) {
                return this.keyStoreCache.keyStore();
            }
            this.assertSvidNotExpired(svid);
            KeyStore keyStore = this.loadKeyStore(svid);
            this.keyStoreCache = new KeyStoreCache(keyStore, svid);
            return keyStore;
        }
    }

    private void assertSvidNotExpired(@Nonnull X509Svid svid) {
        if (svid.getLeaf().getNotAfter().before(Date.from(Instant.now()))) {
            throw new IllegalStateException("The provided X509 SVID has expired. The expiry date was " + String.valueOf(svid.getLeaf().getNotAfter()) + ".");
        }
    }

    @Nonnull
    KeyStore loadKeyStore(@Nonnull X509Svid svid) {
        KeyStore keyStore;
        log.debug("Creating new KeyStore for SVID with expiration date {}", (Object)svid.getLeaf().getNotAfter());
        KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(svid.getPrivateKey(), svid.getChainArray());
        try {
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null);
            keyStore.setEntry("spiffe", privateKeyEntry, new KeyStore.PasswordProtection(new char[0]));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new CloudPlatformException("Failed to load private key entry with X.509 certificate into a KeyStore.", (Throwable)e);
        }
        return keyStore;
    }

    boolean isKeyStoreCached(@Nonnull X509Svid svid) {
        return this.keyStoreCache != null && svid.equals((Object)this.keyStoreCache.svid());
    }

    @Generated
    private ZeroTrustIdentityService(Lazy<TypedMapView> credentials) {
        this.credentials = credentials;
    }

    @Generated
    public static ZeroTrustIdentityService getInstance() {
        return instance;
    }

    private record KeyStoreCache(KeyStore keyStore, X509Svid svid) {
    }

    private class FileSystemX509Source
    implements X509Source {
        private final Lazy<X509Svid> svid = Lazy.of(this::loadFromFileSystem);

        private X509Svid loadFromFileSystem() {
            Path certPath = Path.of(((TypedMapView)ZeroTrustIdentityService.this.credentials.get()).getString("certPath"), new String[0]);
            Path keyPath = Path.of(((TypedMapView)ZeroTrustIdentityService.this.credentials.get()).getString("keyPath"), new String[0]);
            try {
                return X509Svid.load((Path)certPath, (Path)keyPath);
            }
            catch (X509SvidException e) {
                throw new CloudPlatformException("Failed to load X509 SVID from file system.", (Throwable)e);
            }
        }

        @Nonnull
        public X509Svid getX509Svid() {
            return (X509Svid)this.svid.get();
        }

        @Nonnull
        public X509Bundle getBundleForTrustDomain(@Nonnull TrustDomain trustDomain) {
            throw new NotImplementedError();
        }

        public void close() {
        }

        @Generated
        public FileSystemX509Source() {
        }
    }
}

