/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.resilience;

import com.sap.cloud.sdk.cloudplatform.resilience.CacheFilter;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceRuntimeException;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutors;
import io.vavr.control.Try;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ResilienceDecorationStrategy {
    default public void clearCache(@Nonnull ResilienceConfiguration configuration) {
        throw new UnsupportedOperationException("No implementation provided.");
    }

    default public void clearCache(@Nonnull ResilienceConfiguration configuration, @Nonnull CacheFilter filter) {
        throw new UnsupportedOperationException("No implementation provided.");
    }

    default public void clearAllCacheEntries(@Nonnull ResilienceConfiguration configuration) {
        throw new UnsupportedOperationException("No implementation provided.");
    }

    @Nonnull
    default public <T> Supplier<T> decorateSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration) {
        return this.decorateSupplier(supplier, configuration, null);
    }

    @Nullable
    default public <T> T executeSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration) {
        return this.decorateSupplier(supplier, configuration).get();
    }

    @Nonnull
    public <T> Supplier<T> decorateSupplier(@Nonnull Supplier<T> var1, @Nonnull ResilienceConfiguration var2, @Nullable Function<? super Throwable, T> var3);

    @Nullable
    default public <T> T executeSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        return this.decorateSupplier(supplier, configuration, fallbackFunction).get();
    }

    @Nonnull
    default public <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) {
        return this.decorateCallable(callable, configuration, null);
    }

    @Nullable
    default public <T> T executeCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) throws Exception {
        return this.decorateCallable(callable, configuration).call();
    }

    @Nonnull
    public <T> Callable<T> decorateCallable(@Nonnull Callable<T> var1, @Nonnull ResilienceConfiguration var2, @Nullable Function<? super Throwable, T> var3);

    @Nullable
    default public <T> T executeCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        try {
            return this.decorateCallable(callable, configuration, fallbackFunction).call();
        }
        catch (Throwable e) {
            throw new ResilienceRuntimeException("The provided fallback method threw an exception. ", e);
        }
    }

    @Nonnull
    default public <T> CompletableFuture<T> queueCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        Callable call = this.decorateCallable(callable, configuration, fallbackFunction);
        Supplier<Object> supp = () -> Try.ofCallable((Callable)call).get();
        return CompletableFuture.supplyAsync(supp, (Executor)ThreadContextExecutors.getExecutor());
    }

    @Nonnull
    default public <T> CompletableFuture<T> queueSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        Supplier<T> func = this.decorateSupplier(supplier, configuration, fallbackFunction);
        return CompletableFuture.supplyAsync(func, (Executor)ThreadContextExecutors.getExecutor());
    }
}

