/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.resilience;

import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceRuntimeException;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ResilienceIsolationKey {
    @Nullable
    private final Tenant tenant;
    @Nullable
    private final Principal principal;

    @Nonnull
    public static ResilienceIsolationKey of(@Nonnull ResilienceIsolationMode isolationMode) throws IllegalArgumentException {
        switch (isolationMode) {
            case NO_ISOLATION: {
                return new ResilienceIsolationKey(null, null);
            }
            case TENANT_REQUIRED: {
                return new ResilienceIsolationKey(ResilienceIsolationKey.getTenantRequired(), null);
            }
            case TENANT_OPTIONAL: {
                return new ResilienceIsolationKey(ResilienceIsolationKey.getTenantOptional(), null);
            }
            case PRINCIPAL_REQUIRED: {
                return new ResilienceIsolationKey(null, ResilienceIsolationKey.getPrincipalRequired());
            }
            case PRINCIPAL_OPTIONAL: {
                return new ResilienceIsolationKey(null, ResilienceIsolationKey.getPrincipalOptional());
            }
            case TENANT_AND_USER_REQUIRED: {
                return new ResilienceIsolationKey(ResilienceIsolationKey.getTenantRequired(), ResilienceIsolationKey.getPrincipalRequired());
            }
            case TENANT_AND_USER_OPTIONAL: {
                return new ResilienceIsolationKey(ResilienceIsolationKey.getTenantOptional(), ResilienceIsolationKey.getPrincipalOptional());
            }
        }
        throw new IllegalArgumentException("Unsupported isolation mode.");
    }

    private static Tenant getTenantOptional() {
        return (Tenant)TenantAccessor.tryGetCurrentTenant().getOrNull();
    }

    private static Tenant getTenantRequired() {
        return (Tenant)TenantAccessor.tryGetCurrentTenant().getOrElseThrow(failure -> new ResilienceRuntimeException((Throwable)failure));
    }

    private static Principal getPrincipalOptional() {
        return (Principal)PrincipalAccessor.tryGetCurrentPrincipal().getOrNull();
    }

    private static Principal getPrincipalRequired() {
        return (Principal)PrincipalAccessor.tryGetCurrentPrincipal().getOrElseThrow(failure -> new ResilienceRuntimeException((Throwable)failure));
    }

    @Nullable
    public Tenant getTenant() {
        return this.tenant;
    }

    @Nullable
    public Principal getPrincipal() {
        return this.principal;
    }

    public String toString() {
        return "ResilienceIsolationKey(tenant=" + this.getTenant() + ", principal=" + this.getPrincipal() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResilienceIsolationKey)) {
            return false;
        }
        ResilienceIsolationKey other = (ResilienceIsolationKey)o;
        Tenant this$tenant = this.getTenant();
        Tenant other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        Principal this$principal = this.getPrincipal();
        Principal other$principal = other.getPrincipal();
        return !(this$principal == null ? other$principal != null : !this$principal.equals(other$principal));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Tenant $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        Principal $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        return result;
    }

    private ResilienceIsolationKey(@Nullable Tenant tenant, @Nullable Principal principal) {
        this.tenant = tenant;
        this.principal = principal;
    }
}

