/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.resilience;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.cloudplatform.resilience.CacheExpirationStrategy;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

public class ResilienceConfiguration {
    @Nonnull
    private final String identifier;
    @Nonnull
    private ResilienceIsolationMode isolationMode = ResilienceIsolationMode.TENANT_AND_USER_OPTIONAL;
    @Nonnull
    private TimeLimiterConfiguration timeLimiterConfiguration = TimeLimiterConfiguration.of();
    @Nonnull
    private CircuitBreakerConfiguration circuitBreakerConfiguration = CircuitBreakerConfiguration.of();
    @Nonnull
    private BulkheadConfiguration bulkheadConfiguration = BulkheadConfiguration.of();
    @Nonnull
    private CacheConfiguration cacheConfiguration = CacheConfiguration.disabled();
    @Nonnull
    private RetryConfiguration retryConfiguration = RetryConfiguration.disabled();

    @Nonnull
    public static ResilienceConfiguration of(@Nonnull String identifier) {
        return new ResilienceConfiguration(identifier);
    }

    @Nonnull
    public static ResilienceConfiguration of(@Nonnull Class<?> serviceClass) {
        return ResilienceConfiguration.of(serviceClass.getName());
    }

    @Nonnull
    public static ResilienceConfiguration empty(@Nonnull String identifier) {
        return new ResilienceConfiguration(identifier).timeLimiterConfiguration(TimeLimiterConfiguration.disabled()).circuitBreakerConfiguration(CircuitBreakerConfiguration.disabled()).bulkheadConfiguration(BulkheadConfiguration.disabled()).retryConfiguration(RetryConfiguration.disabled()).cacheConfiguration(CacheConfiguration.disabled());
    }

    @Nonnull
    public static ResilienceConfiguration empty(@Nonnull Class<?> serviceClass) {
        return ResilienceConfiguration.empty(serviceClass.getName());
    }

    protected ResilienceConfiguration(@Nonnull String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResilienceConfiguration)) {
            return false;
        }
        ResilienceConfiguration other = (ResilienceConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$identifier = this.identifier();
        String other$identifier = other.identifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        ResilienceIsolationMode this$isolationMode = this.isolationMode();
        ResilienceIsolationMode other$isolationMode = other.isolationMode();
        if (this$isolationMode == null ? other$isolationMode != null : !((Object)((Object)this$isolationMode)).equals((Object)other$isolationMode)) {
            return false;
        }
        TimeLimiterConfiguration this$timeLimiterConfiguration = this.timeLimiterConfiguration();
        TimeLimiterConfiguration other$timeLimiterConfiguration = other.timeLimiterConfiguration();
        if (this$timeLimiterConfiguration == null ? other$timeLimiterConfiguration != null : !((Object)this$timeLimiterConfiguration).equals(other$timeLimiterConfiguration)) {
            return false;
        }
        CircuitBreakerConfiguration this$circuitBreakerConfiguration = this.circuitBreakerConfiguration();
        CircuitBreakerConfiguration other$circuitBreakerConfiguration = other.circuitBreakerConfiguration();
        if (this$circuitBreakerConfiguration == null ? other$circuitBreakerConfiguration != null : !((Object)this$circuitBreakerConfiguration).equals(other$circuitBreakerConfiguration)) {
            return false;
        }
        BulkheadConfiguration this$bulkheadConfiguration = this.bulkheadConfiguration();
        BulkheadConfiguration other$bulkheadConfiguration = other.bulkheadConfiguration();
        if (this$bulkheadConfiguration == null ? other$bulkheadConfiguration != null : !((Object)this$bulkheadConfiguration).equals(other$bulkheadConfiguration)) {
            return false;
        }
        CacheConfiguration this$cacheConfiguration = this.cacheConfiguration();
        CacheConfiguration other$cacheConfiguration = other.cacheConfiguration();
        if (this$cacheConfiguration == null ? other$cacheConfiguration != null : !((Object)this$cacheConfiguration).equals(other$cacheConfiguration)) {
            return false;
        }
        RetryConfiguration this$retryConfiguration = this.retryConfiguration();
        RetryConfiguration other$retryConfiguration = other.retryConfiguration();
        return !(this$retryConfiguration == null ? other$retryConfiguration != null : !((Object)this$retryConfiguration).equals(other$retryConfiguration));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ResilienceConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identifier = this.identifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        ResilienceIsolationMode $isolationMode = this.isolationMode();
        result = result * 59 + ($isolationMode == null ? 43 : ((Object)((Object)$isolationMode)).hashCode());
        TimeLimiterConfiguration $timeLimiterConfiguration = this.timeLimiterConfiguration();
        result = result * 59 + ($timeLimiterConfiguration == null ? 43 : ((Object)$timeLimiterConfiguration).hashCode());
        CircuitBreakerConfiguration $circuitBreakerConfiguration = this.circuitBreakerConfiguration();
        result = result * 59 + ($circuitBreakerConfiguration == null ? 43 : ((Object)$circuitBreakerConfiguration).hashCode());
        BulkheadConfiguration $bulkheadConfiguration = this.bulkheadConfiguration();
        result = result * 59 + ($bulkheadConfiguration == null ? 43 : ((Object)$bulkheadConfiguration).hashCode());
        CacheConfiguration $cacheConfiguration = this.cacheConfiguration();
        result = result * 59 + ($cacheConfiguration == null ? 43 : ((Object)$cacheConfiguration).hashCode());
        RetryConfiguration $retryConfiguration = this.retryConfiguration();
        result = result * 59 + ($retryConfiguration == null ? 43 : ((Object)$retryConfiguration).hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String identifier() {
        return this.identifier;
    }

    @Nonnull
    @Generated
    public ResilienceIsolationMode isolationMode() {
        return this.isolationMode;
    }

    @Nonnull
    @Generated
    public TimeLimiterConfiguration timeLimiterConfiguration() {
        return this.timeLimiterConfiguration;
    }

    @Nonnull
    @Generated
    public CircuitBreakerConfiguration circuitBreakerConfiguration() {
        return this.circuitBreakerConfiguration;
    }

    @Nonnull
    @Generated
    public BulkheadConfiguration bulkheadConfiguration() {
        return this.bulkheadConfiguration;
    }

    @Nonnull
    @Generated
    public CacheConfiguration cacheConfiguration() {
        return this.cacheConfiguration;
    }

    @Nonnull
    @Generated
    public RetryConfiguration retryConfiguration() {
        return this.retryConfiguration;
    }

    @Nonnull
    @Generated
    public ResilienceConfiguration isolationMode(@Nonnull ResilienceIsolationMode isolationMode) {
        if (isolationMode == null) {
            throw new NullPointerException("isolationMode is marked non-null but is null");
        }
        this.isolationMode = isolationMode;
        return this;
    }

    @Nonnull
    @Generated
    public ResilienceConfiguration timeLimiterConfiguration(@Nonnull TimeLimiterConfiguration timeLimiterConfiguration) {
        if (timeLimiterConfiguration == null) {
            throw new NullPointerException("timeLimiterConfiguration is marked non-null but is null");
        }
        this.timeLimiterConfiguration = timeLimiterConfiguration;
        return this;
    }

    @Nonnull
    @Generated
    public ResilienceConfiguration circuitBreakerConfiguration(@Nonnull CircuitBreakerConfiguration circuitBreakerConfiguration) {
        if (circuitBreakerConfiguration == null) {
            throw new NullPointerException("circuitBreakerConfiguration is marked non-null but is null");
        }
        this.circuitBreakerConfiguration = circuitBreakerConfiguration;
        return this;
    }

    @Nonnull
    @Generated
    public ResilienceConfiguration bulkheadConfiguration(@Nonnull BulkheadConfiguration bulkheadConfiguration) {
        if (bulkheadConfiguration == null) {
            throw new NullPointerException("bulkheadConfiguration is marked non-null but is null");
        }
        this.bulkheadConfiguration = bulkheadConfiguration;
        return this;
    }

    @Nonnull
    @Generated
    public ResilienceConfiguration cacheConfiguration(@Nonnull CacheConfiguration cacheConfiguration) {
        if (cacheConfiguration == null) {
            throw new NullPointerException("cacheConfiguration is marked non-null but is null");
        }
        this.cacheConfiguration = cacheConfiguration;
        return this;
    }

    @Nonnull
    @Generated
    public ResilienceConfiguration retryConfiguration(@Nonnull RetryConfiguration retryConfiguration) {
        if (retryConfiguration == null) {
            throw new NullPointerException("retryConfiguration is marked non-null but is null");
        }
        this.retryConfiguration = retryConfiguration;
        return this;
    }

    public static final class RetryConfiguration {
        public static final int DEFAULT_MAX_ATTEMPTS = 3;
        public static final Duration DEFAULT_WAIT_DURATION = Duration.ofMillis(500L);
        public static final Predicate<Throwable> DEFAULT_RETRY_ON_EXCEPTION_PREDICATE = any -> true;
        private final boolean enabled;
        private final int maxAttempts;
        @NonNull
        private Duration waitDuration = DEFAULT_WAIT_DURATION;
        @NonNull
        private Predicate<Throwable> retryOnExceptionPredicate = DEFAULT_RETRY_ON_EXCEPTION_PREDICATE;

        public boolean isEnabled() {
            return this.enabled;
        }

        @Nonnull
        @Deprecated
        public static RetryConfiguration ofDefaults() {
            return RetryConfiguration.of(3);
        }

        @Nonnull
        public static RetryConfiguration of(int maxAttempts, @Nonnull Duration waitDuration) {
            return new RetryConfiguration(true, maxAttempts, waitDuration, DEFAULT_RETRY_ON_EXCEPTION_PREDICATE);
        }

        @Nonnull
        public static RetryConfiguration of(int maxAttempts) {
            return new RetryConfiguration(true, maxAttempts);
        }

        @Nonnull
        public static RetryConfiguration disabled() {
            return new RetryConfiguration(false, 1);
        }

        @Generated
        private RetryConfiguration(boolean enabled, int maxAttempts) {
            this.enabled = enabled;
            this.maxAttempts = maxAttempts;
        }

        @Generated
        private RetryConfiguration(boolean enabled, int maxAttempts, @NonNull Duration waitDuration, @NonNull Predicate<Throwable> retryOnExceptionPredicate) {
            if (waitDuration == null) {
                throw new NullPointerException("waitDuration is marked non-null but is null");
            }
            if (retryOnExceptionPredicate == null) {
                throw new NullPointerException("retryOnExceptionPredicate is marked non-null but is null");
            }
            this.enabled = enabled;
            this.maxAttempts = maxAttempts;
            this.waitDuration = waitDuration;
            this.retryOnExceptionPredicate = retryOnExceptionPredicate;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RetryConfiguration)) {
                return false;
            }
            RetryConfiguration other = (RetryConfiguration)o;
            if (this.enabled != other.enabled) {
                return false;
            }
            if (this.maxAttempts() != other.maxAttempts()) {
                return false;
            }
            Duration this$waitDuration = this.waitDuration();
            Duration other$waitDuration = other.waitDuration();
            if (this$waitDuration == null ? other$waitDuration != null : !((Object)this$waitDuration).equals(other$waitDuration)) {
                return false;
            }
            Predicate<Throwable> this$retryOnExceptionPredicate = this.retryOnExceptionPredicate();
            Predicate<Throwable> other$retryOnExceptionPredicate = other.retryOnExceptionPredicate();
            return !(this$retryOnExceptionPredicate == null ? other$retryOnExceptionPredicate != null : !this$retryOnExceptionPredicate.equals(other$retryOnExceptionPredicate));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.enabled ? 79 : 97);
            result = result * 59 + this.maxAttempts();
            Duration $waitDuration = this.waitDuration();
            result = result * 59 + ($waitDuration == null ? 43 : ((Object)$waitDuration).hashCode());
            Predicate<Throwable> $retryOnExceptionPredicate = this.retryOnExceptionPredicate();
            result = result * 59 + ($retryOnExceptionPredicate == null ? 43 : $retryOnExceptionPredicate.hashCode());
            return result;
        }

        @Generated
        public int maxAttempts() {
            return this.maxAttempts;
        }

        @NonNull
        @Generated
        public Duration waitDuration() {
            return this.waitDuration;
        }

        @NonNull
        @Generated
        public Predicate<Throwable> retryOnExceptionPredicate() {
            return this.retryOnExceptionPredicate;
        }

        @Nonnull
        @Generated
        public RetryConfiguration waitDuration(@NonNull Duration waitDuration) {
            if (waitDuration == null) {
                throw new NullPointerException("waitDuration is marked non-null but is null");
            }
            this.waitDuration = waitDuration;
            return this;
        }

        @Nonnull
        @Generated
        public RetryConfiguration retryOnExceptionPredicate(@NonNull Predicate<Throwable> retryOnExceptionPredicate) {
            if (retryOnExceptionPredicate == null) {
                throw new NullPointerException("retryOnExceptionPredicate is marked non-null but is null");
            }
            this.retryOnExceptionPredicate = retryOnExceptionPredicate;
            return this;
        }
    }

    public static final class BulkheadConfiguration {
        public static final int DEFAULT_MAX_CONCURRENT_CALLS = 50;
        public static final Duration DEFAULT_MAX_WAIT_DURATION = Duration.ofSeconds(60L);
        private boolean enabled = true;
        private int maxConcurrentCalls = 50;
        @NonNull
        private Duration maxWaitDuration = DEFAULT_MAX_WAIT_DURATION;

        public boolean isEnabled() {
            return this.enabled;
        }

        @Nonnull
        public static BulkheadConfiguration disabled() {
            BulkheadConfiguration bulkheadConfiguration = new BulkheadConfiguration();
            bulkheadConfiguration.enabled = false;
            return bulkheadConfiguration;
        }

        @Generated
        private BulkheadConfiguration() {
        }

        @Nonnull
        @Generated
        public static BulkheadConfiguration of() {
            return new BulkheadConfiguration();
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulkheadConfiguration)) {
                return false;
            }
            BulkheadConfiguration other = (BulkheadConfiguration)o;
            if (this.enabled != other.enabled) {
                return false;
            }
            if (this.maxConcurrentCalls() != other.maxConcurrentCalls()) {
                return false;
            }
            Duration this$maxWaitDuration = this.maxWaitDuration();
            Duration other$maxWaitDuration = other.maxWaitDuration();
            return !(this$maxWaitDuration == null ? other$maxWaitDuration != null : !((Object)this$maxWaitDuration).equals(other$maxWaitDuration));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.enabled ? 79 : 97);
            result = result * 59 + this.maxConcurrentCalls();
            Duration $maxWaitDuration = this.maxWaitDuration();
            result = result * 59 + ($maxWaitDuration == null ? 43 : ((Object)$maxWaitDuration).hashCode());
            return result;
        }

        @Generated
        public int maxConcurrentCalls() {
            return this.maxConcurrentCalls;
        }

        @NonNull
        @Generated
        public Duration maxWaitDuration() {
            return this.maxWaitDuration;
        }

        @Nonnull
        @Generated
        public BulkheadConfiguration maxConcurrentCalls(int maxConcurrentCalls) {
            this.maxConcurrentCalls = maxConcurrentCalls;
            return this;
        }

        @Nonnull
        @Generated
        public BulkheadConfiguration maxWaitDuration(@NonNull Duration maxWaitDuration) {
            if (maxWaitDuration == null) {
                throw new NullPointerException("maxWaitDuration is marked non-null but is null");
            }
            this.maxWaitDuration = maxWaitDuration;
            return this;
        }
    }

    public static final class CircuitBreakerConfiguration {
        public static final float DEFAULT_FAILURE_RATE_THRESHOLD = 50.0f;
        public static final int DEFAULT_CLOSED_BUFFER_SIZE = 10;
        public static final int DEFAULT_HALF_OPEN_BUFFER_SIZE = 5;
        public static final Duration DEFAULT_WAIT_DURATION = Duration.ofSeconds(10L);
        private boolean enabled = true;
        private float failureRateThreshold = 50.0f;
        @NonNull
        private Duration waitDuration = DEFAULT_WAIT_DURATION;
        private int closedBufferSize = 10;
        private int halfOpenBufferSize = 5;

        public boolean isEnabled() {
            return this.enabled;
        }

        @Nonnull
        public static CircuitBreakerConfiguration disabled() {
            CircuitBreakerConfiguration circuitBreakerConfiguration = new CircuitBreakerConfiguration();
            circuitBreakerConfiguration.enabled = false;
            return circuitBreakerConfiguration;
        }

        @Generated
        private CircuitBreakerConfiguration() {
        }

        @Nonnull
        @Generated
        public static CircuitBreakerConfiguration of() {
            return new CircuitBreakerConfiguration();
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CircuitBreakerConfiguration)) {
                return false;
            }
            CircuitBreakerConfiguration other = (CircuitBreakerConfiguration)o;
            if (this.enabled != other.enabled) {
                return false;
            }
            if (Float.compare(this.failureRateThreshold(), other.failureRateThreshold()) != 0) {
                return false;
            }
            if (this.closedBufferSize() != other.closedBufferSize()) {
                return false;
            }
            if (this.halfOpenBufferSize() != other.halfOpenBufferSize()) {
                return false;
            }
            Duration this$waitDuration = this.waitDuration();
            Duration other$waitDuration = other.waitDuration();
            return !(this$waitDuration == null ? other$waitDuration != null : !((Object)this$waitDuration).equals(other$waitDuration));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.enabled ? 79 : 97);
            result = result * 59 + Float.floatToIntBits(this.failureRateThreshold());
            result = result * 59 + this.closedBufferSize();
            result = result * 59 + this.halfOpenBufferSize();
            Duration $waitDuration = this.waitDuration();
            result = result * 59 + ($waitDuration == null ? 43 : ((Object)$waitDuration).hashCode());
            return result;
        }

        @Generated
        public float failureRateThreshold() {
            return this.failureRateThreshold;
        }

        @NonNull
        @Generated
        public Duration waitDuration() {
            return this.waitDuration;
        }

        @Generated
        public int closedBufferSize() {
            return this.closedBufferSize;
        }

        @Generated
        public int halfOpenBufferSize() {
            return this.halfOpenBufferSize;
        }

        @Nonnull
        @Generated
        public CircuitBreakerConfiguration failureRateThreshold(float failureRateThreshold) {
            this.failureRateThreshold = failureRateThreshold;
            return this;
        }

        @Nonnull
        @Generated
        public CircuitBreakerConfiguration waitDuration(@NonNull Duration waitDuration) {
            if (waitDuration == null) {
                throw new NullPointerException("waitDuration is marked non-null but is null");
            }
            this.waitDuration = waitDuration;
            return this;
        }

        @Nonnull
        @Generated
        public CircuitBreakerConfiguration closedBufferSize(int closedBufferSize) {
            this.closedBufferSize = closedBufferSize;
            return this;
        }

        @Nonnull
        @Generated
        public CircuitBreakerConfiguration halfOpenBufferSize(int halfOpenBufferSize) {
            this.halfOpenBufferSize = halfOpenBufferSize;
            return this;
        }
    }

    public static final class TimeLimiterConfiguration {
        public static final Duration DEFAULT_TIMEOUT_DURATION = Duration.ofSeconds(30L);
        public static final boolean DEFAULT_SHOULD_CANCEL_RUNNING_FUTURE = true;
        private boolean enabled = true;
        @NonNull
        private Duration timeoutDuration = DEFAULT_TIMEOUT_DURATION;
        private boolean shouldCancelRunningFuture = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        @Nonnull
        public static TimeLimiterConfiguration disabled() {
            TimeLimiterConfiguration timeLimiterConfiguration = new TimeLimiterConfiguration();
            timeLimiterConfiguration.enabled = false;
            return timeLimiterConfiguration;
        }

        @Nonnull
        public static TimeLimiterConfiguration of(@Nonnull Duration timeoutDuration) {
            return TimeLimiterConfiguration.of().timeoutDuration(timeoutDuration);
        }

        @Generated
        private TimeLimiterConfiguration() {
        }

        @Nonnull
        @Generated
        public static TimeLimiterConfiguration of() {
            return new TimeLimiterConfiguration();
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimeLimiterConfiguration)) {
                return false;
            }
            TimeLimiterConfiguration other = (TimeLimiterConfiguration)o;
            if (this.enabled != other.enabled) {
                return false;
            }
            if (this.shouldCancelRunningFuture() != other.shouldCancelRunningFuture()) {
                return false;
            }
            Duration this$timeoutDuration = this.timeoutDuration();
            Duration other$timeoutDuration = other.timeoutDuration();
            return !(this$timeoutDuration == null ? other$timeoutDuration != null : !((Object)this$timeoutDuration).equals(other$timeoutDuration));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.enabled ? 79 : 97);
            result = result * 59 + (this.shouldCancelRunningFuture() ? 79 : 97);
            Duration $timeoutDuration = this.timeoutDuration();
            result = result * 59 + ($timeoutDuration == null ? 43 : ((Object)$timeoutDuration).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Duration timeoutDuration() {
            return this.timeoutDuration;
        }

        @Generated
        public boolean shouldCancelRunningFuture() {
            return this.shouldCancelRunningFuture;
        }

        @Nonnull
        @Generated
        public TimeLimiterConfiguration timeoutDuration(@NonNull Duration timeoutDuration) {
            if (timeoutDuration == null) {
                throw new NullPointerException("timeoutDuration is marked non-null but is null");
            }
            this.timeoutDuration = timeoutDuration;
            return this;
        }

        @Nonnull
        @Generated
        public TimeLimiterConfiguration shouldCancelRunningFuture(boolean shouldCancelRunningFuture) {
            this.shouldCancelRunningFuture = shouldCancelRunningFuture;
            return this;
        }
    }

    public static final class CacheConfiguration {
        public static final CacheExpirationStrategy DEFAULT_EXPIRATION_STRATEGY = CacheExpirationStrategy.WHEN_LAST_MODIFIED;
        private final boolean enabled;
        private boolean serializable;
        @Nonnull
        private Duration expirationDuration = Duration.ZERO;
        @Nonnull
        private CacheExpirationStrategy expirationStrategy = DEFAULT_EXPIRATION_STRATEGY;
        @Nonnull
        private Iterable<Object> parameters = Lists.newArrayList();

        public boolean isEnabled() {
            return this.enabled;
        }

        @Nonnull
        public static CacheConfigurationBuilder of(@Nonnull Duration expirationDuration) {
            return new CacheConfigurationBuilder(expirationDuration);
        }

        @Nonnull
        public static CacheConfiguration disabled() {
            return new CacheConfiguration(false);
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheConfiguration)) {
                return false;
            }
            CacheConfiguration other = (CacheConfiguration)o;
            if (this.enabled != other.enabled) {
                return false;
            }
            if (this.serializable() != other.serializable()) {
                return false;
            }
            Duration this$expirationDuration = this.expirationDuration();
            Duration other$expirationDuration = other.expirationDuration();
            if (this$expirationDuration == null ? other$expirationDuration != null : !((Object)this$expirationDuration).equals(other$expirationDuration)) {
                return false;
            }
            CacheExpirationStrategy this$expirationStrategy = this.expirationStrategy();
            CacheExpirationStrategy other$expirationStrategy = other.expirationStrategy();
            if (this$expirationStrategy == null ? other$expirationStrategy != null : !((Object)((Object)this$expirationStrategy)).equals((Object)other$expirationStrategy)) {
                return false;
            }
            Iterable<Object> this$parameters = this.parameters();
            Iterable<Object> other$parameters = other.parameters();
            return !(this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.enabled ? 79 : 97);
            result = result * 59 + (this.serializable() ? 79 : 97);
            Duration $expirationDuration = this.expirationDuration();
            result = result * 59 + ($expirationDuration == null ? 43 : ((Object)$expirationDuration).hashCode());
            CacheExpirationStrategy $expirationStrategy = this.expirationStrategy();
            result = result * 59 + ($expirationStrategy == null ? 43 : ((Object)((Object)$expirationStrategy)).hashCode());
            Iterable<Object> $parameters = this.parameters();
            result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
            return result;
        }

        @Generated
        public boolean serializable() {
            return this.serializable;
        }

        @Nonnull
        @Generated
        public Duration expirationDuration() {
            return this.expirationDuration;
        }

        @Nonnull
        @Generated
        public CacheExpirationStrategy expirationStrategy() {
            return this.expirationStrategy;
        }

        @Generated
        private CacheConfiguration(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        private CacheConfiguration(boolean enabled, boolean serializable, @Nonnull Duration expirationDuration, @Nonnull CacheExpirationStrategy expirationStrategy, @Nonnull Iterable<Object> parameters) {
            if (expirationDuration == null) {
                throw new NullPointerException("expirationDuration is marked non-null but is null");
            }
            if (expirationStrategy == null) {
                throw new NullPointerException("expirationStrategy is marked non-null but is null");
            }
            if (parameters == null) {
                throw new NullPointerException("parameters is marked non-null but is null");
            }
            this.enabled = enabled;
            this.serializable = serializable;
            this.expirationDuration = expirationDuration;
            this.expirationStrategy = expirationStrategy;
            this.parameters = parameters;
        }

        @Nonnull
        @Generated
        public Iterable<Object> parameters() {
            return this.parameters;
        }

        public static final class CacheConfigurationBuilder {
            private final Duration expirationDuration;
            private CacheExpirationStrategy expirationStrategy = DEFAULT_EXPIRATION_STRATEGY;

            @Nonnull
            public CacheConfigurationBuilder withExpirationStrategy(@Nonnull CacheExpirationStrategy expirationStrategy) {
                this.expirationStrategy = expirationStrategy;
                return this;
            }

            @Nonnull
            public CacheConfiguration withParameters(@Nonnull Serializable component, Serializable ... otherComponents) {
                ArrayList components = Lists.newArrayList((Object[])new Object[]{component});
                Collections.addAll(components, otherComponents);
                return new CacheConfiguration(true, true, this.expirationDuration, this.expirationStrategy, components);
            }

            @Nonnull
            public CacheConfiguration withParameters(@Nonnull Object component, Object ... otherComponents) {
                ArrayList components = Lists.newArrayList((Object[])new Object[]{component});
                Collections.addAll(components, otherComponents);
                return new CacheConfiguration(true, false, this.expirationDuration, this.expirationStrategy, components);
            }

            @Nonnull
            public CacheConfiguration withoutParameters() {
                return new CacheConfiguration(true, true, this.expirationDuration, this.expirationStrategy, Collections.emptyList());
            }

            @Generated
            private CacheConfigurationBuilder(Duration expirationDuration) {
                this.expirationDuration = expirationDuration;
            }
        }
    }
}

