/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.resilience;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.cloudplatform.resilience.NoResilienceDecorationStrategy;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorationStrategy;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public final class ResilienceDecorator {
    @Nonnull
    private static ResilienceDecorationStrategy decorationStrategy = ResilienceDecorator.getDefaultDecorationStrategy();

    public static void resetDecorationStrategy() {
        decorationStrategy = ResilienceDecorator.getDefaultDecorationStrategy();
    }

    private static ResilienceDecorationStrategy getDefaultDecorationStrategy() {
        return (ResilienceDecorationStrategy)FacadeLocator.getFacade(ResilienceDecorationStrategy.class).getOrElse(NoResilienceDecorationStrategy::new);
    }

    @Deprecated
    public static void invalidateCache(@Nonnull ResilienceConfiguration configuration) {
        decorationStrategy.invalidateCache(configuration);
    }

    @Beta
    public static void clearCache(@Nonnull ResilienceConfiguration configuration) {
        decorationStrategy.clearCache(configuration);
    }

    public static void clearAllCacheEntries(@Nonnull ResilienceConfiguration configuration) {
        decorationStrategy.clearAllCacheEntries(configuration);
    }

    @Nonnull
    public static <T> Supplier<T> decorateSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration) {
        return decorationStrategy.decorateSupplier(supplier, configuration);
    }

    @Nullable
    public static <T> T executeSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration) {
        return decorationStrategy.executeSupplier(supplier, configuration);
    }

    @Nonnull
    public static <T> Supplier<T> decorateSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        return decorationStrategy.decorateSupplier(supplier, configuration, fallbackFunction);
    }

    @Nullable
    public static <T> T executeSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        return decorationStrategy.executeSupplier(supplier, configuration, fallbackFunction);
    }

    @Nonnull
    public static <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) {
        return decorationStrategy.decorateCallable(callable, configuration);
    }

    @Nullable
    public static <T> T executeCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) throws Exception {
        return decorationStrategy.executeCallable(callable, configuration);
    }

    @Nonnull
    public static <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        return decorationStrategy.decorateCallable(callable, configuration, fallbackFunction);
    }

    @Nullable
    public static <T> T executeCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        return decorationStrategy.executeCallable(callable, configuration, fallbackFunction);
    }

    @Nonnull
    public static <T> CompletableFuture<T> queueCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        return decorationStrategy.queueCallable(callable, configuration, fallbackFunction, null);
    }

    @Nonnull
    public static <T> CompletableFuture<T> queueCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) {
        return decorationStrategy.queueCallable(callable, configuration, null, null);
    }

    @Nonnull
    public static <T> CompletableFuture<T> queueSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        return decorationStrategy.queueSupplier(supplier, configuration, fallbackFunction, null);
    }

    @Nonnull
    public static <T> CompletableFuture<T> queueSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration) {
        return decorationStrategy.queueSupplier(supplier, configuration, null, null);
    }

    @Nonnull
    @Generated
    public static ResilienceDecorationStrategy getDecorationStrategy() {
        return decorationStrategy;
    }

    @Generated
    public static void setDecorationStrategy(@Nonnull ResilienceDecorationStrategy decorationStrategy) {
        if (decorationStrategy == null) {
            throw new NullPointerException("decorationStrategy is marked non-null but is null");
        }
        ResilienceDecorator.decorationStrategy = decorationStrategy;
    }
}

