/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.resilience;

import com.sap.cloud.sdk.cloudplatform.exception.ObjectLookupFailedException;
import com.sap.cloud.sdk.cloudplatform.resilience.CacheFilter;
import com.sap.cloud.sdk.cloudplatform.resilience.NoResilienceDecorationStrategy;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorationStrategy;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceRuntimeException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import io.vavr.control.Try;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResilienceDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResilienceDecorator.class);
    @Nonnull
    private static Try<ResilienceDecorationStrategy> decorationStrategy = Try.of(ResilienceDecorator::getDefaultDecorationStrategy);

    @Nonnull
    public static ResilienceDecorationStrategy getDecorationStrategy() {
        return (ResilienceDecorationStrategy)decorationStrategy.getOrElseThrow(e -> new ResilienceRuntimeException(String.format("Failed to determine %s.", ResilienceDecorationStrategy.class.getName()), (Throwable)e));
    }

    public static void setDecorationStrategy(@Nonnull ResilienceDecorationStrategy decorationStrategy) {
        ResilienceDecorator.decorationStrategy = Try.success((Object)decorationStrategy);
    }

    public static void resetDecorationStrategy() {
        decorationStrategy = Try.of(ResilienceDecorator::getDefaultDecorationStrategy);
    }

    private static ResilienceDecorationStrategy getDefaultDecorationStrategy() {
        Collection facades = FacadeLocator.getFacades(ResilienceDecorationStrategy.class);
        if (facades.size() > 1) {
            String classes = facades.stream().map(f -> f.getClass().getName()).collect(Collectors.joining(", "));
            String exceptionMessage = String.format("Too many implementations of %s found. Make sure to only have a single implementation of the interface on your classpath: %s", ResilienceDecorationStrategy.class.getName(), classes);
            String logMessage = String.format("%s. Using any resilience pattern will lead to an exception at runtime UNLESS the %s is explicitly overwritten using 'ResilienceDecorator.setDecorationStrategy(ResilienceDecorationStrategy)'.", exceptionMessage, ResilienceDecorationStrategy.class.getName());
            log.warn(logMessage);
            throw new ObjectLookupFailedException(exceptionMessage);
        }
        if (facades.isEmpty()) {
            return new NoResilienceDecorationStrategy();
        }
        return (ResilienceDecorationStrategy)facades.iterator().next();
    }

    public static void clearCache(@Nonnull ResilienceConfiguration configuration) {
        ResilienceDecorator.getDecorationStrategy().clearCache(configuration);
    }

    public static void clearCache(@Nonnull ResilienceConfiguration configuration, @Nonnull CacheFilter filter) {
        ResilienceDecorator.getDecorationStrategy().clearCache(configuration, filter);
    }

    public static void clearAllCacheEntries(@Nonnull ResilienceConfiguration configuration) {
        ResilienceDecorator.getDecorationStrategy().clearAllCacheEntries(configuration);
    }

    @Nonnull
    public static <T> Supplier<T> decorateSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration) {
        return ResilienceDecorator.getDecorationStrategy().decorateSupplier(supplier, configuration);
    }

    @Nullable
    public static <T> T executeSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration) {
        return ResilienceDecorator.getDecorationStrategy().executeSupplier(supplier, configuration);
    }

    @Nonnull
    public static <T> Supplier<T> decorateSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        return ResilienceDecorator.getDecorationStrategy().decorateSupplier(supplier, configuration, fallbackFunction);
    }

    @Nullable
    public static <T> T executeSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        return ResilienceDecorator.getDecorationStrategy().executeSupplier(supplier, configuration, fallbackFunction);
    }

    @Nonnull
    public static <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) {
        return ResilienceDecorator.getDecorationStrategy().decorateCallable(callable, configuration);
    }

    @Nullable
    public static <T> T executeCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) throws Exception {
        return ResilienceDecorator.getDecorationStrategy().executeCallable(callable, configuration);
    }

    @Nonnull
    public static <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        return ResilienceDecorator.getDecorationStrategy().decorateCallable(callable, configuration, fallbackFunction);
    }

    @Nullable
    public static <T> T executeCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        return ResilienceDecorator.getDecorationStrategy().executeCallable(callable, configuration, fallbackFunction);
    }

    @Nonnull
    public static <T> CompletableFuture<T> queueCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        return ResilienceDecorator.getDecorationStrategy().queueCallable(callable, configuration, fallbackFunction);
    }

    @Nonnull
    public static <T> CompletableFuture<T> queueCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) {
        return ResilienceDecorator.getDecorationStrategy().queueCallable(callable, configuration, null);
    }

    @Nonnull
    public static <T> CompletableFuture<T> queueSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        return ResilienceDecorator.getDecorationStrategy().queueSupplier(supplier, configuration, fallbackFunction);
    }

    @Nonnull
    public static <T> CompletableFuture<T> queueSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration) {
        return ResilienceDecorator.getDecorationStrategy().queueSupplier(supplier, configuration, null);
    }
}

