/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.resilience4j;

import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationKey;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import com.sap.cloud.sdk.cloudplatform.resilience4j.BulkheadProvider;
import com.sap.cloud.sdk.cloudplatform.resilience4j.GenericDecorator;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class DefaultBulkheadProvider
implements BulkheadProvider,
GenericDecorator {
    private static final BulkheadConfig DEFAULT_BULK_HEAD_CONFIG = BulkheadConfig.custom().build();
    private final ConcurrentMap<ResilienceIsolationKey, BulkheadRegistry> bulkheadRegistries = new ConcurrentHashMap<ResilienceIsolationKey, BulkheadRegistry>();

    private BulkheadRegistry getBulkheadRegistry(@Nonnull ResilienceIsolationKey isolationKey) {
        return this.bulkheadRegistries.computeIfAbsent(isolationKey, k -> BulkheadRegistry.of((BulkheadConfig)DEFAULT_BULK_HEAD_CONFIG));
    }

    @Override
    @Nonnull
    public <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) {
        if (!configuration.bulkheadConfiguration().isEnabled()) {
            return callable;
        }
        return Bulkhead.decorateCallable((Bulkhead)this.getBulkhead(configuration), callable);
    }

    @Override
    @Nonnull
    public Bulkhead getBulkhead(@Nonnull ResilienceConfiguration configuration) {
        String identifier = configuration.identifier();
        ResilienceIsolationKey isolationKey = ResilienceIsolationKey.of((ResilienceIsolationMode)configuration.isolationMode());
        BulkheadRegistry bulkheadRegistry = this.getBulkheadRegistry(isolationKey);
        BulkheadConfig customBulkheadConfig = BulkheadConfig.custom().maxConcurrentCalls(configuration.bulkheadConfiguration().maxConcurrentCalls()).maxWaitDuration(configuration.bulkheadConfiguration().maxWaitDuration()).build();
        return bulkheadRegistry.bulkhead(identifier, customBulkheadConfig);
    }
}

