/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.resilience4j;

import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience4j.GenericDecorator;
import com.sap.cloud.sdk.cloudplatform.resilience4j.TimeLimiterProvider;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutors;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class DefaultTimeLimiterProvider
implements TimeLimiterProvider,
GenericDecorator {
    @Override
    @Nonnull
    public <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) {
        if (!configuration.timeLimiterConfiguration().isEnabled()) {
            return callable;
        }
        ThreadContextExecutor threadContextExecutor = ThreadContextExecutor.fromCurrentOrNewContext();
        Supplier<Future> futureSupplier = () -> ThreadContextExecutors.getExecutor().submit(callable, threadContextExecutor);
        TimeLimiter timeLimiter = this.getTimeLimiter(configuration);
        return TimeLimiter.decorateFutureSupplier((TimeLimiter)timeLimiter, futureSupplier);
    }

    @Override
    @Nonnull
    public TimeLimiter getTimeLimiter(@Nonnull ResilienceConfiguration configuration) {
        if (!configuration.timeLimiterConfiguration().isEnabled()) {
            throw new IllegalArgumentException("The provided resilience configuration does not set a timeout.");
        }
        return TimeLimiter.of((String)configuration.identifier(), (TimeLimiterConfig)TimeLimiterConfig.custom().timeoutDuration(configuration.timeLimiterConfiguration().timeoutDuration()).cancelRunningFuture(configuration.timeLimiterConfiguration().shouldCancelRunningFuture()).build());
    }
}

