/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.thread.Property;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import io.vavr.control.Try;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuthTokenThreadContextListener
implements ThreadContextListener {
    public static final String PROPERTY_AUTH_TOKEN = AuthTokenThreadContextListener.class.getName() + ":authToken";
    @Nullable
    private final AuthToken authToken;

    public AuthTokenThreadContextListener() {
        this.authToken = null;
    }

    public AuthTokenThreadContextListener(@Nonnull AuthToken authToken) {
        this.authToken = authToken;
    }

    public int getPriority() {
        return -7;
    }

    public void afterInitialize(@Nonnull ThreadContext threadContext, @Nullable ThreadContext parentThreadContext) {
        Try authTokenTry = this.authToken != null ? Try.success((Object)this.authToken) : (parentThreadContext != null ? parentThreadContext.getProperty(PROPERTY_AUTH_TOKEN).map(Property::getValue).orElse(AuthTokenAccessor::tryGetCurrentToken) : AuthTokenAccessor.tryGetCurrentToken());
        threadContext.setPropertyIfAbsent(PROPERTY_AUTH_TOKEN, Property.ofTry(authTokenTry));
    }

    public void beforeDestroy(@Nonnull ThreadContext threadContext, @Nullable ThreadContext parentThreadContext) {
        threadContext.removeProperty(PROPERTY_AUTH_TOKEN);
    }
}

