/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.cloudplatform.security.SecurityContextThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.thread.Property;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextAccessor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextDecorator;
import com.sap.cloud.security.token.SecurityContext;
import io.vavr.control.Try;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SecurityContextThreadContextDecorator
implements ThreadContextDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityContextThreadContextDecorator.class);
    private final int priority = -2;

    @Nonnull
    public <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable) {
        Try tryToken = ThreadContextAccessor.getCurrentContext().getProperty(SecurityContextThreadContextListener.PROPERTY_SECURITY_CONTEXT_TOKEN).map(Property::getValue).map(Objects::requireNonNull);
        return () -> {
            tryToken.peek(any -> log.debug("Passing token to SecurityContext.")).andThen(SecurityContext::setToken).onFailure(e -> log.debug("Unable to pass token to SecurityContext of current thread."));
            Object result = callable.call();
            tryToken.andThen(SecurityContext::clearToken);
            return result;
        };
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }
}

