/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.cloudplatform.thread.Property;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SecurityContextThreadContextListener
implements ThreadContextListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityContextThreadContextListener.class);
    public static final String PROPERTY_SECURITY_CONTEXT_TOKEN = SecurityContextThreadContextListener.class.getName() + ":securityContextToken";
    private final int priority = -6;
    @Nullable
    private Token token;

    public void afterInitialize(@Nonnull ThreadContext threadContext, @Nullable ThreadContext parentThreadContext) {
        Try tokenFromPreset = Option.of((Object)this.token).toTry();
        Try tokenFromParent = tokenFromPreset.orElse(() -> this.getTokenFromThreadContext(parentThreadContext));
        Try token = tokenFromParent.orElse(this::getTokenFromCurrentThread);
        threadContext.setPropertyIfAbsent(PROPERTY_SECURITY_CONTEXT_TOKEN, Property.ofTry((Try)token));
    }

    @Nonnull
    private Try<Token> getTokenFromThreadContext(@Nullable ThreadContext threadContext) {
        return Option.of((Object)threadContext).toTry().flatMap(context -> context.getProperty(PROPERTY_SECURITY_CONTEXT_TOKEN)).map(Property::getValue);
    }

    @Nonnull
    private Try<Token> getTokenFromCurrentThread() {
        return Try.of(SecurityContext::getToken).map(Objects::requireNonNull).onFailure(e -> log.debug("Failed to get token from SecurityContext of current thread.", e));
    }

    public void beforeDestroy(@Nonnull ThreadContext threadContext, @Nullable ThreadContext parentThreadContext) {
        threadContext.removeProperty(PROPERTY_SECURITY_CONTEXT_TOKEN);
    }

    @Generated
    SecurityContextThreadContextListener(@Nullable Token token) {
        this.token = token;
    }

    @Generated
    public SecurityContextThreadContextListener() {
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }
}

