/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpCfCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.security.principal.LocalScopePrefixProvider;
import io.vavr.control.Try;
import javax.annotation.Nonnull;

public class DefaultLocalScopePrefixProvider
implements LocalScopePrefixProvider {
    private ScpCfCloudPlatform getCloudPlatform() {
        CloudPlatform cloudPlatform = CloudPlatformAccessor.getCloudPlatform();
        if (!(cloudPlatform instanceof ScpCfCloudPlatform)) {
            throw new ShouldNotHappenException("The current Cloud platform is not an instance of " + ScpCfCloudPlatform.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.sdk.cloudplatform:cloudplatform-core-scp-cf.");
        }
        return (ScpCfCloudPlatform)cloudPlatform;
    }

    @Override
    @Nonnull
    public Try<String> getLocalScopePrefix() {
        return AuthTokenAccessor.tryGetCurrentToken().map(authToken -> this.getCloudPlatform().getXsuaaServiceCredentials(authToken.getJwt()).get("xsappname").getAsString() + ".");
    }
}

