/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.sap.cloud.sdk.cloudplatform.security.principal.AuthTokenPrincipalExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.BasicCredentialsPrincipalExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.DefaultPrincipalFacade;
import com.sap.cloud.sdk.cloudplatform.security.principal.LocalScopePrefixProvider;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.exception.PrincipalAccessException;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpCfPrincipalFacade
extends DefaultPrincipalFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScpCfPrincipalFacade.class);
    private final AuthTokenPrincipalExtractor authTokenPrincipalExtractor;
    private final BasicCredentialsPrincipalExtractor basicCredentialsPrincipalExtractor;

    ScpCfPrincipalFacade(AuthTokenPrincipalExtractor authTokenPrincipalExtractor, BasicCredentialsPrincipalExtractor basicCredentialsPrincipalExtractor) {
        this.authTokenPrincipalExtractor = authTokenPrincipalExtractor;
        this.basicCredentialsPrincipalExtractor = basicCredentialsPrincipalExtractor;
    }

    public ScpCfPrincipalFacade(@Nullable LocalScopePrefixProvider localScopePrefixProvider) {
        this(new AuthTokenPrincipalExtractor(localScopePrefixProvider), new BasicCredentialsPrincipalExtractor());
    }

    public ScpCfPrincipalFacade() {
        this(null);
    }

    public void setIdExtractorFunction(@Nonnull String grantType, @Nonnull CheckedFunction1<DecodedJWT, String> principalIdExtractor) {
        this.authTokenPrincipalExtractor.setIdExtractorFunction(grantType, principalIdExtractor);
    }

    @Nonnull
    public Try<Principal> tryGetCurrentPrincipal() {
        ArrayList throwables = new ArrayList();
        return super.tryGetCurrentPrincipal().onFailure(throwables::add).orElse(this.authTokenPrincipalExtractor::tryGetCurrentPrincipal).onFailure(throwables::add).orElse(this.basicCredentialsPrincipalExtractor::tryGetCurrentPrincipal).onFailure(throwables::add).orElse(() -> this.createFallbackException(throwables));
    }

    private Try<Principal> createFallbackException(@Nonnull List<? extends Throwable> throwables) {
        PrincipalAccessException resultingException = new PrincipalAccessException("Could not read a principal from neither a given JWT nor a given Basic Authentication header.");
        throwables.forEach(arg_0 -> resultingException.addSuppressed(arg_0));
        return Try.failure((Throwable)resultingException);
    }
}

