/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenFacade;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.security.DefaultAuthTokenFacade;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import com.sap.cloud.sdk.cloudplatform.thread.DefaultThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.Executable;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.thread.exception.ThreadContextExecutionException;
import io.vavr.control.Try;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthTokenAccessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthTokenAccessor.class);
    @Nonnull
    private static AuthTokenFacade authTokenFacade = new DefaultAuthTokenFacade();
    @Nullable
    private static Supplier<AuthToken> fallbackToken = null;

    public static void setAuthTokenFacade(@Nullable AuthTokenFacade requestFacade) {
        authTokenFacade = requestFacade == null ? new DefaultAuthTokenFacade() : requestFacade;
    }

    @Nonnull
    public static AuthToken getCurrentToken() throws AuthTokenAccessException {
        return (AuthToken)AuthTokenAccessor.tryGetCurrentToken().getOrElseThrow(failure -> {
            if (failure instanceof AuthTokenAccessException) {
                throw (AuthTokenAccessException)failure;
            }
            throw new AuthTokenAccessException("Failed to get current authorization token.", (Throwable)failure);
        });
    }

    @Nonnull
    public static Try<AuthToken> tryGetCurrentToken() {
        Try<AuthToken> authTokenTry = authTokenFacade.tryGetCurrentToken();
        if (authTokenTry.isFailure() && fallbackToken != null) {
            return authTokenTry.recover(failure -> {
                AuthToken fallback = fallbackToken.get();
                if (log.isWarnEnabled()) {
                    log.warn("Recovering with fallback token: " + fallback + ".", failure);
                }
                return fallback;
            });
        }
        return authTokenTry;
    }

    @Nonnull
    public static AuthToken getXsuaaServiceToken() throws TokenRequestFailedException {
        return (AuthToken)AuthTokenAccessor.tryGetXsuaaServiceToken().getOrElseThrow(throwable -> {
            if (throwable instanceof TokenRequestFailedException) {
                throw (TokenRequestFailedException)throwable;
            }
            throw new TokenRequestFailedException("Failed to get XSUAA service token.", (Throwable)throwable);
        });
    }

    @Nonnull
    public static Try<AuthToken> tryGetXsuaaServiceToken() {
        return authTokenFacade.tryGetXsuaaServiceToken();
    }

    @Nonnull
    public static Future<String> getRefreshToken(@Nonnull DecodedJWT jwt) {
        return authTokenFacade.getRefreshToken(jwt);
    }

    @Nullable
    public static <T> T executeWithAuthToken(@Nonnull AuthToken authToken, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        return (T)((ThreadContextExecutor)((ThreadContextExecutor)new ThreadContextExecutor().withThreadContext((ThreadContext)new DefaultThreadContext())).withListeners(new ThreadContextListener[]{new AuthTokenThreadContextListener(authToken)})).execute(callable);
    }

    public static void executeWithAuthToken(@Nonnull AuthToken authToken, @Nonnull Executable executable) throws ThreadContextExecutionException {
        AuthTokenAccessor.executeWithAuthToken(authToken, () -> {
            executable.execute();
            return null;
        });
    }

    @Nullable
    public static <T> T executeWithFallbackAuthToken(@Nonnull Supplier<AuthToken> fallbackAuthToken, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        Try<AuthToken> tokenTry = AuthTokenAccessor.tryGetCurrentToken();
        if (tokenTry.isSuccess()) {
            try {
                return callable.call();
            }
            catch (ThreadContextExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ThreadContextExecutionException((Throwable)e);
            }
        }
        return AuthTokenAccessor.executeWithAuthToken(fallbackAuthToken.get(), callable);
    }

    public static void executeWithFallbackAuthToken(@Nonnull Supplier<AuthToken> fallbackAuthToken, @Nonnull Executable executable) throws ThreadContextExecutionException {
        AuthTokenAccessor.executeWithFallbackAuthToken(fallbackAuthToken, () -> {
            executable.execute();
            return null;
        });
    }

    @Generated
    private AuthTokenAccessor() {
    }

    @Nonnull
    @Generated
    public static AuthTokenFacade getAuthTokenFacade() {
        return authTokenFacade;
    }

    @Nullable
    @Generated
    public static Supplier<AuthToken> getFallbackToken() {
        return fallbackToken;
    }

    @Generated
    public static void setFallbackToken(@Nullable Supplier<AuthToken> fallbackToken) {
        AuthTokenAccessor.fallbackToken = fallbackToken;
    }
}

