/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.ClientCredentialsValidator;
import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpCfCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorator;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenValidator;
import com.sap.cloud.sdk.cloudplatform.security.DefaultAuthTokenFacade;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.XsuaaToken;
import com.sap.cloud.security.token.validation.CombiningValidator;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.xsuaa.client.ClientCredentials;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.tokenflows.RefreshTokenFlow;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthTokenDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthTokenDecoder.class);
    private static final String BEARER_PREFIX = "bearer ";
    @Nonnull
    private final OAuth2TokenService tokenService;
    @Nonnull
    private final List<CombiningValidator<Token>> tokenValidators;

    AuthTokenDecoder() {
        this(DefaultAuthTokenFacade.defaultTokenService, DefaultAuthTokenFacade.defaultValidators);
    }

    private int getNumberOfAuthHeaders(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Authorization");
        int numHeaders = 0;
        if (headers != null) {
            while (headers.hasMoreElements()) {
                headers.nextElement();
                ++numHeaders;
            }
        }
        return numHeaders;
    }

    @Nonnull
    String getRefreshToken(@Nonnull String encodedJwt, @Nonnull String refreshToken) {
        Supplier tokenSupplier = ResilienceDecorator.decorateSupplier(() -> this.sendTokenRequestAndParseResponse(encodedJwt, refreshToken), (ResilienceConfiguration)ResilienceConfiguration.of(AuthTokenDecoder.class).isolationMode(ResilienceIsolationMode.NO_ISOLATION).timeLimiterConfiguration(ResilienceConfiguration.TimeLimiterConfiguration.of().timeoutDuration(Duration.ofSeconds(6L))).circuitBreakerConfiguration(ResilienceConfiguration.CircuitBreakerConfiguration.of().waitDuration(Duration.ofSeconds(6L))));
        return (String)tokenSupplier.get();
    }

    private String sendTokenRequestAndParseResponse(@Nonnull String encodedJwt, @Nonnull String refreshToken) {
        CloudPlatform cloudPlatform = CloudPlatformAccessor.getCloudPlatform();
        if (!(cloudPlatform instanceof ScpCfCloudPlatform)) {
            throw new ShouldNotHappenException("The current Cloud platform is not an instance of " + ScpCfCloudPlatform.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.sdk.cloudplatform:core-scp-cf.");
        }
        JsonObject xsuaaServiceCredentials = ((ScpCfCloudPlatform)cloudPlatform).getXsuaaServiceCredentials(JWT.decode((String)encodedJwt));
        BiFunction<String, UnaryOperator, String> fromXsuaa = (key, op) -> (String)Objects.requireNonNull(op.apply(xsuaaServiceCredentials.get(key).getAsString()), key);
        String xsuaaUrl = fromXsuaa.apply("url", UnaryOperator.identity());
        String clientId = fromXsuaa.apply("clientid", ClientCredentialsValidator::ensureClientId);
        String clientSecret = fromXsuaa.apply("clientsecret", ClientCredentialsValidator::ensureClientSecret);
        log.debug("Attempting Refresh Token Flow for with XSUAA {} and ClientID {}", (Object)xsuaaUrl, (Object)clientId);
        RefreshTokenFlow refreshTokenFlow = new XsuaaTokenFlows(this.tokenService, (OAuth2ServiceEndpointsProvider)new XsuaaDefaultEndpoints(URI.create(xsuaaUrl)), new ClientCredentials(clientId, clientSecret)).refreshTokenFlow().refreshToken(refreshToken);
        return (String)Try.of((CheckedFunction0 & Serializable)() -> refreshTokenFlow.execute().getAccessToken()).getOrElseThrow(e -> new TokenRequestFailedException("Refresh JWT request failed", (Throwable)e));
    }

    @Nonnull
    AuthToken decodeAndValidate(@Nonnull String encodedJwt, @Nullable String refreshToken) throws AuthTokenAccessException {
        AuthTokenAccessException preparedException = new AuthTokenAccessException("Failed to verify JWT bearer.");
        Optional<AuthToken> xsuaaValidatedToken = this.tokenValidators.stream().map(tokenValidator -> Try.of((CheckedFunction0 & Serializable)() -> this.validateJWTViaXSUAALibrary(encodedJwt, (Validator<Token>)tokenValidator))).peek(tokenValidation -> tokenValidation.onFailure(preparedException::addSuppressed)).peek(tokenValidation -> tokenValidation.onFailure(e -> log.debug("JWT validation attempt failed.", e))).filter(Try::isSuccess).findFirst().map(Try::get).map(AuthToken::new);
        if (xsuaaValidatedToken.isPresent()) {
            return xsuaaValidatedToken.get();
        }
        if (this.tokenValidators.isEmpty()) {
            log.warn("AuthTokenDecoder was instantiated without a token validator. Falling back to legacy mode for token validation.");
        } else {
            log.warn("XSUAA JWT validation failed. Falling back to legacy mode. Issuer and JKU properties are not supported.");
        }
        return (AuthToken)this.validateJwtViaLegacyImplementation(encodedJwt, refreshToken).map(AuthToken::new).onFailure(preparedException::addSuppressed).onFailure(e -> log.debug("JWT validation attempt failed.", e)).getOrElseThrow(t -> preparedException);
    }

    @Nonnull
    Try<AuthToken> decodeAndValidate(@Nonnull HttpServletRequest request) {
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader == null) {
            return Try.failure((Throwable)new AuthTokenAccessException("Failed to decode JWT bearer: no 'Authorization' header present in request."));
        }
        if (this.getNumberOfAuthHeaders(request) != 1) {
            return Try.failure((Throwable)new AuthTokenAccessException("Failed to decode JWT bearer: multiple 'Authorization' headers present in request."));
        }
        if (!authorizationHeader.toLowerCase(Locale.ENGLISH).startsWith(BEARER_PREFIX)) {
            return Try.failure((Throwable)new AuthTokenAccessException("Failed to decode JWT bearer: no JWT bearer present in 'Authorization' header of request."));
        }
        String tokenValue = authorizationHeader.substring(BEARER_PREFIX.length());
        return Try.of((CheckedFunction0 & Serializable)() -> this.decodeAndValidate(tokenValue, null));
    }

    private DecodedJWT validateJWTViaXSUAALibrary(@Nonnull String encodedJwt, @Nonnull Validator<Token> tokenValidator) {
        XsuaaToken token = new XsuaaToken(encodedJwt);
        ValidationResult result = tokenValidator.validate((Object)token);
        if (result.isValid()) {
            return JWT.decode((String)encodedJwt);
        }
        throw new AuthTokenAccessException("The token is invalid: " + result.getErrorDescription());
    }

    private Try<DecodedJWT> validateJwtViaLegacyImplementation(@Nonnull String encodedJwt, @Nullable String refreshToken) {
        List<RSAPublicKey> verificationKeys;
        DecodedJWT decodedJWT;
        try {
            decodedJWT = JWT.decode((String)encodedJwt);
            verificationKeys = AuthTokenValidator.getVerificationPublicKeysForJwt(decodedJWT);
        }
        catch (JWTDecodeException | AuthTokenAccessException e) {
            return Try.failure((Throwable)e);
        }
        String targetAlgorithm = decodedJWT.getAlgorithm();
        AuthTokenValidator authTokenValidator = new AuthTokenValidator(targetAlgorithm, verificationKeys);
        Optional<DecodedJWT> verifiedToken = authTokenValidator.verifyToken(encodedJwt);
        if (!verifiedToken.isPresent() && refreshToken != null) {
            String refreshedEncodedJwt = this.getRefreshToken(encodedJwt, refreshToken);
            verifiedToken = authTokenValidator.verifyToken(refreshedEncodedJwt);
        }
        return Try.of(verifiedToken::get);
    }

    @Generated
    public AuthTokenDecoder(@Nonnull OAuth2TokenService tokenService, @Nonnull List<CombiningValidator<Token>> tokenValidators) {
        if (tokenService == null) {
            throw new NullPointerException("tokenService is marked non-null but is null");
        }
        if (tokenValidators == null) {
            throw new NullPointerException("tokenValidators is marked non-null but is null");
        }
        this.tokenService = tokenService;
        this.tokenValidators = tokenValidators;
    }

    @Nonnull
    @Generated
    public OAuth2TokenService getTokenService() {
        return this.tokenService;
    }

    @Nonnull
    @Generated
    public List<CombiningValidator<Token>> getTokenValidators() {
        return this.tokenValidators;
    }
}

