/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpCfCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenDecoder;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import com.sap.cloud.security.xsuaa.client.ClientCredentials;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthTokenRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthTokenRequest.class);
    private final AuthTokenDecoder decoder;
    private final OAuth2TokenService tokenService;

    AuthTokenRequest(@Nullable AuthTokenDecoder decoder, @Nullable OAuth2TokenService tokenService) {
        this.tokenService = tokenService == null ? new DefaultOAuth2TokenService() : tokenService;
        this.decoder = decoder == null ? new AuthTokenDecoder() : decoder;
    }

    AuthTokenRequest() {
        this(null, null);
    }

    @Nonnull
    AuthToken getXsuaaServiceToken() throws TokenRequestFailedException {
        ScpCfCloudPlatform cloudPlatform = this.getCloudPlatform();
        JsonObject xsuaaCredentials = cloudPlatform.getXsuaaServiceCredentials();
        return this.getXsuaaServiceToken(xsuaaCredentials);
    }

    private AuthToken getXsuaaServiceToken(JsonObject xsuaaServiceCredentials) throws TokenRequestFailedException {
        String accessToken = (String)Try.of((CheckedFunction0 & Serializable)() -> {
            String clientId = xsuaaServiceCredentials.get("clientid").getAsString();
            String clientSecret = xsuaaServiceCredentials.get("clientsecret").getAsString();
            String xsuaaUrl = xsuaaServiceCredentials.get("url").getAsString();
            log.debug("Attempting Client Credentials Flow with XSUAA {} and ClientID {}", (Object)xsuaaUrl, (Object)clientId);
            OAuth2TokenResponse response = new XsuaaTokenFlows(this.tokenService, (OAuth2ServiceEndpointsProvider)new XsuaaDefaultEndpoints(new URI(xsuaaUrl)), new ClientCredentials(clientId, clientSecret)).clientCredentialsTokenFlow().execute();
            return response.getAccessToken();
        }).getOrElseThrow(TokenRequestFailedException::new);
        return this.decoder.decodeAndValidate(accessToken, null);
    }

    private ScpCfCloudPlatform getCloudPlatform() {
        CloudPlatform cloudPlatform = CloudPlatformAccessor.getCloudPlatform();
        if (!(cloudPlatform instanceof ScpCfCloudPlatform)) {
            throw new ShouldNotHappenException("The current Cloud platform is not an instance of " + ScpCfCloudPlatform.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.sdk.cloudplatform:cloudplatform-core-scp-cf.");
        }
        return (ScpCfCloudPlatform)cloudPlatform;
    }
}

